/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.java.framework.model;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import software.amazon.smithy.java.core.error.ErrorFault;
import software.amazon.smithy.java.core.error.ModeledException;
import software.amazon.smithy.java.core.schema.PresenceTracker;
import software.amazon.smithy.java.core.schema.Schema;
import software.amazon.smithy.java.core.schema.SchemaUtils;
import software.amazon.smithy.java.core.schema.SerializableShape;
import software.amazon.smithy.java.core.schema.ShapeBuilder;
import software.amazon.smithy.java.core.serde.ShapeDeserializer;
import software.amazon.smithy.java.core.serde.ShapeSerializer;
import software.amazon.smithy.java.core.serde.ToStringSerializer;
import software.amazon.smithy.java.framework.model.Schemas;
import software.amazon.smithy.java.framework.model.SharedSerde;
import software.amazon.smithy.java.framework.model.ValidationException$Builder$;
import software.amazon.smithy.java.framework.model.ValidationExceptionField;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.utils.SmithyGenerated;

@SmithyGenerated
public final class ValidationException
extends ModeledException {
    public static final Schema $SCHEMA = Schemas.VALIDATION_EXCEPTION;
    private static final Schema $SCHEMA_MESSAGE = $SCHEMA.member("message");
    private static final Schema $SCHEMA_FIELD_LIST = $SCHEMA.member("fieldList");
    public static final ShapeId $ID = $SCHEMA.id();
    private final transient List<ValidationExceptionField> fieldList;

    private ValidationException(Builder builder) {
        super($SCHEMA, builder.message, builder.$cause, ErrorFault.CLIENT, builder.$captureStackTrace, builder.$deserialized);
        this.fieldList = builder.fieldList == null ? null : Collections.unmodifiableList(builder.fieldList);
    }

    public List<ValidationExceptionField> fieldList() {
        if (this.fieldList == null) {
            return Collections.emptyList();
        }
        return this.fieldList;
    }

    public boolean hasFieldList() {
        return this.fieldList != null;
    }

    public String toString() {
        return ToStringSerializer.serialize((SerializableShape)this);
    }

    public void serializeMembers(ShapeSerializer serializer) {
        serializer.writeString($SCHEMA_MESSAGE, this.getMessage());
        if (this.fieldList != null) {
            serializer.writeList($SCHEMA_FIELD_LIST, this.fieldList, this.fieldList.size(), (BiConsumer)SharedSerde.ValidationExceptionFieldListSerializer.INSTANCE);
        }
    }

    public <T> T getMemberValue(Schema member) {
        return (T)(switch (member.memberIndex()) {
            case 0 -> SchemaUtils.validateSameMember((Schema)$SCHEMA_MESSAGE, (Schema)member, (Object)this.getMessage());
            case 1 -> SchemaUtils.validateSameMember((Schema)$SCHEMA_FIELD_LIST, (Schema)member, this.fieldList);
            default -> throw new IllegalArgumentException("Attempted to get non-existent member: " + member.id());
        });
    }

    public Builder toBuilder() {
        Builder builder = new Builder();
        builder.message(this.getMessage());
        builder.fieldList(this.fieldList);
        return builder;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements ShapeBuilder<ValidationException> {
        private final PresenceTracker tracker = PresenceTracker.of((Schema)$SCHEMA);
        private String message;
        private List<ValidationExceptionField> fieldList;
        private Throwable $cause;
        private Boolean $captureStackTrace;
        private boolean $deserialized;

        private Builder() {
        }

        public Schema schema() {
            return $SCHEMA;
        }

        public Builder message(String message) {
            this.message = Objects.requireNonNull(message, "message cannot be null");
            this.tracker.setMember($SCHEMA_MESSAGE);
            return this;
        }

        public Builder fieldList(List<ValidationExceptionField> fieldList) {
            this.fieldList = fieldList;
            return this;
        }

        public Builder withStackTrace() {
            this.$captureStackTrace = true;
            return this;
        }

        public Builder withoutStackTrace() {
            this.$captureStackTrace = false;
            return this;
        }

        public Builder withCause(Throwable cause) {
            this.$cause = cause;
            return this;
        }

        public ValidationException build() {
            this.tracker.validate();
            return new ValidationException(this);
        }

        public void setMemberValue(Schema member, Object value) {
            switch (member.memberIndex()) {
                case 0: {
                    this.message((String)SchemaUtils.validateSameMember((Schema)$SCHEMA_MESSAGE, (Schema)member, (Object)value));
                    break;
                }
                case 1: {
                    this.fieldList((List)SchemaUtils.validateSameMember((Schema)$SCHEMA_FIELD_LIST, (Schema)member, (Object)value));
                    break;
                }
                default: {
                    super.setMemberValue(member, value);
                }
            }
        }

        public ShapeBuilder<ValidationException> errorCorrection() {
            if (this.tracker.allSet()) {
                return this;
            }
            if (!this.tracker.checkMember($SCHEMA_MESSAGE)) {
                this.message("");
            }
            return this;
        }

        public Builder deserialize(ShapeDeserializer decoder) {
            this.$deserialized = true;
            decoder.readStruct($SCHEMA, (Object)this, (ShapeDeserializer.StructMemberConsumer)Builder$$InnerDeserializer.INSTANCE);
            return this;
        }

        public Builder deserializeMember(ShapeDeserializer decoder, Schema schema) {
            decoder.readStruct(schema.assertMemberTargetIs($SCHEMA), (Object)this, (ShapeDeserializer.StructMemberConsumer)Builder$$InnerDeserializer.INSTANCE);
            return this;
        }
    }
}

