/*
 * Decompiled with CFR 0.152.
 */
package tech.xigam.tests;

import tech.xigam.elixirapi.ElixirAPI;
import tech.xigam.elixirapi.exceptions.RequestBuildException;
import tech.xigam.elixirapi.objects.TrackObject;
import tech.xigam.elixirapi.requests.player.GetPlayingTrackRequest;
import tech.xigam.elixirapi.requests.player.PauseRequest;
import tech.xigam.elixirapi.requests.player.PlayerRequest;
import tech.xigam.elixirapi.requests.player.ResumeRequest;
import tech.xigam.elixirapi.requests.player.SkipRequest;
import tech.xigam.elixirapi.requests.queue.GetQueueRequest;
import tech.xigam.elixirapi.requests.queue.QueueRequest;
import tech.xigam.elixirapi.requests.queue.ShuffleRequest;

public final class Environment {
    private static ElixirAPI elixir;

    public static void main(String[] args) {
        if (args.length != 1) {
            System.exit(0);
        }
        elixir = ElixirAPI.create(args[0]);
        Environment.shuffleExample();
    }

    public static void playingTrackExample() {
        try {
            PlayerRequest request = new GetPlayingTrackRequest.Builder(elixir).guild("887516061266755585").build();
            request.execute(response -> {
                GetPlayingTrackRequest.Response trackResponse = (GetPlayingTrackRequest.Response)response;
                TrackObject trackObject = trackResponse.getAsTrack();
                System.out.println("Playing: " + trackObject.title);
            });
        }
        catch (RequestBuildException ignored) {
            System.out.println("Request build failed.");
        }
    }

    public static void queueExample() {
        try {
            QueueRequest request = new GetQueueRequest.Builder(elixir).guild("887516061266755585").build();
            request.execute(response -> response.getAsTrackCollection().tracks.forEach(track -> System.out.println("Queued: " + track.title)));
        }
        catch (RequestBuildException ignored) {
            System.out.println("Request build failed.");
        }
    }

    public static void pauseExample() {
        try {
            PlayerRequest request = new PauseRequest.Builder(elixir).guild("887516061266755585").build();
            request.execute(response -> {
                if (response.getResponseCode() != 200) {
                    System.out.println("Pause failed.");
                } else {
                    System.out.println("Paused.");
                }
            });
        }
        catch (RequestBuildException ignored) {
            System.out.println("Request build failed.");
        }
    }

    public static void resumeExample() {
        try {
            PlayerRequest request = new ResumeRequest.Builder(elixir).guild("887516061266755585").build();
            request.execute(response -> {
                if (response.getResponseCode() != 200) {
                    System.out.println("Resume failed.");
                } else {
                    System.out.println("Resumed.");
                }
            });
        }
        catch (RequestBuildException ignored) {
            System.out.println("Request build failed.");
        }
    }

    public static void shuffleExample() {
        try {
            QueueRequest request = new ShuffleRequest.Builder(elixir).guild("887516061266755585").build();
            request.execute(response -> {
                if (response.getResponseCode() != 200) {
                    System.out.println("Shuffle failed with code: " + response.getResponseCode());
                } else {
                    System.out.println("Shuffled.");
                }
            });
        }
        catch (RequestBuildException ignored) {
            System.out.println("Request build failed.");
        }
    }

    public static void skipExample() {
        try {
            PlayerRequest request = new SkipRequest.Builder(elixir).guild("887516061266755585").build();
            request.execute(response -> {
                if (response.getResponseCode() != 200) {
                    System.out.println("Skip failed.");
                } else {
                    System.out.println("Skipped.");
                }
            });
        }
        catch (RequestBuildException ignored) {
            System.out.println("Request build failed.");
        }
    }
}

