/*
 * Decompiled with CFR 0.152.
 */
package tech.xigam.elixirapi.requests.playlist;

import java.util.function.Consumer;
import tech.xigam.elixirapi.ElixirAPI;
import tech.xigam.elixirapi.Request;
import tech.xigam.elixirapi.Response;
import tech.xigam.elixirapi.requests.playlist.PlaylistRequest;
import tech.xigam.elixirapi.responses.PlaylistResponse;

public final class FetchPlaylistRequest
extends PlaylistRequest {
    private final String playlist;

    public FetchPlaylistRequest(ElixirAPI api, String playlist) {
        super(api);
        this.playlist = playlist;
    }

    @Override
    public void execute(Consumer<PlaylistResponse> response) {
        Request request = new Request.Builder(this.api).method(Request.Method.GET).endpoint("playlist/fetch").argument("id", this.playlist).build();
        request.execute((Response res) -> response.accept(new PlaylistResponse(res.getResponse(), res.getResponseCode())));
    }

    public static class Builder
    extends PlaylistRequest.Builder {
        public Builder(ElixirAPI api) {
            super(api);
        }

        @Override
        public FetchPlaylistRequest build() {
            return new FetchPlaylistRequest(this.api, this.playlist);
        }
    }
}

