/*
 * Decompiled with CFR 0.152.
 */
package ca.snappay.openapi;

import ca.snappay.openapi.OpenApiClient;
import ca.snappay.openapi.OpenApiException;
import ca.snappay.openapi.config.ConfigurationHolder;
import ca.snappay.openapi.config.OpenApiConfigurationExcepiton;
import ca.snappay.openapi.config.provider.DefaultConfigurationProvider;
import ca.snappay.openapi.request.OpenApiRequest;
import ca.snappay.openapi.response.OpenApiResponse;
import ca.snappay.openapi.sign.SignHandler;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

public class DefaultOpenApiClient
implements OpenApiClient {
    private static final Log log = LogFactory.getLog(DefaultOpenApiClient.class);
    private static final String GATEWAY_PATH = "/api/gateway";
    private final ConfigurationHolder config;
    private final URI requestUri;
    private final CloseableHttpClient httpClient;

    public DefaultOpenApiClient(ConfigurationHolder config) throws OpenApiConfigurationExcepiton {
        this.config = config;
        this.config.validate();
        this.httpClient = HttpClients.createDefault();
        try {
            this.requestUri = new URIBuilder().setScheme("https").setHost(config.getGatewayHost()).setPath(GATEWAY_PATH).build();
        }
        catch (URISyntaxException e) {
            throw new OpenApiConfigurationExcepiton("Gateway host is invalid", e);
        }
    }

    public DefaultOpenApiClient() throws OpenApiConfigurationExcepiton {
        this(DefaultConfigurationProvider.create().resolveConfiguration());
    }

    @Override
    public <T extends OpenApiResponse> T execute(OpenApiRequest<T> request) throws OpenApiException {
        request.validate();
        JsonObject requestParams = SignHandler.GSON.toJsonTree(request).getAsJsonObject();
        this.buildCommonParameters(request.getRequestMethod(), request.needMerchant(), requestParams);
        String signStr = SignHandler.sign(this.config, requestParams);
        if (StringUtils.isEmpty((String)signStr)) {
            throw new OpenApiException("-101", "Sign failed");
        }
        requestParams.addProperty("sign", signStr);
        String resultStr = null;
        CloseableHttpResponse response = null;
        try {
            String requestStr = SignHandler.GSON.toJson((JsonElement)requestParams);
            log.debug((Object)("Request to OpenAPI gateway, send data[" + requestStr + "]"));
            StringEntity body = new StringEntity(requestStr, ContentType.APPLICATION_JSON);
            HttpPost post = new HttpPost(this.requestUri);
            post.addHeader("Accept-Language", this.config.getLanguage().getLanguage());
            post.setEntity((HttpEntity)body);
            response = this.httpClient.execute((HttpUriRequest)post);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                throw new OpenApiException("-102", "Request to OpenAPI gateway failed with status code " + statusCode);
            }
            HttpEntity entity = response.getEntity();
            resultStr = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
            log.debug((Object)("Response from OpenAPI gateway, receive data[" + resultStr + "]"));
        }
        catch (Exception e) {
            log.error((Object)"Request to OpenAPI gateway failed", (Throwable)e);
            throw new OpenApiException("-102", "Request to open service gateway fail");
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException iOException) {}
            }
        }
        JsonObject resultJson = JsonParser.parseString((String)resultStr).getAsJsonObject();
        boolean isPass = SignHandler.verifySign(this.config, resultJson);
        if (!isPass) {
            throw new OpenApiException("-103", "Response data signature is not valid");
        }
        OpenApiResponse resp = (OpenApiResponse)SignHandler.GSON.fromJson((JsonElement)resultJson, request.getResponseClass());
        return (T)resp;
    }

    private void buildCommonParameters(String requestMethod, boolean needMerchant, JsonObject requestParams) {
        requestParams.addProperty("app_id", this.config.getAppId());
        requestParams.addProperty("method", requestMethod);
        if (needMerchant) {
            requestParams.addProperty("merchant_no", this.config.getMerchantNo());
        }
        requestParams.addProperty("format", this.config.getFormat());
        requestParams.addProperty("charset", this.config.getCharset());
        requestParams.addProperty("version", this.config.getVersion());
        requestParams.addProperty("sign_type", this.config.getSignType().name());
    }
}

