/*
 * Decompiled with CFR 0.152.
 */
package ca.snappay.openapi.config;

import ca.snappay.openapi.config.OpenApiConfigurationExcepiton;
import ca.snappay.openapi.constant.Language;
import ca.snappay.openapi.constant.SignType;
import org.apache.commons.lang.StringUtils;

public interface ConfigurationHolder {
    public String getGatewayHost();

    public String getAppId();

    public String getMerchantNo();

    default public String getFormat() {
        return "JSON";
    }

    default public String getCharset() {
        return "UTF-8";
    }

    default public String getVersion() {
        return "1.0";
    }

    public Language getLanguage();

    public SignType getSignType();

    public String getPublicKey();

    public String getPrivateKey();

    default public void validate() throws OpenApiConfigurationExcepiton {
        if (StringUtils.isEmpty((String)this.getGatewayHost())) {
            throw new OpenApiConfigurationExcepiton("Gateway host is not configured");
        }
        if (StringUtils.isEmpty((String)this.getAppId())) {
            throw new OpenApiConfigurationExcepiton("App ID is not configured");
        }
        if (StringUtils.isEmpty((String)this.getMerchantNo())) {
            throw new OpenApiConfigurationExcepiton("Merchant number is not configured");
        }
        if (StringUtils.isEmpty((String)this.getFormat())) {
            throw new OpenApiConfigurationExcepiton("Format is not configured");
        }
        if (StringUtils.isEmpty((String)this.getCharset())) {
            throw new OpenApiConfigurationExcepiton("Charset is not configured");
        }
        if (this.getLanguage() == null) {
            throw new OpenApiConfigurationExcepiton("Language is not configured");
        }
        if (this.getSignType() == null) {
            throw new OpenApiConfigurationExcepiton("Signature type is not configured");
        }
        if (StringUtils.isEmpty((String)this.getPrivateKey())) {
            throw new OpenApiConfigurationExcepiton("Private key is not configured");
        }
        if (SignType.RSA == this.getSignType() && StringUtils.isEmpty((String)this.getPublicKey())) {
            throw new OpenApiConfigurationExcepiton("Public key is not configured");
        }
    }
}

