/*
 * Decompiled with CFR 0.152.
 */
package ca.snappay.openapi.config.provider;

import ca.snappay.openapi.config.BasicConfigurationHolder;
import ca.snappay.openapi.config.ConfigurationHolder;
import ca.snappay.openapi.config.ConfigurationProvider;
import ca.snappay.openapi.config.OpenApiConfigurationExcepiton;
import ca.snappay.openapi.config.provider.SystemSetting;
import ca.snappay.openapi.constant.Language;
import ca.snappay.openapi.constant.SignType;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;

public abstract class SystemSettingsConfigurationProvider
implements ConfigurationProvider {
    @Override
    public ConfigurationHolder resolveConfiguration() {
        String gatewayHost = StringUtils.trim((String)this.loadSetting(SystemSetting.SNAPPAY_GATEWAY_HOST).orElse(SystemSetting.SNAPPAY_GATEWAY_HOST.defaultValue()));
        String merchantNo = StringUtils.trim((String)this.loadSetting(SystemSetting.SNAPPAY_MERCHANT_NO).orElse(null));
        String appId = StringUtils.trim((String)this.loadSetting(SystemSetting.SNAPPAY_APP_ID).orElse(null));
        String language = StringUtils.trim((String)this.loadSetting(SystemSetting.SNAPPAY_LANGUAGE).orElse(SystemSetting.SNAPPAY_LANGUAGE.defaultValue()));
        String signType = StringUtils.trim((String)this.loadSetting(SystemSetting.SNAPPAY_SIGN_TYPE).orElse(SystemSetting.SNAPPAY_SIGN_TYPE.defaultValue()));
        String publicKey = StringUtils.trim((String)this.loadSetting(SystemSetting.SNAPPAY_PUBLIC_KEY).orElse(null));
        String privateKey = StringUtils.trim((String)this.loadSetting(SystemSetting.SNAPPAY_PRIVATE_KEY).orElse(null));
        if (gatewayHost == null) {
            throw new OpenApiConfigurationExcepiton("Gateway host is missing from configuration");
        }
        if (merchantNo == null) {
            throw new OpenApiConfigurationExcepiton("Merchant number is missing from configuration");
        }
        if (appId == null) {
            throw new OpenApiConfigurationExcepiton("App ID is missing from configuration");
        }
        Language lang = Language.getForLanguage(language);
        if (lang == null) {
            throw new OpenApiConfigurationExcepiton("Language is not valid");
        }
        SignType sign = SignType.valueOf(signType);
        if (sign == null) {
            throw new OpenApiConfigurationExcepiton("Sign type is not valid");
        }
        if (privateKey == null) {
            throw new OpenApiConfigurationExcepiton("Private key is missing from configuration");
        }
        if (sign == SignType.RSA && publicKey == null) {
            throw new OpenApiConfigurationExcepiton("Public key is missing from configuration");
        }
        BasicConfigurationHolder config = new BasicConfigurationHolder();
        config.setGatewayHost(gatewayHost);
        config.setMerchantNo(merchantNo);
        config.setAppId(appId);
        config.setLanguage(lang);
        config.setSignType(sign);
        config.setPublicKey(publicKey);
        config.setPrivateKey(privateKey);
        return config;
    }

    protected abstract Optional<String> loadSetting(SystemSetting var1);
}

