/*
 * Decompiled with CFR 0.152.
 */
package ca.snappay.openapi.request.order;

import ca.snappay.openapi.request.order.AbstractOrderRequest;
import ca.snappay.openapi.response.order.RefundOrderResponse;
import com.google.gson.annotations.SerializedName;

public class RefundOrderRequest
extends AbstractOrderRequest<RefundOrderResponse> {
    private static final String REQUEST_METHOD = "pay.orderrefund";
    @SerializedName(value="out_refund_no")
    private String refundOrderNo;
    @SerializedName(value="refund_amount")
    private Double refundAmount;
    @SerializedName(value="refund_desc")
    private String refundDescription;

    @Override
    public String getRequestMethod() {
        return REQUEST_METHOD;
    }

    @Override
    public void validate() {
        super.validate();
        this.validateRequired("refundOrderNo", this.refundOrderNo);
        this.validateLength("refundOrderNo", this.refundOrderNo, 64);
        this.validateRequired("refundAmount", this.refundAmount);
        this.validateRange("refundAmount", this.refundAmount, 0.0, 1.0E8);
        this.validateLength("refundDescription", this.refundDescription, 64);
    }

    public String getRefundOrderNo() {
        return this.refundOrderNo;
    }

    public Double getRefundAmount() {
        return this.refundAmount;
    }

    public String getRefundDescription() {
        return this.refundDescription;
    }

    public void setRefundOrderNo(String refundOrderNo) {
        this.refundOrderNo = refundOrderNo;
    }

    public void setRefundAmount(Double refundAmount) {
        this.refundAmount = refundAmount;
    }

    public void setRefundDescription(String refundDescription) {
        this.refundDescription = refundDescription;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RefundOrderRequest)) {
            return false;
        }
        RefundOrderRequest other = (RefundOrderRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$refundOrderNo = this.getRefundOrderNo();
        String other$refundOrderNo = other.getRefundOrderNo();
        if (this$refundOrderNo == null ? other$refundOrderNo != null : !this$refundOrderNo.equals(other$refundOrderNo)) {
            return false;
        }
        Double this$refundAmount = this.getRefundAmount();
        Double other$refundAmount = other.getRefundAmount();
        if (this$refundAmount == null ? other$refundAmount != null : !((Object)this$refundAmount).equals(other$refundAmount)) {
            return false;
        }
        String this$refundDescription = this.getRefundDescription();
        String other$refundDescription = other.getRefundDescription();
        return !(this$refundDescription == null ? other$refundDescription != null : !this$refundDescription.equals(other$refundDescription));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof RefundOrderRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $refundOrderNo = this.getRefundOrderNo();
        result = result * 59 + ($refundOrderNo == null ? 43 : $refundOrderNo.hashCode());
        Double $refundAmount = this.getRefundAmount();
        result = result * 59 + ($refundAmount == null ? 43 : ((Object)$refundAmount).hashCode());
        String $refundDescription = this.getRefundDescription();
        result = result * 59 + ($refundDescription == null ? 43 : $refundDescription.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "RefundOrderRequest(refundOrderNo=" + this.getRefundOrderNo() + ", refundAmount=" + this.getRefundAmount() + ", refundDescription=" + this.getRefundDescription() + ")";
    }
}

