/*
 * Decompiled with CFR 0.152.
 */
package ca.snappay.openapi.request.pay;

import ca.snappay.openapi.constant.PaymentChannelTradeType;
import ca.snappay.openapi.constant.PaymentMethod;
import ca.snappay.openapi.request.pay.AbstractPayRequest;
import ca.snappay.openapi.response.pay.H5PayResponse;
import com.google.gson.annotations.SerializedName;

public class H5PayRequest
extends AbstractPayRequest<H5PayResponse> {
    private static final String REQUEST_METHOD = "pay.h5pay";
    @SerializedName(value="pay_channel_trade_type")
    private PaymentChannelTradeType tradeType;
    @SerializedName(value="pay_user_account_id")
    private String userAccountId;
    @SerializedName(value="return_url")
    private String returnUrl;

    @Override
    public String getRequestMethod() {
        return REQUEST_METHOD;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.getPaymentMethod() == PaymentMethod.UNIODPAY) {
            throw new IllegalArgumentException("UnionPay does not support H5 payment");
        }
        if (this.getPaymentMethod() == PaymentMethod.WECHATPAY && this.tradeType == PaymentChannelTradeType.JSAPI) {
            throw new IllegalArgumentException("WeChat does not support JSAPI payment");
        }
        if (this.tradeType == PaymentChannelTradeType.JSAPI) {
            this.validateRequired("userAccountId", this.userAccountId);
            this.validateLength("userAccountId", this.userAccountId, 64);
        }
        this.validateLength("returnUrl", this.returnUrl, 256);
    }

    public PaymentChannelTradeType getTradeType() {
        return this.tradeType;
    }

    public String getUserAccountId() {
        return this.userAccountId;
    }

    public String getReturnUrl() {
        return this.returnUrl;
    }

    public void setTradeType(PaymentChannelTradeType tradeType) {
        this.tradeType = tradeType;
    }

    public void setUserAccountId(String userAccountId) {
        this.userAccountId = userAccountId;
    }

    public void setReturnUrl(String returnUrl) {
        this.returnUrl = returnUrl;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof H5PayRequest)) {
            return false;
        }
        H5PayRequest other = (H5PayRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        PaymentChannelTradeType this$tradeType = this.getTradeType();
        PaymentChannelTradeType other$tradeType = other.getTradeType();
        if (this$tradeType == null ? other$tradeType != null : !((Object)((Object)this$tradeType)).equals((Object)other$tradeType)) {
            return false;
        }
        String this$userAccountId = this.getUserAccountId();
        String other$userAccountId = other.getUserAccountId();
        if (this$userAccountId == null ? other$userAccountId != null : !this$userAccountId.equals(other$userAccountId)) {
            return false;
        }
        String this$returnUrl = this.getReturnUrl();
        String other$returnUrl = other.getReturnUrl();
        return !(this$returnUrl == null ? other$returnUrl != null : !this$returnUrl.equals(other$returnUrl));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof H5PayRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PaymentChannelTradeType $tradeType = this.getTradeType();
        result = result * 59 + ($tradeType == null ? 43 : ((Object)((Object)$tradeType)).hashCode());
        String $userAccountId = this.getUserAccountId();
        result = result * 59 + ($userAccountId == null ? 43 : $userAccountId.hashCode());
        String $returnUrl = this.getReturnUrl();
        result = result * 59 + ($returnUrl == null ? 43 : $returnUrl.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "H5PayRequest(tradeType=" + (Object)((Object)this.getTradeType()) + ", userAccountId=" + this.getUserAccountId() + ", returnUrl=" + this.getReturnUrl() + ")";
    }
}

