/*
 * Decompiled with CFR 0.152.
 */
package ca.snappay.openapi.request.pay;

import ca.snappay.openapi.constant.PaymentMethod;
import ca.snappay.openapi.request.pay.AbstractPayRequest;
import ca.snappay.openapi.response.pay.NativePayResponse;
import com.google.gson.annotations.SerializedName;

public class NativePayRequest
extends AbstractPayRequest<NativePayResponse> {
    private static final String REQUEST_METHOD = "pay.inapppay";
    @SerializedName(value="refer_url")
    private String referUrl;

    @Override
    public String getRequestMethod() {
        return REQUEST_METHOD;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.getPaymentMethod() == PaymentMethod.UNIODPAY) {
            throw new IllegalArgumentException("UnionPay does not support native payment");
        }
        this.validateRequired("referUrl", this.referUrl);
        this.validateLength("referUrl", this.referUrl, 256);
    }

    public String getReferUrl() {
        return this.referUrl;
    }

    public void setReferUrl(String referUrl) {
        this.referUrl = referUrl;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NativePayRequest)) {
            return false;
        }
        NativePayRequest other = (NativePayRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$referUrl = this.getReferUrl();
        String other$referUrl = other.getReferUrl();
        return !(this$referUrl == null ? other$referUrl != null : !this$referUrl.equals(other$referUrl));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof NativePayRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $referUrl = this.getReferUrl();
        result = result * 59 + ($referUrl == null ? 43 : $referUrl.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "NativePayRequest(referUrl=" + this.getReferUrl() + ")";
    }
}

