/*
 * Decompiled with CFR 0.152.
 */
package dev.argon.esexpr.codecs;

import dev.argon.esexpr.DecodeException;
import dev.argon.esexpr.ESExpr;
import dev.argon.esexpr.ESExprCodec;
import dev.argon.esexpr.ESExprCodecTags;
import dev.argon.esexpr.ESExprOverrideCodec;
import dev.argon.esexpr.ESExprTag;
import dev.argon.esexpr.ESExprTagSet;
import org.eclipse.collections.api.list.primitive.ImmutableByteList;

public class ImmutableByteListCodec
extends ESExprCodec<ImmutableByteList> {
    @ESExprOverrideCodec(value=ImmutableByteList.class)
    @ESExprCodecTags(scalar={ESExprTag.Scalar.ARRAY8})
    public static final ESExprCodec<ImmutableByteList> INSTANCE = new ImmutableByteListCodec();

    private ImmutableByteListCodec() {
    }

    @Override
    public ESExprTagSet tags() {
        return ESExprTagSet.of(ESExprTag.ARRAY8);
    }

    @Override
    public boolean isEncodedEqual(ImmutableByteList x, ImmutableByteList y) {
        return x.equals((Object)y);
    }

    @Override
    public ESExpr encode(ImmutableByteList value) {
        return new ESExpr.Array8(value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ImmutableByteList decode(ESExpr expr, ESExprCodec.FailurePath path) throws DecodeException {
        if (!(expr instanceof ESExpr.Array8)) throw new DecodeException("Expected an array8 value", path);
        ESExpr.Array8 array8 = (ESExpr.Array8)expr;
        try {
            ImmutableByteList immutableByteList = array8.b();
            return immutableByteList;
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
    }
}

