/*
 * Decompiled with CFR 0.152.
 */
package dev.argon.esexpr.codecs;

import dev.argon.esexpr.DecodeException;
import dev.argon.esexpr.ESExpr;
import dev.argon.esexpr.ESExprCodec;
import dev.argon.esexpr.ESExprCodecTags;
import dev.argon.esexpr.ESExprOverrideCodec;
import dev.argon.esexpr.ESExprTag;
import dev.argon.esexpr.ESExprTagSet;
import org.eclipse.collections.api.list.primitive.ImmutableShortList;

public class ImmutableShortListCodec
extends ESExprCodec<ImmutableShortList> {
    @ESExprOverrideCodec(value=ImmutableShortList.class)
    @ESExprCodecTags(scalar={ESExprTag.Scalar.ARRAY16})
    public static final ESExprCodec<ImmutableShortList> INSTANCE = new ImmutableShortListCodec();

    private ImmutableShortListCodec() {
    }

    @Override
    public ESExprTagSet tags() {
        return ESExprTagSet.of(ESExprTag.ARRAY16);
    }

    @Override
    public boolean isEncodedEqual(ImmutableShortList x, ImmutableShortList y) {
        return x.equals((Object)y);
    }

    @Override
    public ESExpr encode(ImmutableShortList value) {
        return new ESExpr.Array16(value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ImmutableShortList decode(ESExpr expr, ESExprCodec.FailurePath path) throws DecodeException {
        if (!(expr instanceof ESExpr.Array16)) throw new DecodeException("Expected an array16 value", path);
        ESExpr.Array16 array16 = (ESExpr.Array16)expr;
        try {
            ImmutableShortList immutableShortList = array16.b();
            return immutableShortList;
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
    }
}

