/*
 * Decompiled with CFR 0.152.
 */
package dev.tinyflow.core.node;

import com.agentsflex.core.chain.Chain;
import com.agentsflex.core.chain.ChainNode;
import com.agentsflex.core.chain.DataType;
import com.agentsflex.core.chain.Parameter;
import com.agentsflex.core.chain.node.BaseNode;
import com.agentsflex.core.llm.client.OkHttpClientUtil;
import com.agentsflex.core.prompt.template.TextPromptTemplate;
import com.agentsflex.core.util.StringUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import dev.tinyflow.core.file.FileStorage;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class HttpNode
extends BaseNode {
    private String url;
    private String method;
    private List<Parameter> headers;
    private String bodyType;
    private List<Parameter> formData;
    private List<Parameter> formUrlencoded;
    private String bodyJson;
    private String rawBody;
    private FileStorage fileStorage;

    public static String mapToQueryString(Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (String key : map.keySet()) {
            if (StringUtil.noText((String)key)) continue;
            if (stringBuilder.length() > 0) {
                stringBuilder.append("&");
            }
            stringBuilder.append(key.trim());
            stringBuilder.append("=");
            Object value = map.get(key);
            stringBuilder.append(value == null ? "" : HttpNode.urlEncode(value.toString().trim()));
        }
        return stringBuilder.toString();
    }

    public static String urlEncode(String string) {
        try {
            return URLEncoder.encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public List<Parameter> getHeaders() {
        return this.headers;
    }

    public void setHeaders(List<Parameter> headers) {
        this.headers = headers;
    }

    public String getBodyType() {
        return this.bodyType;
    }

    public void setBodyType(String bodyType) {
        this.bodyType = bodyType;
    }

    public List<Parameter> getFormData() {
        return this.formData;
    }

    public void setFormData(List<Parameter> formData) {
        this.formData = formData;
    }

    public List<Parameter> getFormUrlencoded() {
        return this.formUrlencoded;
    }

    public void setFormUrlencoded(List<Parameter> formUrlencoded) {
        this.formUrlencoded = formUrlencoded;
    }

    public String getBodyJson() {
        return this.bodyJson;
    }

    public void setBodyJson(String bodyJson) {
        this.bodyJson = bodyJson;
    }

    public String getRawBody() {
        return this.rawBody;
    }

    public void setRawBody(String rawBody) {
        this.rawBody = rawBody;
    }

    public FileStorage getFileStorage() {
        return this.fileStorage;
    }

    public void setFileStorage(FileStorage fileStorage) {
        this.fileStorage = fileStorage;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Map<String, Object> execute(Chain chain) {
        Map argsMap = chain.getParameterValues((ChainNode)this);
        String newUrl = TextPromptTemplate.of((String)this.url).formatToString(argsMap);
        Request.Builder reqBuilder = new Request.Builder().url(newUrl);
        Map headersMap = chain.getParameterValues((ChainNode)this, this.headers, argsMap);
        headersMap.forEach((s, o) -> reqBuilder.addHeader(s, String.valueOf(o)));
        if (StringUtil.noText((String)this.method) || "GET".equalsIgnoreCase(this.method)) {
            reqBuilder.method("GET", null);
        } else {
            reqBuilder.method(this.method.toUpperCase(), this.getRequestBody(chain, argsMap));
        }
        OkHttpClient okHttpClient = OkHttpClientUtil.buildDefaultClient();
        try (Response response = okHttpClient.newCall(reqBuilder.build()).execute();){
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("statusCode", response.code());
            HashMap<String, String> responseHeaders = new HashMap<String, String>();
            Headers headers = response.headers();
            for (Object name : headers.names()) {
                responseHeaders.put((String)name, response.header((String)name));
            }
            result.put("headers", responseHeaders);
            ResponseBody body = response.body();
            if (body == null) {
                Object name;
                result.put("body", null);
                name = result;
                return name;
            }
            DataType bodyDataType = null;
            List outputDefs = this.getOutputDefs();
            if (outputDefs != null) {
                for (Parameter outputDef : outputDefs) {
                    if (!"body".equalsIgnoreCase(outputDef.getName())) continue;
                    bodyDataType = outputDef.getDataType();
                    break;
                }
            }
            if (bodyDataType == null) {
                result.put("body", body.string());
            } else if (bodyDataType == DataType.Object || bodyDataType.getValue().startsWith("Array")) {
                result.put("body", JSON.parse((String)body.string()));
            } else if (bodyDataType == DataType.File) {
                try (InputStream stream = body.byteStream();){
                    String fileUrl = this.fileStorage.saveFile(stream, responseHeaders);
                    result.put("body", fileUrl);
                }
            } else {
                result.put("body", body.string());
            }
            HashMap<String, Object> hashMap = result;
            return hashMap;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private RequestBody getRequestBody(Chain chain, Map<String, Object> formatArgs) {
        if ("json".equals(this.bodyType)) {
            String bodyJsonString = TextPromptTemplate.of((String)this.bodyJson).formatToString(formatArgs, true);
            JSONObject jsonObject = JSON.parseObject((String)bodyJsonString);
            return RequestBody.create((String)jsonObject.toString(), (MediaType)MediaType.parse((String)"application/json"));
        }
        if ("x-www-form-urlencoded".equals(this.bodyType)) {
            Map formUrlencodedMap = chain.getParameterValues((ChainNode)this, this.formUrlencoded);
            String bodyString = HttpNode.mapToQueryString(formUrlencodedMap);
            return RequestBody.create((String)bodyString, (MediaType)MediaType.parse((String)"application/x-www-form-urlencoded"));
        }
        if ("form-data".equals(this.bodyType)) {
            Map formDataMap = chain.getParameterValues((ChainNode)this, this.formData, formatArgs);
            MultipartBody.Builder builder = new MultipartBody.Builder().setType(MultipartBody.FORM);
            formDataMap.forEach((s, o) -> builder.addFormDataPart(s, String.valueOf(o)));
            return builder.build();
        }
        if ("raw".equals(this.bodyType)) {
            String rawBodyString = TextPromptTemplate.of((String)this.rawBody).formatToString(formatArgs);
            return RequestBody.create((String)rawBodyString, null);
        }
        return RequestBody.create((String)"", null);
    }

    public String toString() {
        return "HttpNode{url='" + this.url + '\'' + ", method='" + this.method + '\'' + ", headers=" + this.headers + ", bodyType='" + this.bodyType + '\'' + ", fromData=" + this.formData + ", fromUrlencoded=" + this.formUrlencoded + ", bodyJson='" + this.bodyJson + '\'' + ", rawBody='" + this.rawBody + '\'' + ", parameters=" + this.parameters + ", outputDefs=" + this.outputDefs + ", id='" + this.id + '\'' + ", name='" + this.name + '\'' + ", description='" + this.description + '\'' + ", async=" + this.async + ", inwardEdges=" + this.inwardEdges + ", outwardEdges=" + this.outwardEdges + ", condition=" + this.condition + ", memory=" + this.memory + ", nodeStatus=" + this.nodeStatus + '}';
    }
}

