/*
 * Decompiled with CFR 0.152.
 */
package im.actor.api;

import im.actor.api.scheme.encrypted.PlainMessage;
import im.actor.api.scheme.encrypted.PlainPackage;
import im.actor.api.scheme.encrypted.TextMessage;
import im.actor.api.util.StreamingUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.CRC32;

public class EncryptedMessageHelper {
    private static final int TYPE_PLAIN_MESSAGE = 1;
    private static final int TYPE_TEXT = 1;
    private static final int TYPE_FILE = 2;

    public static byte[] createTextMessage(long randomId, String message) {
        return EncryptedMessageHelper.createMessage(randomId, 1, new TextMessage(message, 0, null).toByteArray());
    }

    private static byte[] createMessage(long randomId, int type, byte[] message) {
        byte[] decryptedMessage = new PlainMessage(randomId, type, message).toByteArray();
        long crc32Val = 0L;
        try {
            CRC32 crc32 = new CRC32();
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            StreamingUtils.writeInt(1, stream);
            StreamingUtils.writeProtoBytes(message, stream);
            crc32.update(stream.toByteArray());
            crc32Val = crc32.getValue();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new PlainPackage(1, decryptedMessage, crc32Val).toByteArray();
    }
}

