/*
 * Decompiled with CFR 0.152.
 */
package im.actor.api.mtp._internal.entity;

import im.actor.api.mtp._internal.entity.ProtoObject;
import im.actor.api.util.StreamingUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ProtoMessage
extends ProtoObject {
    public long messageId;
    public byte[] payload;

    public ProtoMessage(long messageId, byte[] payload) {
        this.messageId = messageId;
        this.payload = payload;
    }

    public ProtoMessage(InputStream stream) throws IOException {
        super(stream);
    }

    @Override
    public void writeObject(OutputStream bs) throws IOException {
        StreamingUtils.writeLong(this.messageId, bs);
        StreamingUtils.writeProtoBytes(this.payload, bs);
    }

    @Override
    public ProtoObject readObject(InputStream bs) throws IOException {
        this.messageId = StreamingUtils.readLong(bs);
        this.payload = StreamingUtils.readProtoBytes(bs);
        return this;
    }

    @Override
    public int getLength() {
        return 8 + StreamingUtils.varintSize(this.payload.length) + this.payload.length;
    }

    public String toString() {
        return "ProtoMessage [#" + this.messageId + "]";
    }
}

