/*
 * Decompiled with CFR 0.152.
 */
package im.actor.api.mtp._internal.entity.message.rpc;

import im.actor.api.mtp._internal.entity.ProtoStruct;
import im.actor.api.util.StreamingUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class RpcError
extends ProtoStruct {
    public static final byte HEADER = 2;
    public int errorCode;
    public String errorTag;
    public String userMessage;
    public boolean canTryAgain;
    public byte[] relatedData;

    public RpcError(InputStream stream) throws IOException {
        super(stream);
    }

    public RpcError(int errorCode, String errorTag, String userMessage, boolean canTryAgain, byte[] relatedData) {
        this.errorCode = errorCode;
        this.errorTag = errorTag;
        this.userMessage = userMessage;
        this.canTryAgain = canTryAgain;
        this.relatedData = relatedData;
    }

    @Override
    public int getLength() {
        return 5 + StreamingUtils.stringSize(this.errorTag) + StreamingUtils.stringSize(this.userMessage) + 1;
    }

    @Override
    protected byte getHeader() {
        return 2;
    }

    @Override
    protected void writeBody(OutputStream bs) throws IOException {
        StreamingUtils.writeInt(this.errorCode, bs);
        StreamingUtils.writeProtoString(this.errorTag, bs);
        StreamingUtils.writeProtoString(this.userMessage, bs);
        StreamingUtils.writeProtoBool(this.canTryAgain, bs);
        StreamingUtils.writeProtoBytes(this.relatedData, bs);
    }

    @Override
    protected void readBody(InputStream bs) throws IOException {
        this.errorCode = StreamingUtils.readInt(bs);
        this.errorTag = StreamingUtils.readProtoString(bs);
        this.userMessage = StreamingUtils.readProtoString(bs);
        this.canTryAgain = StreamingUtils.readProtoBool(bs);
        this.relatedData = StreamingUtils.readProtoBytes(bs);
    }

    public String toString() {
        return "RpcError [#" + this.errorCode + " " + this.errorTag + "]";
    }
}

