/*
 * Decompiled with CFR 0.152.
 */
package im.actor.api.mtp._internal.tcp;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;

public class SocksProxy {
    private static final String IPADDRESS_PATTERN = "^([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])$";

    public static Socket createProxiedSocket(String proxyHost, int proxyPort, String destHost, int destPort) throws IOException {
        Socket socket = new Socket(proxyHost, proxyPort);
        OutputStream out = socket.getOutputStream();
        ByteArrayOutputStream request = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(request);
        dataOutputStream.writeByte(4);
        dataOutputStream.writeByte(1);
        dataOutputStream.writeByte((0xFF00 & destPort) >> 8);
        dataOutputStream.writeByte(0xFF & destPort);
        if (destHost.matches(IPADDRESS_PATTERN)) {
            String[] parts = destHost.split("\\.");
            dataOutputStream.writeByte(Integer.parseInt(parts[0]));
            dataOutputStream.writeByte(Integer.parseInt(parts[1]));
            dataOutputStream.writeByte(Integer.parseInt(parts[2]));
            dataOutputStream.writeByte(Integer.parseInt(parts[3]));
            dataOutputStream.writeByte(0);
        } else {
            dataOutputStream.writeByte(0);
            dataOutputStream.writeByte(0);
            dataOutputStream.writeByte(0);
            dataOutputStream.writeByte(1);
            dataOutputStream.writeByte(0);
            dataOutputStream.writeBytes(destHost);
            dataOutputStream.writeByte(0);
        }
        dataOutputStream.flush();
        out.write(request.toByteArray());
        DataInputStream inputStream = new DataInputStream(socket.getInputStream());
        if (inputStream.readByte() != 0) {
            throw new IOException();
        }
        byte resp = inputStream.readByte();
        if (resp != 90) {
            throw new IOException();
        }
        inputStream.readByte();
        inputStream.readByte();
        inputStream.readByte();
        inputStream.readByte();
        inputStream.readByte();
        inputStream.readByte();
        return socket;
    }
}

