/*
 * Decompiled with CFR 0.152.
 */
package im.actor.api.util;

import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;

public class ExponentialBackoff {
    private static final int MIN_DELAY = 100;
    private static final int MAX_DELAY = 15000;
    private static final int MAX_FAILURE_COUNT = 50;
    private final AtomicInteger currentFailureCount = new AtomicInteger();
    private final Random random = new Random();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long exponentialWait() {
        long maxDelay = 100 + 298 * this.currentFailureCount.get();
        Random random = this.random;
        synchronized (random) {
            return (long)(this.random.nextFloat() * (float)maxDelay);
        }
    }

    public void onFailure() {
        int val = this.currentFailureCount.incrementAndGet();
        if (val > 50) {
            this.currentFailureCount.compareAndSet(val, 50);
        }
    }

    public void onSuccess() {
        this.reset();
    }

    public void reset() {
        this.currentFailureCount.set(0);
    }
}

