/*
 * Decompiled with CFR 0.152.
 */
package net.rootdev.javardfa;

import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLOutputFactory;
import net.rootdev.javardfa.IRIResolver;
import net.rootdev.javardfa.Parser;
import net.rootdev.javardfa.Resolver;
import net.rootdev.javardfa.Setting;
import net.rootdev.javardfa.StatementSink;
import nu.validator.htmlparser.common.XmlViolationPolicy;
import nu.validator.htmlparser.sax.HtmlParser;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class ParserFactory {
    public static XMLReader createNonvalidatingReader() throws SAXException {
        XMLReader reader = XMLReaderFactory.createXMLReader();
        reader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        return reader;
    }

    public static XMLReader createHTML5Reader() {
        HtmlParser reader = new HtmlParser();
        reader.setXmlPolicy(XmlViolationPolicy.ALLOW);
        reader.setXmlnsPolicy(XmlViolationPolicy.ALLOW);
        reader.setMappingLangToXmlLang(false);
        reader.setStreamabilityViolationPolicy(XmlViolationPolicy.FATAL);
        return reader;
    }

    public static XMLReader createReaderForFormat(StatementSink sink, Format format) throws SAXException {
        return ParserFactory.createReaderForFormat(sink, format, new IRIResolver());
    }

    public static XMLReader createReaderForFormat(StatementSink sink, Format format, Resolver resolver) throws SAXException {
        XMLReader reader = ParserFactory.getReader(format);
        Parser parser = ParserFactory.getParser(format, sink, resolver);
        reader.setContentHandler(parser);
        return reader;
    }

    private static XMLReader getReader(Format format) throws SAXException {
        switch (format) {
            case XHTML: {
                return ParserFactory.createNonvalidatingReader();
            }
        }
        return ParserFactory.createHTML5Reader();
    }

    private static Parser getParser(Format format, StatementSink sink, Resolver resolver) {
        return ParserFactory.getParser(format, sink, XMLOutputFactory.newInstance(), XMLEventFactory.newInstance(), resolver);
    }

    private static Parser getParser(Format format, StatementSink sink, XMLOutputFactory outputFactory, XMLEventFactory eventFactory, Resolver resolver) {
        switch (format) {
            case XHTML: {
                return new Parser(sink, outputFactory, eventFactory, resolver);
            }
        }
        Parser p = new Parser(sink, outputFactory, eventFactory, resolver);
        p.enable(Setting.ManualNamespaces);
        return p;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Format {
        HTML,
        XHTML;


        public static Format lookup(String format) {
            if ("xhtml".equalsIgnoreCase(format)) {
                return XHTML;
            }
            if ("html".equalsIgnoreCase(format)) {
                return HTML;
            }
            return null;
        }
    }
}

