/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javaocr.filter;

import net.sourceforge.javaocr.Image;
import net.sourceforge.javaocr.ImageFilter;
import net.sourceforge.javaocr.ocr.PixelImage;

public abstract class AbstractIntegralImageFilter
implements ImageFilter {
    Image resultImage;
    Image empty;

    public AbstractIntegralImageFilter(Image resultImage) {
        this.resultImage = resultImage;
        this.empty = new PixelImage(resultImage.getWidth(), 1);
    }

    public void process(Image image) {
        int height = image.getHeight();
        int width = image.getWidth();
        for (int i = 0; i < height; ++i) {
            int cumulated = 0;
            Image sourceScan = image.row(i);
            Image destinationScan = this.resultImage.row(i);
            Image previous = i > 0 ? this.resultImage.row(i - 1) : this.empty;
            sourceScan.iterateH(0);
            destinationScan.iterateH(0);
            previous.iterateH(0);
            while (sourceScan.hasNext()) {
                destinationScan.next((cumulated += this.processPixel(sourceScan.next())) + previous.next());
            }
        }
    }

    protected abstract int processPixel(int var1);

    public int windowValue(int left, int top, int right, int bottom) {
        int ll = left - 1;
        int tt = top - 1;
        int sum = this.resultImage.get(right, bottom);
        if (ll >= 0) {
            sum -= this.resultImage.get(ll, bottom);
        }
        if (tt >= 0) {
            sum -= this.resultImage.get(right, tt);
        }
        if (tt >= 0 && ll >= 0) {
            sum += this.resultImage.get(ll, tt);
        }
        return sum;
    }
}

