/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javaocr.filter;

import net.sourceforge.javaocr.Image;
import net.sourceforge.javaocr.ImageFilter;
import net.sourceforge.javaocr.filter.IntegralImageFilter;
import net.sourceforge.javaocr.ocr.PixelImage;

public class MedianFilter
implements ImageFilter {
    protected final Image destination;
    protected final int halfWindow;
    protected final int squareWindow;
    private final PixelImage meanImage;
    protected final IntegralImageFilter integralImageFilter;

    public MedianFilter(Image destination, int window) {
        this.destination = destination;
        this.halfWindow = window / 2;
        this.squareWindow = (this.halfWindow * 2 + 1) * (this.halfWindow * 2 + 1);
        this.meanImage = new PixelImage(destination.getWidth(), destination.getHeight());
        this.integralImageFilter = new IntegralImageFilter(this.meanImage);
    }

    public void process(Image image) {
        this.integralImageFilter.process(image);
        int height = image.getHeight();
        int width = image.getWidth();
        int maxY = height - this.halfWindow;
        int maxX = width - this.halfWindow;
        for (int y = this.halfWindow; y < maxY; ++y) {
            for (int x = this.halfWindow; x < maxX; ++x) {
                this.destination.put(x, y, this.computePixel(image, y, x));
            }
        }
    }

    protected int computePixel(Image image, int y, int x) {
        int sum = this.integralImageFilter.windowValue(x - this.halfWindow, y - this.halfWindow, x + this.halfWindow, y + this.halfWindow);
        return sum / this.squareWindow;
    }

    public int getHalfWindow() {
        return this.halfWindow;
    }

    public int getSquareWindow() {
        return this.squareWindow;
    }

    public IntegralImageFilter getIntegralImageFilter() {
        return this.integralImageFilter;
    }
}

