/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javaocr.filter;

import net.sourceforge.javaocr.Image;
import net.sourceforge.javaocr.filter.AbstractSinglePixelFilter;

public class RGBAToGrayscale
extends AbstractSinglePixelFilter {
    final int cR;
    final int cG;
    final int cB;

    public RGBAToGrayscale() {
        this(306, 601, 117);
    }

    public RGBAToGrayscale(int cR, int cG, int cB) {
        this.cB = cB;
        this.cG = cG;
        this.cR = cR;
    }

    protected void processPixel(Image image) {
        int b;
        int g;
        int pixel = image.next();
        int r = pixel >> 16 & 0xFF;
        int Y = r * this.cR + (g = pixel >> 8 & 0xFF) * this.cG + (b = pixel & 0xFF) * this.cB >> 10;
        if (Y < 0) {
            Y = 0;
        } else if (Y > 255) {
            Y = 255;
        }
        image.put(Y);
    }
}

