/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javaocr.filter;

import net.sourceforge.javaocr.Image;
import net.sourceforge.javaocr.filter.MedianFilter;
import net.sourceforge.javaocr.filter.SquaredIntergalImageFilter;
import net.sourceforge.javaocr.ocr.PixelImage;

public class SauvolaBinarisationFilter
extends MedianFilter {
    protected final int above;
    protected final int below;
    protected final int range;
    protected final double weight;
    private SquaredIntergalImageFilter squaredIntergalImageFilter;
    private Image squaresImage;

    public SauvolaBinarisationFilter(int above, int below, Image destination, int maxValue, double weight, int window) {
        super(destination, window);
        this.above = above;
        this.below = below;
        this.range = maxValue / 2;
        this.weight = weight;
        this.squaresImage = new PixelImage(destination.getWidth(), destination.getHeight());
        this.squaredIntergalImageFilter = new SquaredIntergalImageFilter(this.squaresImage);
    }

    public void process(Image image) {
        this.squaredIntergalImageFilter.process(image);
        super.process(image);
    }

    protected int computePixel(Image image, int y, int x) {
        double mean = super.computePixel(image, y, x);
        double meanSquaresSum = this.squaredIntergalImageFilter.windowValue(x - this.getHalfWindow(), y - this.getHalfWindow(), x + this.getHalfWindow(), y + this.getHalfWindow()) / this.getSquareWindow();
        double variance = meanSquaresSum - mean * mean;
        double thr = mean * (1.0 + this.weight * (Math.sqrt(variance) / (double)this.range - 1.0));
        if ((double)image.get(x, y) > thr) {
            return this.above;
        }
        return this.below;
    }

    protected int retrievePixel(Image image, int y, int x) {
        return image.get(x, y);
    }

    public int getAbove() {
        return this.above;
    }

    public int getBelow() {
        return this.below;
    }

    public int getRange() {
        return this.range;
    }

    public double getWeight() {
        return this.weight;
    }

    public SquaredIntergalImageFilter getSquaredIntergalImageFilter() {
        return this.squaredIntergalImageFilter;
    }
}

