/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javaocr.matcher;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sourceforge.javaocr.matcher.FreeSpacesContainer;
import net.sourceforge.javaocr.matcher.Match;
import net.sourceforge.javaocr.matcher.Matcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FreeSpacesMatcher
implements Matcher {
    private Map<Integer, Set<Character>> counts = new HashMap<Integer, Set<Character>>();

    @Override
    public List<Match> classify(double[] features) {
        int key = (int)features[0];
        Set<Character> characterSet = this.counts.get(key);
        if (characterSet == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Match> matches = new ArrayList<Match>();
        for (Character c : characterSet) {
            Match match = new Match(c, 1.0, 0.0, 0.0);
            matches.add(match);
        }
        return matches;
    }

    public void train(char c, int i) {
        Set<Character> characters = this.counts.get(i);
        if (characters == null) {
            characters = new HashSet<Character>();
            this.counts.put(i, characters);
        }
        characters.add(Character.valueOf(c));
    }

    public Map<Integer, Set<Character>> getCounts() {
        return this.counts;
    }

    public List<FreeSpacesContainer> getContainers() {
        ArrayList<FreeSpacesContainer> freeSpaceContainers = new ArrayList<FreeSpacesContainer>();
        for (Integer count : this.getCounts().keySet()) {
            FreeSpacesContainer spacesContainer = new FreeSpacesContainer();
            spacesContainer.setCount(count);
            Set<Character> characters = this.getCounts().get(count);
            spacesContainer.setCharacters(characters.toArray(new Character[0]));
            freeSpaceContainers.add(spacesContainer);
        }
        return freeSpaceContainers;
    }

    public void setContainers(List<FreeSpacesContainer> containers) {
        for (FreeSpacesContainer container : containers) {
            for (Character chr : container.getCharacters()) {
                this.train(chr.charValue(), container.getCount());
            }
        }
    }
}

