/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javaocr.ocr;

import net.sourceforge.javaocr.Image;
import net.sourceforge.javaocr.ImageSlicer;

public abstract class AbstractBaseSlicer
implements ImageSlicer {
    Image image;
    int empty;
    protected int currentPosition;
    int tolerance;
    protected int border;

    public AbstractBaseSlicer(int empty, Image image, int border) {
        this.empty = empty;
        this.image = image;
        this.border = border;
    }

    public ImageSlicer slice(int fromY) {
        return this.slice(fromY, 0);
    }

    public boolean hasNext() {
        return this.currentPosition < this.border;
    }

    public ImageSlicer slice(int from, int tolerance) {
        boolean rowEmpty;
        this.tolerance = tolerance;
        this.currentPosition = from;
        while (this.currentPosition < this.border && (rowEmpty = this.spanEmpty())) {
            ++this.currentPosition;
        }
        return this;
    }

    protected boolean spanEmpty() {
        boolean spanEmpty = true;
        this.iterateSpan();
        while (this.image.hasNext()) {
            if (this.image.next() == this.empty) continue;
            spanEmpty = false;
            break;
        }
        return spanEmpty;
    }

    public Image next() {
        int toleranceReserve = this.tolerance + 1;
        int imageStart = this.currentPosition;
        while (this.currentPosition < this.border && toleranceReserve > 0) {
            toleranceReserve = this.spanEmpty() ? --toleranceReserve : this.tolerance + 1;
            ++this.currentPosition;
        }
        this.currentPosition -= this.tolerance - toleranceReserve + 1;
        if (imageStart < this.currentPosition) {
            Image returnImage = this.chisel(imageStart);
            this.slice(this.currentPosition, this.tolerance);
            return returnImage;
        }
        return null;
    }

    protected abstract Image chisel(int var1);

    protected abstract void iterateSpan();
}

