/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javaocr.ocr;

import java.util.ArrayList;
import net.sourceforge.javaocr.DocumentScannerListener;
import net.sourceforge.javaocr.Image;
import net.sourceforge.javaocr.ImageScanner;

public class DocumentScanner
implements ImageScanner {
    protected float shortRowFraction = 0.125f;
    protected float liberalPolicyAreaWhitespaceFraction = 0.95f;
    protected float minSpaceWidthAsFractionOfRowHeight = 0.6f;
    protected float minCharWidthAsFractionOfRowHeight = 0.35f;
    protected float minCharBreakWidthAsFractionOfRowHeight = 0.05f;
    protected int whiteThreshold = 128;

    public float getShortRowFraction() {
        return this.shortRowFraction;
    }

    public void setShortRowFraction(float shortRowFraction) {
        this.shortRowFraction = shortRowFraction;
    }

    public float getLiberalPolicyAreaWhitespaceFraction() {
        return this.liberalPolicyAreaWhitespaceFraction;
    }

    public void setLiberalPolicyAreaWhitespaceFraction(float liberalPolicyAreaWhitespaceFraction) {
        this.liberalPolicyAreaWhitespaceFraction = liberalPolicyAreaWhitespaceFraction;
    }

    public float getMinSpaceWidthAsFractionOfRowHeight() {
        return this.minSpaceWidthAsFractionOfRowHeight;
    }

    public void setMinSpaceWidthAsFractionOfRowHeight(float minSpaceWidthAsFractionOfRowHeight) {
        this.minSpaceWidthAsFractionOfRowHeight = minSpaceWidthAsFractionOfRowHeight;
    }

    public float getMinCharWidthAsFractionOfRowHeight() {
        return this.minCharWidthAsFractionOfRowHeight;
    }

    public void setMinCharWidthAsFractionOfRowHeight(float minCharWidthAsFractionOfRowHeight) {
        this.minCharWidthAsFractionOfRowHeight = minCharWidthAsFractionOfRowHeight;
    }

    public float getMinCharBreakWidthAsFractionOfRowHeight() {
        return this.minCharBreakWidthAsFractionOfRowHeight;
    }

    public void setMinCharBreakWidthAsFractionOfRowHeight(float minCharBreakWidthAsFractionOfRowHeight) {
        this.minCharBreakWidthAsFractionOfRowHeight = minCharBreakWidthAsFractionOfRowHeight;
    }

    public int getWhiteThreshold() {
        return this.whiteThreshold;
    }

    public void setWhiteThreshold(int whiteThreshold) {
        this.whiteThreshold = whiteThreshold;
    }

    public final void scan(Image pixelImage, DocumentScannerListener listener, int blockX1, int blockY1, int blockX2, int blockY2) {
        int w = pixelImage.getWidth();
        int h = pixelImage.getHeight();
        if (blockX1 < 0) {
            blockX1 = 0;
        } else if (blockX1 >= w) {
            blockX1 = w - 1;
        }
        if (blockY1 < 0) {
            blockY1 = 0;
        } else if (blockY1 >= h) {
            blockY1 = h - 1;
        }
        if (blockX2 <= 0 || blockX2 >= w) {
            blockX2 = w - 1;
        }
        if (blockY2 <= 0 || blockY2 >= h) {
            blockY2 = h - 1;
        }
        ++blockX2;
        ++blockY2;
        boolean whiteLine = true;
        listener.beginDocument(pixelImage);
        ArrayList<Integer> al = new ArrayList<Integer>();
        int y1 = 0;
        for (int y = blockY1; y < blockY2; ++y) {
            boolean isWhiteSpace = pixelImage.horizontalSpanEquals(y, blockX1, blockX2, 0);
            if (isWhiteSpace) {
                if (whiteLine) continue;
                whiteLine = true;
                al.add(new Integer(y1));
                al.add(new Integer(y));
                continue;
            }
            if (!whiteLine) continue;
            whiteLine = false;
            y1 = y;
        }
        if (!whiteLine) {
            al.add(new Integer(y1));
            al.add(new Integer(blockY2));
        }
        int i = 0;
        while (i + 4 <= al.size()) {
            int bY0 = (Integer)al.get(i);
            int bY1 = (Integer)al.get(i + 1);
            int bY2 = (Integer)al.get(i + 2);
            int bY3 = (Integer)al.get(i + 3);
            int row0H = bY1 - bY0;
            int whiteH = bY2 - bY1;
            int row1H = bY3 - bY2;
            if (!(row1H > (int)((float)row0H * this.shortRowFraction) && row1H >= 6 || whiteH > (int)((float)row0H * this.shortRowFraction) && whiteH >= 6)) {
                al.remove(i + 2);
                al.remove(i + 1);
                i -= 2;
            }
            i += 2;
        }
        if (al.size() == 0) {
            al.add(new Integer(blockY1));
            al.add(new Integer(blockY2));
        }
        i = 0;
        while (i + 1 < al.size()) {
            int bY1 = (Integer)al.get(i);
            int bY2 = (Integer)al.get(i + 1);
            this.processRow(pixelImage, listener, w, h, blockX1, bY1, blockX2, bY2);
            i += 2;
        }
    }

    private final void processRow(Image pixelImage, DocumentScannerListener listener, int w, int h, int x1, int y1, int x2, int y2) {
        listener.beginRow(pixelImage, y1, y2);
        int rowHeight = y2 - y1;
        int minCharBreakWidth = Math.max(1, (int)((float)rowHeight * this.minCharBreakWidthAsFractionOfRowHeight));
        int liberalWhitspaceMinWhitePixelsPerColumn = (int)((float)rowHeight * this.liberalPolicyAreaWhitespaceFraction);
        ArrayList<Integer> al = new ArrayList<Integer>();
        boolean inCharSeparator = true;
        int charX1 = 0;
        int prevCharX1 = -1;
        boolean liberalWhitespacePolicy = false;
        int numConsecutiveWhite = 0;
        for (int x = x1 + 1; x < x2 - 1; ++x) {
            if (!liberalWhitespacePolicy && numConsecutiveWhite == 0 && x - charX1 >= rowHeight) {
                x = charX1;
                liberalWhitespacePolicy = true;
            }
            int numWhitePixelsThisColumn = 0;
            boolean isWhiteSpace = pixelImage.verticalSpanEquals(x, y1, y2 - 1, 0);
            if (liberalWhitespacePolicy && numWhitePixelsThisColumn < liberalWhitspaceMinWhitePixelsPerColumn) {
                isWhiteSpace = false;
            }
            if (isWhiteSpace) {
                if (++numConsecutiveWhite < minCharBreakWidth || inCharSeparator) continue;
                inCharSeparator = true;
                al.add(new Integer(charX1));
                al.add(new Integer(x - (numConsecutiveWhite - 1)));
                continue;
            }
            numConsecutiveWhite = 0;
            if (!inCharSeparator) continue;
            inCharSeparator = false;
            prevCharX1 = charX1;
            charX1 = x;
            liberalWhitespacePolicy = false;
        }
        if (numConsecutiveWhite == 0) {
            al.add(new Integer(charX1));
            al.add(new Integer(x2));
        }
        int minSpaceWidth = (int)((float)rowHeight * this.minSpaceWidthAsFractionOfRowHeight);
        int minCharWidth = (int)((float)rowHeight * this.minCharWidthAsFractionOfRowHeight);
        if (minCharWidth < 1) {
            minCharWidth = 1;
        }
        int i = 0;
        while (i + 4 < al.size()) {
            int thisCharWidth = (Integer)al.get(i + 2) - (Integer)al.get(i);
            if (thisCharWidth < minCharWidth || thisCharWidth < 6) {
                al.remove(i + 2);
                al.remove(i + 1);
                i -= 2;
            }
            i += 2;
        }
        i = 0;
        while (i + 1 < al.size()) {
            boolean isWhiteSpace;
            int cy2;
            boolean isWhiteSpace2;
            int cy1;
            int cx2;
            int cx1;
            if (i >= 2) {
                cx1 = (Integer)al.get(i - 1);
                cx2 = (Integer)al.get(i);
                while (cx2 - cx1 >= minSpaceWidth) {
                    int sx2 = Math.min(cx1 + minSpaceWidth, cx2);
                    listener.processSpace(pixelImage, cx1, y1, sx2, y2);
                    cx1 += minSpaceWidth;
                }
            }
            cx1 = (Integer)al.get(i);
            cx2 = (Integer)al.get(i + 1);
            for (cy1 = y1; cy1 < y2 && (isWhiteSpace2 = pixelImage.horizontalSpanEquals(cy1, cx1, cx2 - 1, 0)); ++cy1) {
            }
            for (cy2 = y2; cy2 > cy1 && (isWhiteSpace = pixelImage.horizontalSpanEquals(cy2 - 1, cx1, cx2 - 1, 0)); --cy2) {
            }
            if (cy1 >= cy2) {
                listener.processSpace(pixelImage, cx1, y1, cx2, y2);
            } else {
                listener.processChar(pixelImage, cx1, cy1, cx2, cy2, y1, y2);
            }
            i += 2;
        }
        listener.endRow(pixelImage, y1, y2);
    }
}

