/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javaocr.plugin.moment;

import net.sourceforge.javaocr.Image;
import net.sourceforge.javaocr.cluster.FeatureExtractor;
import net.sourceforge.javaocr.plugin.moment.CentralMomentFilter;
import net.sourceforge.javaocr.plugin.moment.RawMomentFilter;

public class HuMoments
implements FeatureExtractor {
    public double[] extract(Image image) {
        RawMomentFilter M00 = new RawMomentFilter(0, 0);
        M00.process(image);
        double m00 = M00.getMoment();
        RawMomentFilter M10 = new RawMomentFilter(1, 0);
        M10.process(image);
        double m10 = M10.getMoment();
        RawMomentFilter M01 = new RawMomentFilter(0, 1);
        M01.process(image);
        double m01 = M01.getMoment();
        double xMean = m10 / m00;
        double yMean = m01 / m00;
        CentralMomentFilter N20 = new CentralMomentFilter(2, 0, xMean, yMean);
        CentralMomentFilter N02 = new CentralMomentFilter(0, 2, xMean, yMean);
        N20.process(image);
        double n20 = N20.normalise(m00);
        N02.process(image);
        double n02 = N02.normalise(m00);
        double[] moments = new double[8];
        moments[0] = n20 + n02;
        CentralMomentFilter N11 = new CentralMomentFilter(1, 1, xMean, yMean);
        N11.process(image);
        double n11 = N11.normalise(m00);
        moments[1] = Math.pow(n20 - n02, 2.0) + 4.0 * Math.pow(n11, 2.0);
        CentralMomentFilter N30 = new CentralMomentFilter(3, 0, xMean, yMean);
        N30.process(image);
        double n30 = N30.normalise(m00);
        CentralMomentFilter N03 = new CentralMomentFilter(0, 3, xMean, yMean);
        N03.process(image);
        double n03 = N03.normalise(m00);
        CentralMomentFilter N21 = new CentralMomentFilter(2, 1, xMean, yMean);
        N21.process(image);
        double n21 = N21.normalise(m00);
        CentralMomentFilter N12 = new CentralMomentFilter(1, 2, xMean, yMean);
        N12.process(image);
        double n12 = N12.normalise(m00);
        moments[2] = Math.pow(n30 - 3.0 * n12, 2.0) + Math.pow(n03 - 3.0 * n21, 2.0);
        moments[3] = Math.pow(n30 + n12, 2.0) + Math.pow(n03 + n21, 2.0);
        moments[4] = (n30 - 3.0 * n12) * (n30 + n12) * (Math.pow(n30 + n12, 2.0) - 3.0 * Math.pow(n21 + n03, 2.0)) + (n03 - 3.0 * n21) * (n03 + n21) * (Math.pow(n03 + n21, 2.0) - 3.0 * Math.pow(n30 + n12, 2.0));
        moments[5] = (n20 - n02) * (Math.pow(n30 + n12, 2.0) - Math.pow(n21 + n03, 2.0)) + 4.0 * n11 * (n30 + n12) * (n03 + n21);
        moments[6] = (3.0 * n21 - n03) * (n30 + n12) * (Math.pow(n30 + n12, 2.0) - 3.0 * Math.pow(n21 + n03, 2.0)) + (n30 - 3.0 * n12) * (n21 + n03) * (Math.pow(n03 + n21, 2.0) - 3.0 * Math.pow(n30 + n12, 2.0));
        moments[7] = n11 * (Math.pow(n30 + n12, 2.0) - Math.pow(n03 + n21, 2.0)) - (n20 - n02) * (n30 + n12) * (n03 + n21);
        return moments;
    }

    public int getSize() {
        return 8;
    }
}

