/*
 * Decompiled with CFR 0.152.
 */
package net.sqlind;

import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import net.sqlind.SQLind;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLQueryMapper {
    private int LRU_CACHE_SIZE = 50;
    protected static Log log = LogFactory.getLog(SQLQueryMapper.class);
    private static SQLQueryMapper instance;
    protected static HashMap<String, SQLQueryMapper> instances;
    private static String ID;
    private static String PARAMS;
    private static String POLICY;
    private static String INJECT_JOKER;
    private static Pattern INJECT_JOKER_PATTERN;
    private static Pattern SQL_FROM_PATTERN;
    private static Pattern SQL_JOIN_PATTERN;
    private static Pattern SQL_SELECT_PATTERN;
    private static Pattern SQL_COLUMN_PATTERN;
    private static final long serialVersionUID = 1L;
    private String file;
    private HashMap<String, SQLQueryTemplate> queryMap = new HashMap();
    private List<String> lru = new ArrayList<String>();
    private static ThreadLocal<Context> context;

    public void setCacheSize(int numberOfQuery) {
        this.LRU_CACHE_SIZE = numberOfQuery;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache() {
        HashMap<String, SQLQueryTemplate> hashMap = this.queryMap;
        synchronized (hashMap) {
            for (String key : this.lru) {
                this.queryMap.remove(key);
            }
            this.lru.clear();
        }
    }

    public static SQLQueryMapper getInstance() {
        if (instance == null) {
            instance = new SQLQueryMapper();
            log.info((Object)"SQLind Initialized");
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SQLQueryHandler getSQLQuery(String file, String schema, String id, String ... params) throws SQLMapperException {
        if (!instances.containsKey(file)) {
            HashMap<String, SQLQueryMapper> hashMap = instances;
            synchronized (hashMap) {
                if (!instances.containsKey(file)) {
                    instances.put(file, new SQLQueryMapper(file));
                }
            }
        }
        return new SQLQueryHandler(instances.get(file).getQuery(schema, id, params));
    }

    protected SQLQueryMapper(String file) throws SQLMapperException {
        try {
            SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            URL url = this.getClass().getClassLoader().getResource("net/sqlind/sqlind.xsd");
            InputStream fileIS = this.getClass().getClassLoader().getResourceAsStream(file);
            Schema schema = factory.newSchema(url);
            Validator validator = schema.newValidator();
            StreamSource source = new StreamSource(fileIS);
            validator.validate(source);
        }
        catch (Exception e) {
            log.warn((Object)("failed to validate query file " + file), (Throwable)e);
        }
        this.file = file;
    }

    protected SQLQueryMapper() {
    }

    protected static Context getContext() {
        return context.get();
    }

    protected static String shrinkSQL(String queryStr, List<InjectPoint> ips) {
        StringBuilder sb = new StringBuilder(queryStr);
        int c = 0;
        for (InjectPoint ip : ips) {
            sb.insert(ip.idx + c++ * INJECT_JOKER.length(), INJECT_JOKER);
        }
        SQLQueryMapper.trimQuery(sb);
        Matcher m = INJECT_JOKER_PATTERN.matcher(sb.toString());
        for (InjectPoint ip : ips) {
            m.find();
            ip.idx = m.start();
        }
        sb = new StringBuilder(sb.toString().replaceAll(INJECT_JOKER, ""));
        return sb.toString();
    }

    private static void trimQuery(StringBuilder sb) {
        StringTokenizer st = new StringTokenizer(sb.toString(), "\n");
        sb.delete(0, sb.length());
        while (st.hasMoreElements()) {
            sb.append(((String)st.nextElement()).trim()).append(" ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SQLQueryTemplate getQuery(String schema, String id, String ... params) throws SQLMapperException {
        Context ctx = SQLQueryMapper.getContext();
        ctx.queryKey.delete(0, ctx.queryKey.length());
        ctx.queryKey.append(schema).append(".").append(id);
        for (String str : params) {
            ctx.queryKey.append(".").append(str);
        }
        String key = ctx.queryKey.toString();
        SQLQueryTemplate qt = this.queryMap.get(key);
        if (qt == null) {
            SQLQuery q = new SQLQuery(this.file, schema, id, params);
            switch (q.getWiringPolicy()) {
                case fast: {
                    HashMap<String, SQLQueryTemplate> hashMap = this.queryMap;
                    synchronized (hashMap) {
                        if (!this.queryMap.containsKey(key)) {
                            this.queryMap.put(key, q);
                        }
                        break;
                    }
                }
                case lru: {
                    HashMap<String, SQLQueryTemplate> hashMap = this.queryMap;
                    synchronized (hashMap) {
                        if (!this.queryMap.containsKey(key)) {
                            if (this.lru.size() > this.LRU_CACHE_SIZE) {
                                this.queryMap.remove(this.lru.get(0));
                                this.lru.remove(0);
                            }
                            this.lru.add(key);
                            this.queryMap.put(key, q);
                        }
                        break;
                    }
                }
            }
            return q;
        }
        return this.queryMap.get(key);
    }

    static {
        instances = new HashMap();
        ID = "id";
        PARAMS = "params";
        POLICY = "policy";
        INJECT_JOKER = "<SQLind-InjectPoint/>";
        INJECT_JOKER_PATTERN = Pattern.compile(INJECT_JOKER);
        SQL_FROM_PATTERN = Pattern.compile("from\\s((?!where|union|left|right|full|outer|join|inner).)+(where|union|left|right|full|outer|join|inner)", 34);
        SQL_JOIN_PATTERN = Pattern.compile("join\\s((?!on|where|union|left|right|full|outer|join|inner).)+(on|where|union|left|right|full|outer|join|inner)", 34);
        SQL_SELECT_PATTERN = Pattern.compile("select\\s*(distinct){0,1}\\s*(((?!from).)+)from.*", 2);
        SQL_COLUMN_PATTERN = Pattern.compile("([^\\s,]+\\.)*([^,\\.\\s]+)", 2);
        context = new ThreadLocal<Context>(){

            @Override
            protected synchronized Context initialValue() {
                return SQLQueryMapper.getInstance().new Context();
            }
        };
    }

    private abstract class ParserBehaviour {
        private ParserBehaviour() {
        }

        void parseTag(String name, boolean found, int ignore) throws SAXException {
            Tags tag = null;
            if (name != null) {
                try {
                    tag = Tags.valueOf(name.toLowerCase());
                    if (tag == Tags.queries) {
                        this.doQueries();
                        return;
                    }
                }
                catch (Exception e) {
                    throw new SAXException("Unknown tag '" + name + "'");
                }
                if (tag != Tags.query && !found) {
                    return;
                }
                if (tag != Tags.section && ignore > 0) {
                    return;
                }
                switch (tag) {
                    case query: {
                        this.doQuery();
                        break;
                    }
                    case var: {
                        this.doVar();
                        break;
                    }
                    case section: {
                        this.doSection();
                        break;
                    }
                    case include: {
                        this.doInclude();
                        break;
                    }
                    case inject: {
                        this.doInject();
                        break;
                    }
                    default: {
                        this.doOther();
                    }
                }
            }
        }

        abstract void doQuery() throws SAXException;

        void doSection() throws SAXException {
        }

        void doVar() throws SAXException {
        }

        void doInclude() throws SAXException {
        }

        void doInject() throws SAXException {
        }

        void doOther() throws SAXException {
        }

        void doQueries() throws SAXException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SQLQuery
    extends DefaultHandler
    implements SQLQueryTemplate {
        private ParserBehaviour startTargParser;
        private ParserBehaviour endTagParser;
        String schema = null;
        WiringPolicies wiring = null;
        private List<InjectPoint> injectPoints = new ArrayList<InjectPoint>(0);
        private StringBuilder template = null;
        private String id;
        private String libId;
        private boolean found = false;
        private int ignore = 0;
        private String sql;
        private List<String> options = null;
        private List<String> parameters = new ArrayList<String>(0);
        private List<String> columnNames = new ArrayList<String>(5);
        HashMap<String, WiringPolicy> wiringCache = null;
        private final Class[] NOARGType = new Class[0];
        private final Object[] NOARG = new Object[0];

        @Override
        public SQLMapperException getException(Errors type, Throwable e, String ... infos) {
            Info info = new Info(infos);
            e.printStackTrace();
            switch (type) {
                case ERROR_INIT_WIRING: {
                    return new SQLMapperException(info.ctx + "\nUnable to init wiring policy for bean " + info.get(0), e);
                }
                case ERROR_DO_WIRING: {
                    return new SQLMapperException(info.ctx + "\nUnable to wire bean " + info.get(0), e);
                }
                case ERROR_SET_WIRING: {
                    return new SQLMapperException(info.ctx + "\nWiring is not activated on this query, please add a wiring policy to xml", e);
                }
                case ERROR_SQL: {
                    return new SQLMapperException("\nUnable to perform query :\n " + info.get(0), e);
                }
                case ERROR_INIT_QUERY: {
                    return new SQLMapperException(info.ctx + "Unable to create query object from xml definition (check SQL syntax)", e);
                }
                case ERROR_INIT_QUERIES: {
                    return new SQLMapperException(info.ctx + "Unable to parse queries xml definition", e);
                }
            }
            return new SQLMapperException(info.ctx + "Unexpected error : " + info.get(0), e);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <Z> WiringPolicy<Z> getWiringPolicyClass(Class<Z> clazz) throws SQLMapperException {
            try {
                SQLQueryMapper.getContext().clearStrBuilder();
                StringBuilder sb = SQLQueryMapper.getContext().strBuilder;
                sb.append(clazz.getName()).append(".").append(this.libId).append(".").append(this.id).append(String.valueOf(this.options));
                String key = sb.toString();
                if (!this.wiringCache.containsKey(key)) {
                    SQLQueryMapper sQLQueryMapper = instance;
                    synchronized (sQLQueryMapper) {
                        if (!this.wiringCache.containsKey(key)) {
                            switch (this.wiring) {
                                case fast: {
                                    this.wiringCache.put(key, new TransformationWiring<Z>(clazz));
                                    break;
                                }
                                default: {
                                    this.wiringCache.put(key, new ReflectionWiring(clazz));
                                }
                            }
                        }
                    }
                }
                return this.wiringCache.get(key);
            }
            catch (Exception e) {
                if (this.wiring == null) {
                    throw this.getException(Errors.ERROR_SET_WIRING, e, new String[0]);
                }
                throw this.getException(Errors.ERROR_INIT_WIRING, e, clazz.getName());
            }
        }

        private Method transformSetter2Getter(Method setter) throws NoSuchMethodException {
            String getterName = "get" + setter.getName().substring(3, setter.getName().length());
            return setter.getDeclaringClass().getMethod(getterName, this.NOARGType);
        }

        public SQLQuery() {
        }

        private SQLQuery(String file, String schema, String id, String ... params) throws SQLMapperException {
            try {
                this.createTemplate(file, schema, id, params);
                if (this.sql != null) {
                    Matcher m = SQL_SELECT_PATTERN.matcher(this.sql);
                    String str = null;
                    if (m.find()) {
                        str = m.group(2);
                    }
                    if (str != null) {
                        m = SQL_COLUMN_PATTERN.matcher(str);
                        while (m.find()) {
                            this.columnNames.add(m.group(2).toLowerCase());
                        }
                    }
                }
                this.template = null;
                schema = null;
                id = null;
                this.startTargParser = null;
                this.endTagParser = null;
            }
            catch (Exception e) {
                throw this.getException(Errors.ERROR_INIT_QUERY, e, new String[0]);
            }
        }

        protected void createTemplate(String file, String schema, String id, String ... params) throws SQLMapperException {
            this.id = id;
            this.options = new ArrayList<String>(1);
            this.schema = schema;
            this.template = new StringBuilder();
            for (String option : params) {
                this.options.add(option);
            }
            SAXParserFactory spf = SAXParserFactory.newInstance();
            try {
                SAXParser sp = spf.newSAXParser();
                sp.parse(this.getClass().getClassLoader().getResourceAsStream(file), (DefaultHandler)this);
            }
            catch (StopEvent se) {
            }
            catch (Exception e) {
                throw this.getException(Errors.ERROR_INIT_QUERIES, e, new String[0]);
            }
            if (schema != null) {
                this.buildSQLWithSchema(this.template.toString(), SQL_FROM_PATTERN, "from ");
                this.buildSQLWithSchema(this.sql, SQL_JOIN_PATTERN, "join ");
            } else {
                this.sql = this.template.toString();
            }
            this.shrink();
        }

        public void shrink() {
            if (this.wiring != WiringPolicies.reload) {
                this.sql = SQLQueryMapper.shrinkSQL(this.sql, this.injectPoints);
            }
        }

        private void buildSQLWithSchema(String template, Pattern pattern, String keyWord) {
            Matcher matcher = pattern.matcher(template);
            StringBuilder query = new StringBuilder();
            int idx = 0;
            while (matcher.find()) {
                String from = matcher.group(0).substring(keyWord.length(), matcher.group(0).length());
                query.append(template.substring(idx, matcher.start())).append(keyWord);
                String[] tables = from.split(",");
                int last = query.length();
                for (int j = 0; j < tables.length; ++j) {
                    query.append(this.schema).append(".").append(tables[j].trim());
                    if (j < tables.length - 1) {
                        query.append(",");
                    }
                    this.updateInjectPoints(last, query.length() - last - tables[j].length());
                    last = query.length();
                }
                idx = matcher.end();
            }
            query.append(template.substring(idx, template.length()));
            this.sql = query.toString();
        }

        private void updateInjectPoints(int idx, int offset) {
            InjectPoint ip;
            for (int j = this.injectPoints.size() - 1; j >= 0 && (ip = this.injectPoints.get(j)).idx > idx; --j) {
                ip.idx = ip.idx + offset;
            }
        }

        @Override
        public String getSQL() {
            return this.sql;
        }

        @Override
        public List<String> getParameters() {
            return this.parameters;
        }

        @Override
        public List<InjectPoint> getInjectPoints() {
            return this.injectPoints;
        }

        @Override
        public String getID() {
            return this.id;
        }

        @Override
        public WiringPolicies getWiringPolicy() {
            return this.wiring;
        }

        @Override
        public List<String> getColumns() {
            return this.columnNames;
        }

        @Override
        public void setSQL(String queryString) {
            this.sql = queryString;
        }

        @Override
        public void startElement(String uri, String localName, String qName, final Attributes attributes) throws SAXException {
            if (this.startTargParser == null) {
                this.startTargParser = new ParserBehaviour(){

                    void doQuery() {
                        String currentId = attributes.getValue(ID);
                        if (SQLQuery.this.id.equalsIgnoreCase(currentId)) {
                            SQLQuery.this.found = true;
                            String wiringpolicy = attributes.getValue(POLICY);
                            SQLQuery.this.wiringCache = new HashMap(1);
                            SQLQuery.this.wiring = WiringPolicies.valueOf(wiringpolicy);
                        }
                    }

                    void doVar() {
                        SQLQuery.this.parameters.add(attributes.getValue(ID));
                        SQLQuery.this.template.append("?");
                    }

                    void doSection() {
                        String id = attributes.getValue(ID);
                        if (!SQLQuery.this.options.contains(id) || SQLQuery.this.ignore > 0) {
                            SQLQuery.this.ignore++;
                        }
                    }

                    void doInclude() throws SAXException {
                        String currentId = attributes.getValue(ID);
                        String param = attributes.getValue(PARAMS);
                        String[] params = new String[]{};
                        ArrayList<String> allOptions = new ArrayList<String>(SQLQuery.this.options);
                        if (param != null) {
                            for (String xmlparam : params = param.split(",")) {
                                allOptions.add(xmlparam);
                            }
                        }
                        try {
                            params = allOptions.toArray(params);
                            SQLIncludedQuery q = new SQLIncludedQuery(SQLQueryMapper.this.file, SQLQuery.this.schema, currentId, params);
                            SQLQuery.this.parameters.addAll(((SQLQuery)q).parameters);
                            for (InjectPoint ip : q.getInjectPoints()) {
                                ip.idx = ip.idx + SQLQuery.this.template.length();
                                SQLQuery.this.injectPoints.add(ip);
                            }
                            SQLQuery.this.template.append((CharSequence)((SQLQuery)q).template);
                        }
                        catch (SQLMapperException e) {
                            throw new SAXException("Unable to include query " + currentId + " in query " + SQLQuery.this.id, e);
                        }
                    }

                    void doInject() throws SAXException {
                        String currentId = attributes.getValue(ID);
                        SQLQuery.this.injectPoints.add(new InjectPoint(currentId, SQLQuery.this.template.length()));
                    }

                    void doQueries() throws SAXException {
                        SQLQuery.this.libId = attributes.getValue(ID);
                    }
                };
            }
            this.startTargParser.parseTag(qName, this.found, this.ignore);
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.found && this.ignore == 0) {
                this.template.append(new String(ch, start, length));
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (this.endTagParser == null) {
                this.endTagParser = new ParserBehaviour(){

                    void doQuery() throws SAXException {
                        if (SQLQuery.this.found) {
                            throw new StopEvent();
                        }
                    }

                    void doSection() {
                        if (SQLQuery.this.ignore > 0) {
                            SQLQuery.this.ignore--;
                        }
                    }
                };
            }
            this.endTagParser.parseTag(qName, this.found, this.ignore);
        }

        private class StopEvent
        extends SAXException {
            private static final long serialVersionUID = 1L;

            private StopEvent() {
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class TransformationWiring<Z>
        extends WiringPolicy {
            HashMap<String, List<Integer>> beanIdsmap;
            HashMap<Integer, Class> colType;
            SQLBeanAccess transfo;
            List<String> beanId;
            StringBuilder mainSB;
            StringBuilder secondarySB;
            StringBuilder tmpSB;

            protected String getAccessorString(Class type) {
                String str = type.getSimpleName();
                if (str.equals("Integer")) {
                    return "Int";
                }
                return str.substring(0, 1).toUpperCase() + str.substring(1, str.length());
            }

            protected String getPrimitive(Class type) {
                String str = type.getSimpleName();
                if (str.equals("Integer")) {
                    return "int";
                }
                return str.substring(0, 1).toLowerCase() + str.substring(1, str.length());
            }

            protected String getGetterForBean() {
                int i;
                StringBuilder sb = new StringBuilder();
                for (i = 0; i < this.beanId.size() - 1; ++i) {
                    sb.append(this.beanId.get(i));
                }
                return sb.append(".get").append(this.beanId.get(i).substring(3, 4).toUpperCase()).append(this.beanId.get(i).substring(4, this.beanId.get(i).length())).toString();
            }

            protected String createNewBeanList(List<String> id) {
                int i;
                StringBuilder sb = new StringBuilder();
                for (i = 0; i < id.size() - 1; ++i) {
                    sb.append(id.get(i));
                }
                return sb.append(".set").append(id.get(i).substring(3, 4).toUpperCase()).append(id.get(i).substring(4, id.get(i).length())).append("(new java.util.ArrayList());\n").toString();
            }

            protected String getBeanId() {
                if (this.beanId.size() == 1) {
                    return "bean";
                }
                StringBuilder sb = new StringBuilder();
                for (String bid : this.beanId) {
                    sb.append(bid).append("_");
                }
                return sb.toString();
            }

            private void registerCol(int id, Class classType) {
                String beanId = this.getBeanId();
                if (!this.beanIdsmap.containsKey(beanId)) {
                    this.beanIdsmap.put(beanId, new ArrayList());
                }
                this.beanIdsmap.get(beanId).add(id);
                this.colType.put(id + 1, classType);
            }

            protected TransformationWiring(Class<Z> clazz) throws Exception {
                super(clazz);
                this.init();
            }

            public Object wire(GenericQueryHandler.BeanWiringBehavior behavior, ResultSet rs, Object ... values) throws SQLMapperException {
                try {
                    Object bean = this.transfo.buildFromResultSet(behavior, rs, behavior.objBean, SQLQueryMapper.getContext().lastValues);
                    return bean;
                }
                catch (Exception e) {
                    throw SQLQuery.this.getException(Errors.ERROR_DO_WIRING, e, this.clazz.getName());
                }
            }

            @Override
            protected void before() throws Exception {
                this.colType = new HashMap();
                this.beanIdsmap = new HashMap();
                if (this.beanId == null) {
                    this.beanId = new ArrayList<String>();
                    this.beanId.add("bean");
                }
                this.secondarySB = new StringBuilder();
                this.tmpSB = new StringBuilder();
                this.mainSB = new StringBuilder();
                this.mainSB.append(this.clazz.getName()).append(" ").append(this.getBeanId()).append(";\n");
            }

            @Override
            protected void after() throws Exception {
                ClassPool pool = ClassPool.getDefault();
                CtClass transfoClazz = pool.makeClass(this.clazz.getName() + "RSWirererOn_" + SQLQuery.this.libId + "_" + SQLQuery.this.id + "_" + String.valueOf(SQLQuery.this.options));
                transfoClazz.addInterface(pool.get(SQLBeanAccess.class.getName()));
                CtMethod meth = new CtMethod(pool.get(Object.class.getName()), "buildFromResultSet", new CtClass[]{pool.get(GenericQueryHandler.BeanWiringBehavior.class.getName()), pool.get(ResultSet.class.getName()), pool.get(Object.class.getName()), pool.get(String[].class.getName())}, transfoClazz);
                meth.setExceptionTypes(new CtClass[]{pool.get(Exception.class.getName())});
                StringBuilder methodBody = new StringBuilder("{\n");
                this.fillInInitVariablesStatement(methodBody);
                this.tmpSB.insert(0, "();\n");
                this.tmpSB.insert(0, this.clazz.getName());
                this.tmpSB.insert(0, "bean = new ");
                this.tmpSB.append("$1.doForEachRupture(");
                this.tmpSB.append(this.getBeanId());
                this.tmpSB.append(");\n");
                this.doIfRupture(this.tmpSB, "else bean = (", this.clazz.getName(), ")$3;\n");
                this.mainSB.append((CharSequence)this.secondarySB);
                methodBody.append((CharSequence)this.mainSB);
                this.doAtEnd(methodBody);
                methodBody.append("\nreturn bean;\n}");
                meth.setBody(methodBody.toString());
                transfoClazz.addMethod(meth);
                this.transfo = (SQLBeanAccess)pool.toClass(transfoClazz).newInstance();
            }

            protected void doAtEnd(StringBuilder methodBody) {
                methodBody.append("$1.doForEachRecord(bean);\n");
                for (Integer id : this.colType.keySet()) {
                    methodBody.append("$4[").append(id - 1).append("]=resultStr").append(id).append(";\n");
                }
            }

            private void fillInInitVariablesStatement(StringBuilder methodBody) {
                for (Integer colid : this.colType.keySet()) {
                    Class type = this.colType.get(colid);
                    if (type.isPrimitive()) {
                        this.doPrimitive(methodBody, colid, type);
                        continue;
                    }
                    if (type != String.class) {
                        this.doObject(methodBody, colid, type);
                        continue;
                    }
                    this.doString(methodBody, colid, type);
                }
            }

            protected void doString(StringBuilder methodBody, Integer colid, Class type) {
                methodBody.append(type.getName()).append(" result").append(colid).append("= $2.get").append(this.getAccessorString(type)).append("(").append(colid).append(");\n");
                this.doObjectStrVar(methodBody, colid);
            }

            protected void doObject(StringBuilder methodBody, Integer colid, Class type) {
                try {
                    type.getDeclaredField("TYPE");
                    methodBody.append(type.getName());
                    methodBody.append(" result").append(colid).append("= new ").append(type.getSimpleName()).append("( $2.get").append(this.getAccessorString(type)).append("(").append(colid).append("));\n");
                    methodBody.append("String resultStr").append(colid).append("=String.valueOf(result").append(colid).append(");\n");
                }
                catch (Exception e) {
                    this.doString(methodBody, colid, type);
                }
            }

            protected void doPrimitive(StringBuilder methodBody, Integer colid, Class type) {
                methodBody.append(type.getName());
                methodBody.append(" result").append(colid).append("= $2.get").append(this.getAccessorString(type)).append("(").append(colid).append(");\n");
                methodBody.append("String resultStr").append(colid).append("=String.valueOf(result").append(colid).append(");\n");
            }

            private void doObjectStrVar(StringBuilder methodBody, Integer colid) {
                methodBody.append("String resultStr").append(colid).append(";\n");
                methodBody.append("if (result").append(colid).append(" != null)\n");
                methodBody.append("resultStr").append(colid).append("=result").append(colid).append(".toString();\n");
                methodBody.append("else ").append("resultStr").append(colid).append("= \"NULL\";\n");
            }

            protected void doIfRupture(StringBuilder content, String ... elseClause) {
                this.mainSB.append("if(!(");
                boolean first = true;
                for (String bId : this.beanIdsmap.keySet()) {
                    for (Integer colId : this.beanIdsmap.get(bId)) {
                        if (!first) {
                            this.mainSB.append("&&");
                        }
                        this.mainSB.append("resultStr").append(colId + 1).append(".equals(");
                        this.mainSB.append("$4[").append(colId);
                        this.mainSB.append("])");
                        first = false;
                    }
                }
                this.mainSB.append(")){\n");
                this.mainSB.append((CharSequence)content);
                this.mainSB.append("}\n");
                for (String str : elseClause) {
                    this.mainSB.append(str);
                }
            }

            @Override
            protected void doColumnField(SQLind data, Method setter, int idx) throws Exception {
                Class<?> ClassType = setter.getParameterTypes()[0];
                this.tmpSB.append(this.getBeanId()).append(".").append(setter.getName()).append("(result").append(idx + 1).append(");\n");
                this.registerCol(idx, ClassType);
            }

            @Override
            protected void doLinkField(Method setter, SQLind data) throws Exception {
                Class<? extends Object> subClazz = data.link();
                for (Method method : subClazz.getMethods()) {
                    SQLind subData = method.getAnnotation(SQLind.class);
                    if (subData == null) continue;
                    this.beanId.add(setter.getName());
                    this.tmpSB.append(subClazz.getName()).append(" ").append(this.getBeanId()).append("=new ").append(subClazz.getName()).append("();");
                    this.initSetter(subData, method);
                    String subBeanId = this.getBeanId();
                    this.beanId.remove(this.beanId.size() - 1);
                    this.tmpSB.append(this.getBeanId()).append(".").append(setter.getName()).append("(").append(subBeanId).append(");\n");
                }
            }

            @Override
            protected void doLinkList(Method setter, SQLind data) throws Exception {
                Class<? extends Object> subClazz = data.link();
                ArrayList<String> beanIds = new ArrayList<String>(this.beanId);
                beanIds.add(setter.getName());
                this.tmpSB.append(this.createNewBeanList(beanIds));
                TransformationSubWiring subTransfo = new TransformationSubWiring(subClazz, beanIds);
                this.secondarySB.append((CharSequence)subTransfo.mainSB);
                this.colType.putAll(subTransfo.colType);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class TransformationSubWiring<Z>
        extends TransformationWiring {
            protected TransformationSubWiring(Class clazz, List<String> beanIds) throws Exception {
                super(clazz);
                this.beanId = beanIds;
                this.init();
            }

            @Override
            protected void after() throws Exception {
                this.tmpSB.append("$1.doForEachSubRupture(");
                this.tmpSB.append(this.getBeanId());
                this.tmpSB.append(");\n");
                this.tmpSB.insert(0, ");\n");
                this.tmpSB.insert(0, this.getBeanId());
                this.tmpSB.insert(0, "().add(");
                this.tmpSB.insert(0, this.getGetterForBean());
                this.tmpSB.insert(0, "();\n");
                this.tmpSB.insert(0, this.clazz.getName());
                this.tmpSB.insert(0, "= new ");
                this.tmpSB.insert(0, this.getBeanId());
                this.doIfRupture(this.tmpSB, "else ", this.getBeanId(), " = ", this.getGetterForBean(), "().get(", this.getGetterForBean(), "().size()-1);\n");
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class ReflectionWiring
        extends WiringPolicy {
            HashMap<Integer, Method> setterMap;
            List<WireringLink> linkMap;
            List<WireringLink> fieldMap;

            protected <Z> ReflectionWiring(Class<Z> clazz) throws Exception {
                super(clazz);
                this.init();
            }

            private Object doWiring(GenericQueryHandler.BeanWiringBehavior beahavior, boolean one2Many, String[] strValues, Object bean, Object ... values) throws Exception {
                boolean rupture = this.isRupture(strValues, bean);
                if (rupture) {
                    bean = this.clazz.newInstance();
                    for (Integer i : this.setterMap.keySet()) {
                        this.setterMap.get(i).invoke(bean, values[i]);
                    }
                    if (one2Many) {
                        beahavior.doForEachSubRupture(bean);
                    }
                }
                this.wireLinks(beahavior, strValues, bean, values);
                return bean;
            }

            private void wireLinks(GenericQueryHandler.BeanWiringBehavior behavior, String[] strValues, Object bean, Object ... values) throws Exception {
                for (WireringLink field : this.fieldMap) {
                    field.doIt(behavior, strValues, bean, values);
                }
                for (WireringLink link : this.linkMap) {
                    link.doIt(behavior, strValues, bean, values);
                }
            }

            private boolean isRupture(String[] strValues, Object bean) {
                boolean rupture = false;
                String[] lastValues = SQLQueryMapper.getContext().lastValues;
                rupture = bean != null ? this.isRuptureCase(strValues, lastValues) : true;
                return rupture;
            }

            private boolean isRuptureCase(String[] strValues, String[] lastValues) {
                for (Integer i : this.setterMap.keySet()) {
                    if (strValues[i].equals(lastValues[i])) continue;
                    return true;
                }
                for (WireringLink field : this.fieldMap) {
                    if (!field.subWirerer.isRuptureCase(strValues, lastValues)) continue;
                    return true;
                }
                return false;
            }

            protected Object wire(GenericQueryHandler.BeanWiringBehavior behavior, ResultSet rs, Object ... values) throws SQLMapperException {
                try {
                    String[] strValues = new String[values.length];
                    for (int i = 0; i < values.length; ++i) {
                        values[i] = rs.getObject(i + 1);
                        strValues[i] = values[i] != null ? values[i].toString() : "NULL";
                    }
                    boolean rupture = this.isRupture(strValues, behavior.objBean);
                    Object ret = null;
                    if (rupture) {
                        ret = this.clazz.newInstance();
                        for (Integer i : this.setterMap.keySet()) {
                            this.setterMap.get(i).invoke(ret, values[i]);
                        }
                        behavior.doForEachRupture(ret);
                    } else {
                        ret = behavior.objBean;
                    }
                    this.wireLinks(behavior, strValues, ret, values);
                    behavior.doForEachRecord(ret);
                    SQLQueryMapper.getContext().lastValues = (String[])strValues.clone();
                    return ret;
                }
                catch (Exception e) {
                    throw SQLQuery.this.getException(Errors.ERROR_DO_WIRING, e, this.clazz.getName());
                }
            }

            @Override
            protected void before() {
                this.linkMap = new ArrayList<WireringLink>();
                this.fieldMap = new ArrayList<WireringLink>();
                this.setterMap = new HashMap();
            }

            @Override
            protected void after() {
            }

            @Override
            protected void doColumnField(SQLind data, Method method, int idx) throws Exception {
                this.setterMap.put(idx, method);
            }

            @Override
            protected void doLinkField(Method method, SQLind data) throws Exception {
                this.fieldMap.add(new WireringLink(method, data));
            }

            @Override
            protected void doLinkList(Method method, SQLind data) throws Exception {
                this.linkMap.add(new ListWireringLink(method, data));
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public abstract class WiringPolicy<Z> {
            Class<Z> clazz;

            protected WiringPolicy(Class<Z> clazz) throws Exception {
                this.clazz = clazz;
            }

            protected void init() throws Exception {
                this.before();
                for (Method method : this.clazz.getMethods()) {
                    SQLind data = method.getAnnotation(SQLind.class);
                    if (data == null) continue;
                    this.initSetter(data, method);
                }
                this.after();
            }

            protected void initSetter(SQLind data, Method method) throws Exception {
                for (String colName : data.column()) {
                    int idx = SQLQuery.this.columnNames.indexOf(colName.toLowerCase());
                    if (idx == -1) continue;
                    this.doColumnField(data, method, idx);
                }
                Class<? extends Object> clazz = data.link();
                if (clazz != Object.class) {
                    Class<?> rClazz = method.getParameterTypes()[0];
                    if (rClazz.getName().equals(clazz.getName())) {
                        this.doLinkField(method, data);
                    } else {
                        this.doLinkList(method, data);
                    }
                }
            }

            protected abstract void doColumnField(SQLind var1, Method var2, int var3) throws Exception;

            protected abstract void doLinkField(Method var1, SQLind var2) throws Exception;

            protected abstract void doLinkList(Method var1, SQLind var2) throws Exception;

            protected abstract void before() throws Exception;

            protected abstract void after() throws Exception;

            protected abstract Z wire(GenericQueryHandler.BeanWiringBehavior<Z> var1, ResultSet var2, Object ... var3) throws SQLMapperException;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class WireringLink {
            Method getter;
            Method setter;
            Class<? extends Object> subClazz;
            ReflectionWiring subWirerer;

            public WireringLink(Method setter, SQLind info) throws Exception {
                this.subClazz = info.link();
                this.getter = SQLQuery.this.transformSetter2Getter(setter);
                this.setter = setter;
                this.subWirerer = new ReflectionWiring(this.subClazz);
            }

            public <T> Object doIt(GenericQueryHandler.BeanWiringBehavior behavior, String[] strValues, T bean, Object[] values) throws Exception {
                Object res;
                Object target = this.getter.invoke(bean, SQLQuery.this.NOARG);
                if (target != (res = this.subWirerer.doWiring(behavior, false, strValues, target, values))) {
                    this.setter.invoke(bean, res);
                }
                return target;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class ListWireringLink
        extends WireringLink {
            public ListWireringLink(Method setter, SQLind info) throws Exception {
                super(setter, info);
            }

            @Override
            public <T> Object doIt(GenericQueryHandler.BeanWiringBehavior behavior, String[] strValues, T bean, Object[] values) throws Exception {
                ArrayList<Object> targetList = (ArrayList<Object>)this.getter.invoke(bean, SQLQuery.this.NOARG);
                Object target = null;
                if (targetList == null) {
                    targetList = new ArrayList<Object>();
                    this.setter.invoke(bean, targetList);
                } else {
                    target = targetList.get(targetList.size() - 1);
                }
                Object res = this.subWirerer.doWiring(behavior, true, strValues, target, values);
                if (res != target) {
                    targetList.add(res);
                }
                return target;
            }
        }

        private class Info {
            String[] infos;
            StringBuilder ctx = new StringBuilder();

            Info(String[] infos) {
                this.ctx.append("\nQuery     :").append(SQLQuery.this.id);
                this.ctx.append("\nSQL       :").append((CharSequence)SQLQueryMapper.getContext().strBuilder);
                this.ctx.append("\nparam     :").append(SQLQuery.this.parameters);
                this.ctx.append("\ncolumns   :").append(SQLQuery.this.columnNames);
                this.infos = infos;
            }

            String get(int i) {
                if (i < this.infos.length) {
                    return this.infos[i];
                }
                return "'?'";
            }
        }
    }

    private class SQLIncludedQuery
    extends SQLQuery {
        public void shrink() {
        }

        public SQLIncludedQuery(String file, String schema, String id, String ... params) throws SQLMapperException {
            this.createTemplate(file, schema, id, params);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface SQLQueryTemplate {
        public List<String> getParameters();

        public List<InjectPoint> getInjectPoints();

        public String getSQL();

        public void setSQL(String var1);

        public WiringPolicies getWiringPolicy();

        public String getID();

        public List<String> getColumns();

        public <Z> SQLQuery.WiringPolicy<Z> getWiringPolicyClass(Class<Z> var1) throws SQLMapperException;

        public SQLMapperException getException(Errors var1, Throwable var2, String ... var3);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class GenericQueryHandler {
        protected SQLQueryTemplate template;
        protected PreparedStatement ps = null;
        protected ResultSet rs = null;
        Object[] values = null;
        protected HashMap<String, Object> parameterValues = new HashMap(0);
        protected HashMap<String, String> injectPointValues = new HashMap(0);
        protected boolean debug = false;

        public List<InjectPoint> getInjectPoints() {
            return this.template.getInjectPoints();
        }

        protected GenericQueryHandler(SQLQueryTemplate template) {
            if (template.getWiringPolicy() == WiringPolicies.reload) {
                this.debug = true;
            }
            this.template = template;
        }

        protected void dumpQuery() {
            if (this.debug) {
                log.info((Object)("Processing query '" + this.template.getID() + "' : \n" + this.getSQLWithParameters()));
                this.template.setSQL(SQLQueryMapper.shrinkSQL(this.template.getSQL(), this.template.getInjectPoints()));
            }
        }

        public String getSQLWithParameters() {
            String query = this.getInjectedSQL();
            List<String> params = this.template.getParameters();
            if (params != null) {
                for (String param : params) {
                    Object paramValue = this.parameterValues.get(param);
                    if (paramValue == null) {
                        query = query.replaceFirst("\\?", "!");
                        continue;
                    }
                    if (paramValue instanceof String || paramValue instanceof Date) {
                        query = query.replaceFirst("\\?", "'" + paramValue.toString() + "'");
                        continue;
                    }
                    query = query.replaceFirst("\\?", paramValue.toString());
                }
            }
            return query;
        }

        public void close() {
            try {
                if (this.ps != null) {
                    this.ps.close();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                if (this.rs != null) {
                    this.rs.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void setParameter(String paramId, Object value) throws SQLMapperException {
            this.parameterValues.put(paramId, value);
        }

        public void setInjection(String injectPointId, String value) throws SQLMapperException {
            this.injectPointValues.put(injectPointId, value);
        }

        public String getSQL() {
            return this.template.getSQL();
        }

        public String getInjectedSQL() {
            return this.performInjection(this.injectPointValues);
        }

        public void fillInParametersFromBean(Object bean) throws SQLMapperException {
            try {
                for (String paramId : this.template.getParameters()) {
                    this.parameterValues.put(paramId, BeanUtils.getProperty((Object)bean, (String)paramId));
                }
            }
            catch (Exception e) {
                this.template.getException(Errors.ERROR_SET_WIRING, e, bean.getClass().getName());
            }
        }

        protected String performInjection(HashMap<String, String> ipValues) {
            SQLQueryMapper.getContext().clearStrBuilder();
            StringBuilder sb = SQLQueryMapper.getContext().strBuilder;
            int idx = 0;
            for (InjectPoint ip : this.template.getInjectPoints()) {
                sb.append(this.template.getSQL().substring(idx, ip.idx));
                String value = ipValues.get(ip.name);
                if (value != null) {
                    sb.append(value);
                }
                idx = ip.idx;
            }
            sb.append(this.template.getSQL().substring(idx, this.template.getSQL().length()));
            return sb.toString();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class SingleBeanListWiringBehavior<T>
        extends BeanListWiringBehavior<T> {
            public SingleBeanListWiringBehavior(Class<T> clazz, List<T> list) throws SQLMapperException {
                super(clazz, list);
            }

            @Override
            public void doForEachRupture(T bean) {
            }

            @Override
            public void doForEachRecord(T bean) {
                this.list.add(bean);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class BeanListWiringBehavior<T>
        extends BeanWiringBehavior<T> {
            protected List<T> list;

            public BeanListWiringBehavior(Class<T> clazz, List<T> list) throws SQLMapperException {
                super(clazz);
                this.list = list;
            }

            @Override
            public void doForEachRecord(T bean) {
            }

            @Override
            public void doForEachRupture(T bean) {
                this.list.add(bean);
            }

            @Override
            public void doForEachSubRupture(Object bean) {
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public abstract class BeanWiringBehavior<T>
        implements QueryBehavior {
            protected Class<T> clazz;
            protected T objBean;
            SQLQuery.WiringPolicy<T> wp;

            public BeanWiringBehavior(Class<T> clazz) throws SQLMapperException {
                this.clazz = clazz;
                this.wp = GenericQueryHandler.this.template.getWiringPolicyClass(clazz);
            }

            @Override
            public void fetch(ResultSet rs) throws Exception {
                T bean = this.wp.wire(this, rs, GenericQueryHandler.this.values);
                this.objBean = bean;
            }

            protected T getNewBean() throws Exception {
                return this.clazz.newInstance();
            }

            public abstract void doForEachRupture(T var1);

            public abstract void doForEachSubRupture(Object var1);

            public abstract void doForEachRecord(T var1);
        }

        public abstract class ResultSetFecthedBehaviour
        implements QueryBehavior {
            public void fetch(ResultSet rs) throws Exception {
                this.doForEach(rs);
            }

            public abstract void doForEach(ResultSet var1) throws Exception;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class SQLQueryHandler
    extends GenericQueryHandler {
        protected SQLQueryHandler(SQLQueryTemplate template) {
            super(template);
        }

        public <T> List<T> getBeanList(Connection cnx, Class beanTypeClazz) throws SQLMapperException {
            ArrayList list = new ArrayList();
            this.performSelectQuery(cnx, new GenericQueryHandler.BeanListWiringBehavior(beanTypeClazz, list));
            return list;
        }

        public <T> List<T> getSingleBeanList(Connection cnx, Class beanTypeClazz) throws SQLMapperException {
            ArrayList list = new ArrayList();
            this.performSelectQuery(cnx, new GenericQueryHandler.SingleBeanListWiringBehavior(beanTypeClazz, list));
            return list;
        }

        public <T> List<T> getSimpleResultList(Connection cnx, Class simpleTypeClazz) throws SQLMapperException {
            try {
                this.dumpQuery();
                this.ps = cnx.prepareStatement(this.performInjection(this.injectPointValues));
                this.fillInPreparedStatement(this.ps, this.parameterValues);
                ResultSet rs = this.ps.executeQuery();
                ArrayList<Object> list = new ArrayList<Object>();
                while (rs.next()) {
                    list.add(rs.getObject(1));
                }
                ArrayList<Object> arrayList = list;
                return arrayList;
            }
            catch (Exception e) {
                throw this.template.getException(Errors.ERROR_SQL, e, this.getSQLWithParameters());
            }
            finally {
                this.close();
            }
        }

        public <T> T getSimpleResult(Connection cnx) throws SQLMapperException {
            try {
                this.dumpQuery();
                this.ps = cnx.prepareStatement(this.performInjection(this.injectPointValues));
                this.fillInPreparedStatement(this.ps, this.parameterValues);
                ResultSet rs = this.ps.executeQuery();
                if (rs.next()) {
                    Object object = rs.getObject(1);
                    return (T)object;
                }
                T t = null;
                return t;
            }
            catch (Exception e) {
                throw this.template.getException(Errors.ERROR_SQL, e, this.getSQLWithParameters());
            }
            finally {
                this.close();
            }
        }

        public void performUpdateQuery(Connection cnx) throws SQLMapperException {
            try {
                this.dumpQuery();
                this.ps = cnx.prepareStatement(this.performInjection(this.injectPointValues));
                this.fillInPreparedStatement(this.ps, this.parameterValues);
                this.ps.executeUpdate();
            }
            catch (Exception e) {
                throw this.template.getException(Errors.ERROR_SQL, e, this.getSQLWithParameters());
            }
            finally {
                this.close();
            }
        }

        public void performSelectQuery(Connection cnx, QueryBehavior behaviour) throws SQLMapperException {
            try {
                this.dumpQuery();
                this.ps = cnx.prepareStatement(this.performInjection(this.injectPointValues));
                this.fillInPreparedStatement(this.ps, this.parameterValues);
                ResultSet rs = this.ps.executeQuery();
                this.values = new Object[this.template.getColumns().size()];
                SQLQueryMapper.getContext().lastValues = new String[this.values.length];
                while (rs.next()) {
                    behaviour.fetch(rs);
                }
            }
            catch (SQLMapperException sqlme) {
                throw sqlme;
            }
            catch (Exception e) {
                throw this.template.getException(Errors.ERROR_SQL, e, this.getSQLWithParameters());
            }
            finally {
                this.close();
            }
        }

        protected void fillInPreparedStatement(PreparedStatement ps, HashMap<String, Object> pValues) throws SQLException {
            int j = 1;
            for (String paramId : this.template.getParameters()) {
                ps.setObject(j++, pValues.get(paramId));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SQLQueryHandler getSQLQuery(String file, String schema, String id, String ... params) throws SQLMapperException {
            if (!instances.containsKey(file)) {
                HashMap<String, SQLQueryMapper> hashMap = instances;
                synchronized (hashMap) {
                    if (!instances.containsKey(file)) {
                        instances.put(file, new SQLQueryMapper(file));
                    }
                }
            }
            return new SQLQueryHandler(instances.get(file).getQuery(schema, id, params));
        }
    }

    public static interface SQLBeanAccess {
        public Object buildFromResultSet(GenericQueryHandler.BeanWiringBehavior var1, ResultSet var2, Object var3, String[] var4) throws Exception;
    }

    class Context {
        private StringBuilder queryKey = new StringBuilder();
        private StringBuilder strBuilder = new StringBuilder();
        String[] lastValues;

        Context() {
        }

        private void clearStrBuilder() {
            this.strBuilder.delete(0, this.strBuilder.length());
        }
    }

    public class SQLMapperException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public SQLMapperException(String msg, Throwable originalException) {
            super(msg, originalException);
        }
    }

    public static interface QueryBehavior {
        public void fetch(ResultSet var1) throws Exception;
    }

    public class InjectPoint {
        private String name;
        private Integer idx;

        private InjectPoint(String name, Integer idx) {
            this.name = name;
            this.idx = idx;
        }

        public String toString() {
            return this.idx + this.name;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum Errors {
        ERROR_UNKNOWN,
        ERROR_INIT_WIRING,
        ERROR_DO_WIRING,
        ERROR_SET_WIRING,
        ERROR_SQL,
        ERROR_INIT_QUERY,
        ERROR_INIT_QUERIES;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum WiringPolicies {
        reload,
        lru,
        fast;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Tags {
        queries,
        query,
        var,
        include,
        section,
        inject;

    }
}

