/*
 * Decompiled with CFR 0.152.
 */
package org.carewebframework.help.javahelp;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.help.NavigatorView;
import javax.help.search.MergingSearchEngine;
import javax.help.search.SearchEngine;
import javax.help.search.SearchEvent;
import javax.help.search.SearchItem;
import javax.help.search.SearchListener;
import javax.help.search.SearchQuery;
import org.carewebframework.help.HelpSearchHit;
import org.carewebframework.help.HelpSearcher;
import org.carewebframework.help.HelpTopic;
import org.carewebframework.help.HelpViewType;
import org.carewebframework.help.javahelp.HelpView;
import org.zkoss.util.Locales;

public class HelpViewSearch
extends HelpView
implements HelpSearcher.IHelpSearch {
    private SearchEngine searchEngine;

    public HelpViewSearch(NavigatorView view) {
        super(view, HelpViewType.Search);
    }

    public void search(String searchString, final HelpSearcher.IHelpSearchListener listener) {
        if (this.searchEngine == null) {
            this.searchEngine = new MergingSearchEngine(this.view);
        }
        SearchQuery query = this.searchEngine.createQuery();
        query.addSearchListener(new SearchListener(){

            public void itemsFound(SearchEvent e) {
                listener.onSearchComplete(HelpViewSearch.this.processResults(e.getSearchItems()));
            }

            public void searchStarted(SearchEvent e) {
            }

            public void searchFinished(SearchEvent e) {
            }
        });
        query.start(searchString, Locales.getCurrent());
    }

    private List<HelpSearchHit> processResults(Enumeration<SearchItem> searchItems) {
        ArrayList<HelpSearchHit> hits = new ArrayList<HelpSearchHit>();
        String source = this.view.getHelpSet().getTitle();
        while (searchItems.hasMoreElements()) {
            SearchItem si = searchItems.nextElement();
            try {
                URL url = new URL(si.getBase(), si.getFilename());
                HelpTopic topic = new HelpTopic(url, si.getTitle(), source);
                hits.add(new HelpSearchHit(topic, si.getConfidence()));
            }
            catch (MalformedURLException e) {}
        }
        return hits;
    }
}

