/*
 * Decompiled with CFR 0.152.
 */
package fj;

import fj.Class;
import fj.F;
import fj.Function;
import fj.P;
import fj.P1;
import fj.P2;
import fj.P3;
import fj.P4;
import fj.P5;
import fj.P6;
import fj.P7;
import fj.P8;
import fj.Unit;
import fj.data.Array;
import fj.data.Either;
import fj.data.LazyString;
import fj.data.List;
import fj.data.Natural;
import fj.data.NonEmptyList;
import fj.data.Option;
import fj.data.PriorityQueue;
import fj.data.Seq;
import fj.data.Set;
import fj.data.Stream;
import fj.data.Tree;
import fj.data.TreeMap;
import fj.data.Validation;
import fj.data.fingertrees.Digit;
import fj.data.fingertrees.FingerTree;
import fj.data.fingertrees.Node;
import fj.data.hamt.BitSet;
import fj.data.hamt.HashArrayMappedTrie;
import fj.data.hlist.HList;
import fj.data.vector.V2;
import fj.data.vector.V3;
import fj.data.vector.V4;
import fj.data.vector.V5;
import fj.data.vector.V6;
import fj.data.vector.V7;
import fj.data.vector.V8;
import java.math.BigDecimal;
import java.math.BigInteger;

public final class Show<A> {
    private final F<A, Stream<Character>> f;
    public static final Show<Boolean> booleanShow = Show.anyShow();
    public static final Show<Byte> byteShow = Show.anyShow();
    public static final Show<Character> charShow = Show.anyShow();
    public static final Show<Double> doubleShow = Show.anyShow();
    public static final Show<Float> floatShow = Show.anyShow();
    public static final Show<Integer> intShow = Show.anyShow();
    public static final Show<BigInteger> bigintShow = Show.anyShow();
    public static final Show<BigDecimal> bigdecimalShow = Show.anyShow();
    public static final Show<Long> longShow = Show.anyShow();
    public static final Show<Short> shortShow = Show.anyShow();
    public static final Show<String> stringShow = Show.anyShow();
    public static final Show<StringBuffer> stringBufferShow = Show.anyShow();
    public static final Show<StringBuilder> stringBuilderShow = Show.anyShow();
    public static final Show<Natural> naturalShow = bigintShow.contramap(Natural::bigIntegerValue);
    public static final Show<LazyString> lazyStringShow = Show.show(LazyString::toStream);
    public static final Show<HList.HNil> HListShow = Show.showS(Function.constant("Nil"));
    public static final Show<BitSet> bitSetShow = Show.showS(bs -> "BitSet(" + bs.asString() + ")");

    private Show(F<A, Stream<Character>> f) {
        this.f = f;
    }

    public <B> Show<B> contramap(F<B, A> f) {
        return Show.show(Function.compose(this.f, f));
    }

    public Stream<Character> show(A a) {
        return this.f.f(a);
    }

    public List<Character> showl(A a) {
        return this.show(a).toList();
    }

    public String showS(A a) {
        return Stream.asString(this.show(a));
    }

    public F<A, String> showS_() {
        return this::showS;
    }

    public F<A, Stream<Character>> show_() {
        return this.f;
    }

    public Unit println(A a) {
        this.print(a);
        System.out.println();
        return Unit.unit();
    }

    public Unit print(A a) {
        char[] buffer = new char[8192];
        int c = 0;
        Stream<Character> cs = this.show(a);
        while (cs.isNotEmpty()) {
            buffer[c] = cs.head().charValue();
            if (++c == 8192) {
                System.out.print(buffer);
                c = 0;
            }
            cs = cs.tail()._1();
        }
        System.out.print(Array.copyOfRange(buffer, 0, c));
        return Unit.unit();
    }

    public void printlnE(A a) {
        System.err.println(this.showS(a));
    }

    public static <A> Show<A> show(F<A, Stream<Character>> f) {
        return new Show<A>(f);
    }

    public static <A> Show<A> showS(F<A, String> f) {
        return Show.show(a -> Stream.fromString((String)f.f(a)));
    }

    public static <A> Show<A> anyShow() {
        return Show.show(a -> Stream.fromString(a == null ? "null" : a.toString()));
    }

    public static <A> Show<Option<A>> optionShow(Show<A> sa) {
        return Show.show(o -> o.isNone() ? Stream.fromString("None") : Stream.fromString("Some(").append(sa.f.f(o.some())).append(Stream.single(Character.valueOf(')'))));
    }

    public static <A, B> Show<Either<A, B>> eitherShow(Show<A> sa, Show<B> sb) {
        return Show.show(e -> e.isLeft() ? Stream.fromString("Left(").append(sa.f.f(e.left().value())).append(Stream.single(Character.valueOf(')'))) : Stream.fromString("Right(").append(sb.f.f(e.right().value())).append(Stream.single(Character.valueOf(')'))));
    }

    public static <A, B> Show<Validation<A, B>> validationShow(Show<A> sa, Show<B> sb) {
        return Show.show(v -> v.isFail() ? Stream.fromString("Fail(").append(sa.f.f(v.fail())).append(Stream.single(Character.valueOf(')'))) : Stream.fromString("Success(").append(sb.f.f(v.success())).append(Stream.single(Character.valueOf(')'))));
    }

    public static <A> Show<List<A>> listShow(Show<A> sa) {
        return Show.show(as -> Show.streamShow(sa, "List(", ",", ")").show(as.toStream()));
    }

    public static <A> Show<NonEmptyList<A>> nonEmptyListShow(Show<A> sa) {
        return Show.listShow(sa).contramap(NonEmptyList.toList_());
    }

    public static <A> Show<Tree<A>> treeShow(Show<A> sa) {
        return Show.show(a -> {
            Stream<Character> result = sa.f.f(a.root());
            if (!a.subForest()._1().isEmpty()) {
                result = result.append(Stream.fromString(",")).append(Show.streamShow(Show.treeShow(sa), (String)"", (String)",", (String)"").f.f(a.subForest()._1()));
            }
            return Stream.fromString("Tree(").append(P.p(result)).append(Stream.fromString(")"));
        });
    }

    public static <V, A> Show<Digit<V, A>> digitShow(Show<V> sv, Show<A> sa) {
        return Show.show(d -> {
            String s = d.match(o -> "One(" + o.measure() + " -> " + o.value() + ")", two -> "Two(" + two.measure() + " -> " + Show.v2Show(sa).showS(two.values()) + ")", three -> "Three(" + three.measure() + " -> " + Show.v3Show(sa).showS(three.values()) + ")", four -> "Four(" + four.measure() + " -> " + Show.v4Show(sa).showS(four.values()) + ")");
            return Stream.fromString(s);
        });
    }

    public static <V, A> Show<Node<V, A>> nodeShow(Show<V> sv, Show<A> sa) {
        return Show.show(n -> {
            String s = n.match(n2 -> "Node2(" + n2.measure() + " -> " + Show.v2Show(sa).showS(n2.toVector()) + ")", n3 -> "Node3(" + n3.measure() + " -> " + Show.v3Show(sa).showS(n3.toVector()) + ")");
            return Stream.fromString(s);
        });
    }

    public static <V, A> Show<FingerTree<V, A>> fingerTreeShow(Show<V> sv, Show<A> sa) {
        return Show.show(ft -> {
            String sep = ", ";
            String str = ft.match(e -> "Empty()", s -> "Single(" + sv.showS(ft.measure()) + " -> " + sa.showS(s.value()) + ")", d -> "Deep(" + d.measure() + " -> " + Show.digitShow(sv, sa).showS(d.prefix()) + sep + Show.fingerTreeShow(sv, Show.nodeShow(sv, sa)).showS(d.middle()) + sep + Show.digitShow(sv, sa).showS(d.suffix()) + ")");
            return Stream.fromString(str);
        });
    }

    public static <A> Show<Seq<A>> seqShow(Show<A> sa) {
        return Show.show(s -> Show.streamShow(sa, "Seq(", ",", ")").show(s.toStream()));
    }

    public static <A> Show<Set<A>> setShow(Show<A> sa) {
        return Show.show(s -> Show.streamShow(sa, "Set(", ",", ")").show(s.toStream()));
    }

    public static <K, V> Show<TreeMap<K, V>> treeMapShow(Show<K> sk, Show<V> sv) {
        return Show.show(tm -> {
            Stream stream = Stream.iteratorStream(tm.iterator());
            return Show.streamShow(Show.p2MapShow(sk, sv), "TreeMap(", ",", ")").show(stream);
        });
    }

    public static <A, B> Show<P2<A, B>> p2MapShow(Show<A> sa, Show<B> sb) {
        return Show.p2Show(sa, sb, "(", ": ", ")");
    }

    public static <A, B> Show<P2<A, B>> p2Show(Show<A> sa, Show<B> sb, String start, String sep, String end) {
        return Show.show(p -> Stream.fromString(start).append(P.p(sa.show(p._1()))).append(Stream.fromString(sep)).append(sb.show(p._2())).append(Stream.fromString(end)));
    }

    public static <A> Show<Stream<A>> streamShow(Show<A> sa) {
        return Show.streamShow(sa, "Stream(", ",", ")");
    }

    public static <A> Show<Stream<A>> streamShow(Show<A> sa, String start, String sep, String end) {
        return Show.show(Show.streamShow_(sa, start, sep, end));
    }

    public static <A> F<Stream<A>, Stream<Character>> streamShow_(Show<A> sa, String start, String sep, String end) {
        return as -> Stream.join(as.map(sa.show_()).intersperse(Stream.fromString(sep)).cons(Stream.fromString(start)).snoc(P.p(Stream.fromString(end))));
    }

    public static <A> Show<Array<A>> arrayShow(Show<A> sa) {
        return Show.show(as -> {
            Stream<Character> b = Stream.fromString("Array(");
            for (int i = 0; i < as.length(); ++i) {
                b = b.append(sa.f.f(as.get(i)));
                if (i == as.length() - 1) continue;
                b = b.append(Stream.fromString(","));
            }
            return b.append(Stream.fromString(")"));
        });
    }

    public static <A> Show<Class<A>> classShow() {
        return Show.show(c -> Show.anyShow().show(c.clas()));
    }

    public static <A> Show<P1<A>> p1Show(Show<A> sa) {
        return Show.p1ShowLazy(sa);
    }

    public static <A> Show<P1<A>> p1ShowLazy(Show<A> sa) {
        return Show.show(p -> Stream.fromString("(?)"));
    }

    public static <A> Show<P1<A>> p1ShowEager(Show<A> sa) {
        return Show.show(p -> Stream.cons(Character.valueOf('('), P.p(sa.show(p._1()))).snoc(Character.valueOf(')')));
    }

    public static <A, B> Show<P2<A, B>> p2Show(Show<A> sa, Show<B> sb) {
        return Show.p2Show(sa, sb, "(", ",", ")");
    }

    public static <A, B, C> Show<P3<A, B, C>> p3Show(Show<A> sa, Show<B> sb, Show<C> sc) {
        return Show.show(p -> Stream.cons(Character.valueOf('('), P.p(sa.show(p._1()))).snoc(Character.valueOf(',')).append(sb.show(p._2())).snoc(Character.valueOf(',')).append(sc.show(p._3())).snoc(Character.valueOf(')')));
    }

    public static <A, B, C, D> Show<P4<A, B, C, D>> p4Show(Show<A> sa, Show<B> sb, Show<C> sc, Show<D> sd) {
        return Show.show(p -> Stream.cons(Character.valueOf('('), P.p(sa.show(p._1()))).snoc(Character.valueOf(',')).append(sb.show(p._2())).snoc(Character.valueOf(',')).append(sc.show(p._3())).snoc(Character.valueOf(',')).append(sd.show(p._4())).snoc(Character.valueOf(')')));
    }

    public static <A, B, C, D, E> Show<P5<A, B, C, D, E>> p5Show(Show<A> sa, Show<B> sb, Show<C> sc, Show<D> sd, Show<E> se) {
        return Show.show(p -> Stream.cons(Character.valueOf('('), P.p(sa.show(p._1()))).snoc(Character.valueOf(',')).append(sb.show(p._2())).snoc(Character.valueOf(',')).append(sc.show(p._3())).snoc(Character.valueOf(',')).append(sd.show(p._4())).snoc(Character.valueOf(',')).append(se.show(p._5())).snoc(Character.valueOf(')')));
    }

    public static <A, B, C, D, E, F$> Show<P6<A, B, C, D, E, F$>> p6Show(Show<A> sa, Show<B> sb, Show<C> sc, Show<D> sd, Show<E> se, Show<F$> sf) {
        return Show.show(p -> Stream.cons(Character.valueOf('('), P.p(sa.show(p._1()))).snoc(Character.valueOf(',')).append(sb.show(p._2())).snoc(Character.valueOf(',')).append(sc.show(p._3())).snoc(Character.valueOf(',')).append(sd.show(p._4())).snoc(Character.valueOf(',')).append(se.show(p._5())).snoc(Character.valueOf(',')).append(sf.show(p._6())).snoc(Character.valueOf(')')));
    }

    public static <A, B, C, D, E, F$, G> Show<P7<A, B, C, D, E, F$, G>> p7Show(Show<A> sa, Show<B> sb, Show<C> sc, Show<D> sd, Show<E> se, Show<F$> sf, Show<G> sg) {
        return Show.show(p -> Stream.cons(Character.valueOf('('), P.p(sa.show(p._1()))).snoc(Character.valueOf(',')).append(sb.show(p._2())).snoc(Character.valueOf(',')).append(sc.show(p._3())).snoc(Character.valueOf(',')).append(sd.show(p._4())).snoc(Character.valueOf(',')).append(se.show(p._5())).snoc(Character.valueOf(',')).append(sf.show(p._6())).snoc(Character.valueOf(',')).append(sg.show(p._7())).snoc(Character.valueOf(')')));
    }

    public static <A, B, C, D, E, F$, G, H> Show<P8<A, B, C, D, E, F$, G, H>> p8Show(Show<A> sa, Show<B> sb, Show<C> sc, Show<D> sd, Show<E> se, Show<F$> sf, Show<G> sg, Show<H> sh) {
        return Show.show(p -> Stream.cons(Character.valueOf('('), P.p(sa.show(p._1()))).snoc(Character.valueOf(',')).append(sb.show(p._2())).snoc(Character.valueOf(',')).append(sc.show(p._3())).snoc(Character.valueOf(',')).append(sd.show(p._4())).snoc(Character.valueOf(',')).append(se.show(p._5())).snoc(Character.valueOf(',')).append(sf.show(p._6())).snoc(Character.valueOf(',')).append(sg.show(p._7())).snoc(Character.valueOf(',')).append(sh.show(p._8())).snoc(Character.valueOf(')')));
    }

    public static <K, V> Show<PriorityQueue<K, V>> priorityQueueShow(Show<K> sk, Show<V> sv) {
        return Show.show(pq -> Show.streamShow(Show.p2MapShow(sk, sv), "PriorityQueue(", ", ", ")").show(pq.toStream()));
    }

    public static <A> Show<V2<A>> v2Show(Show<A> ea) {
        return Show.streamShow(ea, "V2(", ",", ")").contramap(V2.toStream_());
    }

    public static <A> Show<V3<A>> v3Show(Show<A> ea) {
        return Show.streamShow(ea, "V3(", ",", ")").contramap(V3.toStream_());
    }

    public static <A> Show<V4<A>> v4Show(Show<A> ea) {
        return Show.streamShow(ea, "V4(", ",", ")").contramap(V4.toStream_());
    }

    public static <A> Show<V5<A>> v5Show(Show<A> ea) {
        return Show.streamShow(ea, "V5(", ",", ")").contramap(V5.toStream_());
    }

    public static <A> Show<V6<A>> v6Show(Show<A> ea) {
        return Show.streamShow(ea, "V6(", ",", ")").contramap(V6.toStream_());
    }

    public static <A> Show<V7<A>> v7Show(Show<A> ea) {
        return Show.streamShow(ea, "V7(", ",", ")").contramap(V7.toStream_());
    }

    public static <A> Show<V8<A>> v8Show(Show<A> ea) {
        return Show.streamShow(ea, "V8(", ",", ")").contramap(V8.toStream_());
    }

    public static <A> Show<Stream<A>> unlineShow(Show<A> sa) {
        return Show.show(as -> Stream.join(as.map(sa.show_()).intersperse(Stream.fromString("\n"))));
    }

    public static <E, L extends HList<L>> Show<HList.HCons<E, L>> HListShow(Show<E> e, Show<L> l) {
        return Show.show(c -> Stream.fromString("HList(").append(e.show(c.head())).append(l.show(c.tail())).append(Stream.fromString(")")));
    }

    public static <K, V> Show<fj.data.hamt.Node<K, V>> hamtNodeShow(Show<K> sk, Show<V> sv) {
        F<fj.data.hamt.Node, String> f = n -> n.match(p -> Show.p2Show(sk, sv).showS((P2)p), h -> Show.hamtShow(sk, sv).showS((HashArrayMappedTrie)h));
        return Show.showS(f);
    }

    public static <K, V> Show<HashArrayMappedTrie<K, V>> hamtShow(Show<K> sk, Show<V> sv) {
        return Show.showS(hamt -> "HashArrayMappedTrie(" + bitSetShow.showS(hamt.getBitSet()) + ", " + Show.seqShow(Show.hamtNodeShow(sk, sv)).showS(hamt.getSeq()) + ")");
    }
}

