/*
 * Decompiled with CFR 0.152.
 */
package org.graphwalker.java.test;

import java.io.File;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.graphwalker.core.event.Observer;
import org.graphwalker.core.machine.Context;
import org.graphwalker.core.machine.Machine;
import org.graphwalker.core.machine.MachineException;
import org.graphwalker.core.machine.SimpleMachine;
import org.graphwalker.core.model.Element;
import org.graphwalker.core.model.Model;
import org.graphwalker.dsl.antlr.generator.GeneratorFactory;
import org.graphwalker.io.factory.ContextFactoryScanner;
import org.graphwalker.java.annotation.AfterElement;
import org.graphwalker.java.annotation.AfterExecution;
import org.graphwalker.java.annotation.AnnotationUtils;
import org.graphwalker.java.annotation.BeforeElement;
import org.graphwalker.java.annotation.BeforeExecution;
import org.graphwalker.java.annotation.GraphWalker;
import org.graphwalker.java.annotation.Model;
import org.graphwalker.java.factory.PathGeneratorFactory;
import org.graphwalker.java.report.XMLReportGenerator;
import org.graphwalker.java.test.Configuration;
import org.graphwalker.java.test.ContextConfiguration;
import org.graphwalker.java.test.Executor;
import org.graphwalker.java.test.MachineConfiguration;
import org.graphwalker.java.test.Result;
import org.graphwalker.java.test.SelectorUtils;
import org.graphwalker.java.test.TestExecutionException;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.scanners.TypeAnnotationsScanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TestExecutor
implements Executor {
    private static final Logger logger = LoggerFactory.getLogger(TestExecutor.class);
    private static final Reflections reflections = new Reflections((org.reflections.Configuration)new ConfigurationBuilder().addUrls(TestExecutor.filter(ClasspathHelper.forJavaClassPath(), ClasspathHelper.forClassLoader())).addScanners(new Scanner[]{new SubTypesScanner(), new TypeAnnotationsScanner()}));
    private final Configuration configuration;
    private final MachineConfiguration machineConfiguration;
    private final Map<Context, MachineException> failures = new HashMap<Context, MachineException>();
    private final Machine machine;
    private Result result;

    private static Collection<URL> filter(Collection<URL> classPath, Collection<URL> classLoader) {
        Reflections.log = null;
        ArrayList<URL> urls = new ArrayList<URL>();
        ArrayList<URL> filteredUrls = new ArrayList<URL>();
        urls.addAll(classPath);
        urls.addAll(classLoader);
        for (URL url : urls) {
            if (filteredUrls.contains(url) || !new File(url.getFile()).exists()) continue;
            filteredUrls.add(url);
        }
        return filteredUrls;
    }

    public TestExecutor(Configuration configuration) {
        this.configuration = configuration;
        this.machineConfiguration = this.createMachineConfiguration(AnnotationUtils.findTests(reflections));
        this.machine = this.createMachine(this.machineConfiguration);
    }

    public TestExecutor(Class<?> ... tests) {
        this.configuration = new Configuration();
        this.machineConfiguration = this.createMachineConfiguration(Arrays.asList(tests));
        this.machine = this.createMachine(this.machineConfiguration);
    }

    public TestExecutor(Context ... contexts) {
        this.configuration = new Configuration();
        this.machineConfiguration = new MachineConfiguration();
        this.machine = new SimpleMachine(contexts);
    }

    public TestExecutor(Collection<Context> contexts) {
        this.configuration = new Configuration();
        this.machineConfiguration = new MachineConfiguration();
        this.machine = new SimpleMachine(contexts);
    }

    @Override
    public Machine getMachine() {
        return this.machine;
    }

    private MachineConfiguration createMachineConfiguration(Collection<Class<?>> testClasses) {
        MachineConfiguration machineConfiguration = new MachineConfiguration();
        for (Class<?> testClass : testClasses) {
            GraphWalker annotation = testClass.getAnnotation(GraphWalker.class);
            if (!this.isTestIncluded(annotation, testClass.getName())) continue;
            ContextConfiguration contextConfiguration = new ContextConfiguration();
            contextConfiguration.setTestClass(testClass);
            machineConfiguration.addContextConfiguration(contextConfiguration);
        }
        return machineConfiguration;
    }

    private Collection<Context> createContexts(MachineConfiguration machineConfiguration) {
        HashSet<Context> contexts = new HashSet<Context>();
        for (ContextConfiguration contextConfiguration : machineConfiguration.getContextConfigurations()) {
            Context context = this.createContext(contextConfiguration.getTestClass());
            this.configureContext(context);
            contexts.add(context);
        }
        return contexts;
    }

    private Context createContext(Class<?> testClass) {
        try {
            return (Context)testClass.newInstance();
        }
        catch (Throwable t) {
            logger.error(t.getMessage());
            throw new TestExecutionException("Failed to create context");
        }
    }

    private void configureContext(Context context) {
        Set<Model> models = AnnotationUtils.getAnnotations(context.getClass(), Model.class);
        GraphWalker annotation = context.getClass().getAnnotation(GraphWalker.class);
        if (!models.isEmpty()) {
            Path path = Paths.get(models.iterator().next().file(), new String[0]);
            ContextFactoryScanner.get((Reflections)reflections, (Path)path).create(path, context);
        }
        if (!"".equals(annotation.value())) {
            context.setPathGenerator(GeneratorFactory.parse((String)annotation.value()));
        } else {
            context.setPathGenerator(PathGeneratorFactory.createPathGenerator(annotation));
        }
        if (!"".equals(annotation.start())) {
            context.setNextElement(this.getElement(context.getModel(), annotation.start()));
        }
    }

    private Machine createMachine(MachineConfiguration machineConfiguration) {
        Collection<Context> contexts = this.createContexts(machineConfiguration);
        SimpleMachine machine = new SimpleMachine(contexts);
        for (Context context : machine.getContexts()) {
            if (!(context instanceof Observer)) continue;
            machine.addObserver((Observer)context);
        }
        return machine;
    }

    @Override
    public MachineConfiguration getMachineConfiguration() {
        return this.machineConfiguration;
    }

    @Override
    public Result execute() {
        return this.execute(false);
    }

    @Override
    public Result execute(boolean ignoreErrors) {
        this.result = new Result();
        this.executeAnnotation(BeforeExecution.class, this.machine);
        try {
            Context context = null;
            while (this.machine.hasNextStep()) {
                if (null != context) {
                    this.executeAnnotation(BeforeElement.class, context);
                }
                context = this.machine.getNextStep();
                this.executeAnnotation(AfterElement.class, context);
            }
        }
        catch (MachineException e) {
            logger.error(e.getMessage());
            this.failures.put(e.getContext(), e);
        }
        this.executeAnnotation(AfterExecution.class, this.machine);
        this.result.updateResults(this.machine, this.failures);
        if (!ignoreErrors && !this.failures.isEmpty()) {
            throw new TestExecutionException("Test execution contains failures");
        }
        return this.result;
    }

    @Override
    public Result getResult() {
        return this.result;
    }

    private boolean isTestIncluded(GraphWalker annotation, String name) {
        boolean belongsToGroup = false;
        block0: for (String group : annotation.groups()) {
            for (String definedGroups : this.configuration.getGroups()) {
                if (!SelectorUtils.match(definedGroups, group)) continue;
                belongsToGroup = true;
                continue block0;
            }
        }
        if (belongsToGroup) {
            for (String exclude : this.configuration.getExcludes()) {
                if (!SelectorUtils.match(exclude, name)) continue;
                return false;
            }
            for (String include : this.configuration.getIncludes()) {
                if (!SelectorUtils.match(include, name)) continue;
                return true;
            }
        }
        return false;
    }

    private Element getElement(Model.RuntimeModel model, String name) {
        List elements = model.findElements(name);
        if (null == elements || elements.isEmpty()) {
            throw new TestExecutionException("Start element not found");
        }
        if (1 < elements.size()) {
            throw new TestExecutionException("Ambiguous start element defined");
        }
        return (Element)elements.get(0);
    }

    private void executeAnnotation(Class<? extends Annotation> annotation, Machine machine) {
        for (Context context : machine.getContexts()) {
            this.executeAnnotation(annotation, context);
        }
    }

    private void executeAnnotation(Class<? extends Annotation> annotation, Context context) {
        AnnotationUtils.execute(annotation, context);
    }

    @Override
    public boolean isFailure(Context context) {
        return this.failures.containsKey(context);
    }

    @Override
    public MachineException getFailure(Context context) {
        return this.failures.get(context);
    }

    @Override
    public Collection<MachineException> getFailures() {
        return this.failures.values();
    }

    @Override
    public void reportResults(File file, Date startTime, Properties properties) {
        new XMLReportGenerator(startTime, properties).writeReport(file, this);
        if (!this.getFailures().isEmpty()) {
            throw new TestExecutionException(MessageFormat.format("There are test failures.\n\n Please refer to {0} for the individual test results.", file.getAbsolutePath()));
        }
    }
}

