/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.java;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.tools.ToolProvider;
import org.revapi.API;
import org.revapi.AnalysisContext;
import org.revapi.Archive;
import org.revapi.Difference;
import org.revapi.DifferenceAnalyzer;
import org.revapi.Element;
import org.revapi.Report;
import org.revapi.Stats;
import org.revapi.java.AnalysisConfiguration;
import org.revapi.java.Timing;
import org.revapi.java.compilation.CompilationValve;
import org.revapi.java.compilation.ProbingEnvironment;
import org.revapi.java.model.AnnotationElement;
import org.revapi.java.model.FieldElement;
import org.revapi.java.model.MethodElement;
import org.revapi.java.model.MethodParameterElement;
import org.revapi.java.model.TypeElement;
import org.revapi.java.spi.Check;
import org.revapi.java.spi.JavaTypeElement;
import org.revapi.java.spi.UseSite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JavaElementDifferenceAnalyzer
implements DifferenceAnalyzer {
    private static final Logger LOG = LoggerFactory.getLogger(JavaElementDifferenceAnalyzer.class);
    private static final Method CLEAR_COMPILER_CACHE;
    private static final Object SHARED_ZIP_FILE_INDEX_CACHE;
    private final Iterable<Check> checks;
    private final CompilationValve oldCompilationValve;
    private final CompilationValve newCompilationValve;
    private final AnalysisConfiguration analysisConfiguration;
    private final ResourceBundle messages;
    private final ProbingEnvironment oldEnvironment;
    private final ProbingEnvironment newEnvironment;
    private final Map<Check.Type, List<Check>> checksByInterest;
    private final Deque<Check.Type> checkTypeStack = new ArrayDeque<Check.Type>();
    private List<Difference> lastAnnotationResults;

    public JavaElementDifferenceAnalyzer(AnalysisContext analysisContext, ProbingEnvironment oldEnvironment, CompilationValve oldValve, ProbingEnvironment newEnvironment, CompilationValve newValve, Iterable<Check> checks, AnalysisConfiguration analysisConfiguration) {
        this.oldCompilationValve = oldValve;
        this.newCompilationValve = newValve;
        this.checks = checks;
        for (Check c : checks) {
            c.initialize(analysisContext);
            c.setOldTypeEnvironment(oldEnvironment);
            c.setNewTypeEnvironment(newEnvironment);
        }
        this.analysisConfiguration = analysisConfiguration;
        this.messages = ResourceBundle.getBundle("org.revapi.java.messages", analysisContext.getLocale());
        this.oldEnvironment = oldEnvironment;
        this.newEnvironment = newEnvironment;
        this.checksByInterest = new EnumMap<Check.Type, List<Check>>(Check.Type.class);
        for (Check.Type c : Check.Type.values()) {
            this.checksByInterest.put(c, new ArrayList());
        }
        for (Check c : checks) {
            for (Check.Type t : c.getInterest()) {
                List<Check> cs = this.checksByInterest.get((Object)t);
                cs.add(c);
            }
        }
    }

    public void open() {
        Timing.LOG.debug("Opening difference analyzer.");
    }

    public void close() {
        Timing.LOG.debug("About to close difference analyzer.");
        this.oldCompilationValve.removeCompiledResults();
        this.newCompilationValve.removeCompiledResults();
        JavaElementDifferenceAnalyzer.forceClearCompilerCache();
        Timing.LOG.debug("Difference analyzer closed.");
    }

    public void beginAnalysis(@Nullable Element oldElement, @Nullable Element newElement) {
        block8: {
            block11: {
                block10: {
                    block9: {
                        block7: {
                            Timing.LOG.trace("Beginning analysis of {} and {}.", (Object)oldElement, (Object)newElement);
                            if (!this.conforms(oldElement, newElement, TypeElement.class)) break block7;
                            this.checkTypeStack.push(Check.Type.CLASS);
                            for (Check c : this.checksByInterest.get((Object)Check.Type.CLASS)) {
                                Stats.of((String)c.getClass().getName()).start();
                                c.visitClass(oldElement == null ? null : ((TypeElement)oldElement).getModelElement(), newElement == null ? null : ((TypeElement)newElement).getModelElement());
                                Stats.of((String)c.getClass().getName()).end((Object)oldElement, (Object)newElement);
                            }
                            break block8;
                        }
                        if (!this.conforms(oldElement, newElement, AnnotationElement.class)) break block9;
                        if (this.lastAnnotationResults == null) {
                            this.lastAnnotationResults = new ArrayList<Difference>();
                        }
                        for (Check c : this.checksByInterest.get((Object)Check.Type.ANNOTATION)) {
                            Stats.of((String)c.getClass().getName()).start();
                            List<Difference> cps = c.visitAnnotation(oldElement == null ? null : ((AnnotationElement)oldElement).getAnnotation(), newElement == null ? null : ((AnnotationElement)newElement).getAnnotation());
                            if (cps != null) {
                                this.lastAnnotationResults.addAll(cps);
                            }
                            Stats.of((String)c.getClass().getName()).end((Object)oldElement, (Object)newElement);
                        }
                        break block8;
                    }
                    if (!this.conforms(oldElement, newElement, FieldElement.class)) break block10;
                    this.checkTypeStack.push(Check.Type.FIELD);
                    for (Check c : this.checksByInterest.get((Object)Check.Type.FIELD)) {
                        Stats.of((String)c.getClass().getName()).start();
                        c.visitField(oldElement == null ? null : (VariableElement)((FieldElement)oldElement).getModelElement(), newElement == null ? null : (VariableElement)((FieldElement)newElement).getModelElement());
                        Stats.of((String)c.getClass().getName()).end((Object)oldElement, (Object)newElement);
                    }
                    break block8;
                }
                if (!this.conforms(oldElement, newElement, MethodElement.class)) break block11;
                this.checkTypeStack.push(Check.Type.METHOD);
                for (Check c : this.checksByInterest.get((Object)Check.Type.METHOD)) {
                    Stats.of((String)c.getClass().getName()).start();
                    c.visitMethod(oldElement == null ? null : (ExecutableElement)((MethodElement)oldElement).getModelElement(), newElement == null ? null : (ExecutableElement)((MethodElement)newElement).getModelElement());
                    Stats.of((String)c.getClass().getName()).end((Object)oldElement, (Object)newElement);
                }
                break block8;
            }
            if (!this.conforms(oldElement, newElement, MethodParameterElement.class)) break block8;
            this.checkTypeStack.push(Check.Type.METHOD_PARAMETER);
            for (Check c : this.checksByInterest.get((Object)Check.Type.METHOD_PARAMETER)) {
                Stats.of((String)c.getClass().getName()).start();
                c.visitMethodParameter(oldElement == null ? null : (VariableElement)((MethodParameterElement)oldElement).getModelElement(), newElement == null ? null : (VariableElement)((MethodParameterElement)newElement).getModelElement());
                Stats.of((String)c.getClass().getName()).end((Object)oldElement, (Object)newElement);
            }
        }
    }

    public Report endAnalysis(@Nullable Element oldElement, @Nullable Element newElement) {
        if (this.conforms(oldElement, newElement, AnnotationElement.class)) {
            return new Report(Collections.emptyList(), oldElement, newElement);
        }
        ArrayList<Difference> differences = new ArrayList<Difference>();
        for (Check c : this.checksByInterest.get((Object)this.checkTypeStack.pop())) {
            List<Difference> p = c.visitEnd();
            if (p == null) continue;
            differences.addAll(p);
        }
        if (this.lastAnnotationResults != null && !this.lastAnnotationResults.isEmpty()) {
            differences.addAll(this.lastAnnotationResults);
            this.lastAnnotationResults.clear();
        }
        if (!differences.isEmpty()) {
            LOG.trace("Detected following problems: {}", differences);
        }
        Timing.LOG.trace("Ended analysis of {} and {}.", (Object)oldElement, (Object)newElement);
        ListIterator<Difference> it = differences.listIterator();
        while (it.hasNext()) {
            Difference d = (Difference)it.next();
            if (this.analysisConfiguration.getUseReportingCodes().contains(d.code)) {
                StringBuilder newDesc = new StringBuilder(d.description == null ? "" : d.description);
                this.appendUses(oldElement, this.oldEnvironment, newDesc);
                this.appendUses(newElement, this.newEnvironment, newDesc);
                d = ((Difference.Builder)((Difference.Builder)((Difference.Builder)((Difference.Builder)((Difference.Builder)Difference.builder().addAttachments((Iterable)d.attachments)).addClassifications(d.classification)).withCode(d.code)).withName(d.name)).withDescription(newDesc.toString())).build();
            }
            it.set(d);
        }
        return new Report(differences, oldElement, newElement);
    }

    private <T> boolean conforms(Object a, Object b, Class<T> cls) {
        boolean ca = a == null || cls.isAssignableFrom(a.getClass());
        boolean cb = b == null || cls.isAssignableFrom(b.getClass());
        return ca && cb;
    }

    private void append(StringBuilder bld, TypeAndUseSite typeAndUseSite) {
        String message;
        switch (typeAndUseSite.useSite.getUseType()) {
            case ANNOTATES: {
                message = "revapi.java.uses.annotates";
                break;
            }
            case HAS_TYPE: {
                message = "revapi.java.uses.hasType";
                break;
            }
            case IS_IMPLEMENTED: {
                message = "revapi.java.uses.isImplemented";
                break;
            }
            case IS_INHERITED: {
                message = "revapi.java.uses.isInherited";
                break;
            }
            case IS_THROWN: {
                message = "revapi.java.uses.isThrown";
                break;
            }
            case PARAMETER_TYPE: {
                message = "revapi.java.uses.parameterType";
                break;
            }
            case RETURN_TYPE: {
                message = "revapi.java.uses.returnType";
                break;
            }
            case CONTAINS: {
                message = "revapi.java.uses.contains";
                break;
            }
            default: {
                throw new AssertionError((Object)"Invalid use type.");
            }
        }
        message = this.messages.getString(message);
        message = MessageFormat.format(message, typeAndUseSite.useSite.getSite().getFullHumanReadableString(), typeAndUseSite.type.getQualifiedName().toString());
        bld.append(message);
    }

    private void appendUses(Element element, final ProbingEnvironment environment, final StringBuilder bld) {
        if (element instanceof JavaTypeElement) {
            bld.append("\n");
            LOG.trace("Reporting uses of {}", (Object)element);
            javax.lang.model.element.TypeElement type = ((JavaTypeElement)element).getModelElement();
            environment.visitUseSites(type, new UseSite.Visitor<Void, Void>(){
                boolean first = true;

                @Override
                @Nullable
                public Void visit(@Nonnull javax.lang.model.element.TypeElement type, @Nonnull UseSite use, @Nullable Void parameter) {
                    if (this.first) {
                        JavaElementDifferenceAnalyzer.this.appendUse(bld, type, use, environment);
                        this.first = false;
                    } else {
                        bld.append(", ");
                        JavaElementDifferenceAnalyzer.this.appendUse(bld, type, use, environment);
                    }
                    return null;
                }

                @Override
                @Nullable
                public Void end(javax.lang.model.element.TypeElement type, @Nullable Void parameter) {
                    return null;
                }
            }, null);
        }
    }

    private void appendUse(StringBuilder bld, javax.lang.model.element.TypeElement type, UseSite use, ProbingEnvironment environment) {
        List<TypeAndUseSite> chain = this.getExamplePathToApiArchive(type, use, environment);
        Iterator<TypeAndUseSite> chainIt = chain.iterator();
        if (chain.isEmpty()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Could not find example path to API element for type {} starting with use {}", (Object)type.getQualifiedName().toString(), (Object)use);
            }
            return;
        }
        TypeAndUseSite last = null;
        if (chainIt.hasNext()) {
            last = chainIt.next();
            this.append(bld, last);
        }
        while (chainIt.hasNext()) {
            bld.append(" <- ");
            last = chainIt.next();
            this.append(bld, last);
        }
        String message = MessageFormat.format(this.messages.getString("revapi.java.uses.partOfApi"), last.useSite.getSite().getFullHumanReadableString());
        bld.append(" (").append(message).append(")");
    }

    private List<TypeAndUseSite> getExamplePathToApiArchive(javax.lang.model.element.TypeElement type, UseSite bottomUse, ProbingEnvironment environment) {
        ArrayList<TypeAndUseSite> ret = new ArrayList<TypeAndUseSite>();
        this.traverseToApi(type, bottomUse, ret, environment, new HashSet<javax.lang.model.element.TypeElement>());
        return ret;
    }

    private boolean traverseToApi(final javax.lang.model.element.TypeElement type, final UseSite currentUse, final List<TypeAndUseSite> path, final ProbingEnvironment environment, final Set<javax.lang.model.element.TypeElement> visitedTypes) {
        javax.lang.model.element.TypeElement useType = this.findClassOf(currentUse.getSite()).getModelElement();
        if (visitedTypes.contains(useType)) {
            return false;
        }
        visitedTypes.add(useType);
        API api = currentUse.getSite().getApi();
        Archive siteArchive = currentUse.getSite().getArchive();
        if (JavaElementDifferenceAnalyzer.contains(siteArchive, api.getArchives())) {
            path.add(0, new TypeAndUseSite(type, currentUse));
            return true;
        }
        Boolean ret = environment.visitUseSites(useType, new UseSite.Visitor<Boolean, Void>(){

            @Override
            @Nullable
            public Boolean visit(@Nonnull javax.lang.model.element.TypeElement visitedType, @Nonnull UseSite use, @Nullable Void parameter) {
                if (JavaElementDifferenceAnalyzer.this.traverseToApi(visitedType, use, path, environment, visitedTypes)) {
                    path.add(0, new TypeAndUseSite(type, currentUse));
                    return true;
                }
                return null;
            }

            @Override
            @Nullable
            public Boolean end(javax.lang.model.element.TypeElement type2, @Nullable Void parameter) {
                return null;
            }
        }, null);
        return ret == null ? false : ret;
    }

    private JavaTypeElement findClassOf(Element element) {
        while (element != null && !(element instanceof JavaTypeElement)) {
            element = element.getParent();
        }
        return (JavaTypeElement)element;
    }

    private static <T> boolean contains(T value, Iterable<? extends T> values) {
        Iterator<T> it = values.iterator();
        while (it.hasNext()) {
            if (!value.equals(it.next())) continue;
            return true;
        }
        return false;
    }

    private static void forceClearCompilerCache() {
        if (CLEAR_COMPILER_CACHE != null && SHARED_ZIP_FILE_INDEX_CACHE != null) {
            try {
                CLEAR_COMPILER_CACHE.invoke(SHARED_ZIP_FILE_INDEX_CACHE, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                LOG.warn("Failed to force-clear compiler caches, even though it should have been possible.This will probably leak memory", (Throwable)e);
            }
        }
    }

    static {
        Method clearCompilerCache = null;
        Object sharedInstance = null;
        try {
            Class<?> zipFileIndexCacheClass = ToolProvider.getSystemToolClassLoader().loadClass("com.sun.tools.javac.file.ZipFileIndexCache");
            clearCompilerCache = zipFileIndexCacheClass.getDeclaredMethod("clearCache", new Class[0]);
            Method getSharedInstance = zipFileIndexCacheClass.getDeclaredMethod("getSharedInstance", new Class[0]);
            sharedInstance = getSharedInstance.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            LOG.warn("Failed to initialize the force-clearing of javac file caches. We will probably leak resources.", (Throwable)e);
        }
        if (clearCompilerCache != null && sharedInstance != null) {
            CLEAR_COMPILER_CACHE = clearCompilerCache;
            SHARED_ZIP_FILE_INDEX_CACHE = sharedInstance;
        } else {
            CLEAR_COMPILER_CACHE = null;
            SHARED_ZIP_FILE_INDEX_CACHE = null;
        }
    }

    private static class TypeAndUseSite {
        final javax.lang.model.element.TypeElement type;
        final UseSite useSite;

        public TypeAndUseSite(javax.lang.model.element.TypeElement type, UseSite useSite) {
            this.type = type;
            this.useSite = useSite;
        }
    }
}

