/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.java.checks.generics;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.lang.model.AnnotatedConstruct;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Parameterizable;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import org.revapi.Difference;
import org.revapi.java.spi.Check;
import org.revapi.java.spi.CheckBase;
import org.revapi.java.spi.Code;
import org.revapi.java.spi.Util;

public final class FormalTypeParametersChanged
extends CheckBase {
    @Override
    public EnumSet<Check.Type> getInterest() {
        return EnumSet.of(Check.Type.CLASS, Check.Type.METHOD);
    }

    @Override
    protected void doVisitClass(@Nullable TypeElement oldType, @Nullable TypeElement newType) {
        this.doVisit(oldType, newType);
    }

    @Override
    protected void doVisitMethod(@Nullable ExecutableElement oldMethod, @Nullable ExecutableElement newMethod) {
        this.doVisit(oldMethod, newMethod);
    }

    private void doVisit(@Nullable Parameterizable oldElement, @Nullable Parameterizable newElement) {
        if (oldElement == null || newElement == null || !this.isBothAccessible(oldElement, this.getOldTypeEnvironment(), newElement, this.getNewTypeEnvironment())) {
            return;
        }
        List<? extends TypeParameterElement> oldPars = oldElement.getTypeParameters();
        List<? extends TypeParameterElement> newPars = newElement.getTypeParameters();
        if (oldPars.size() == 0 && oldPars.size() == newPars.size()) {
            return;
        }
        ArrayList<TypeParameterElement> added = new ArrayList<TypeParameterElement>();
        ArrayList<TypeParameterElement> removed = new ArrayList<TypeParameterElement>();
        LinkedHashMap<TypeParameterElement, TypeParameterElement> changed = new LinkedHashMap<TypeParameterElement, TypeParameterElement>();
        Iterator<? extends TypeParameterElement> oldIt = oldPars.iterator();
        Iterator<? extends TypeParameterElement> newIt = newPars.iterator();
        while (oldIt.hasNext() && newIt.hasNext()) {
            String newS;
            TypeParameterElement oldT = oldIt.next();
            TypeParameterElement newT = newIt.next();
            String oldS = Util.toUniqueString(oldT.asType());
            if (oldS.equals(newS = Util.toUniqueString(newT.asType()))) continue;
            changed.put(oldT, newT);
        }
        while (oldIt.hasNext()) {
            removed.add(oldIt.next());
        }
        while (newIt.hasNext()) {
            added.add(newIt.next());
        }
        if (!(added.isEmpty() && removed.isEmpty() && changed.isEmpty())) {
            this.pushActive(oldElement, newElement, added, removed, changed);
        }
    }

    @Override
    @Nullable
    protected List<Difference> doEnd() {
        CheckBase.ActiveElements els = this.popIfActive();
        if (els == null) {
            return null;
        }
        List added = (List)els.context[0];
        List removed = (List)els.context[1];
        Map changed = (Map)els.context[2];
        ArrayList<Difference> diffs = new ArrayList<Difference>();
        if (((Parameterizable)els.oldElement).getTypeParameters().isEmpty()) {
            diffs.add(this.createDifference(Code.GENERICS_ELEMENT_NOW_PARAMETERIZED, new Object[0]));
        }
        for (TypeParameterElement typeParameterElement : added) {
            diffs.add(this.createDifference(Code.GENERICS_FORMAL_TYPE_PARAMETER_ADDED, (Object[])new String[]{Util.toHumanReadableString(typeParameterElement)}, new Object[]{typeParameterElement}));
        }
        for (TypeParameterElement typeParameterElement : removed) {
            diffs.add(this.createDifference(Code.GENERICS_FORMAL_TYPE_PARAMETER_REMOVED, (Object[])new String[]{Util.toHumanReadableString(typeParameterElement)}, new Object[]{typeParameterElement}));
        }
        for (Map.Entry entry : changed.entrySet()) {
            diffs.add(this.createDifference(Code.GENERICS_FORMAL_TYPE_PARAMETER_CHANGED, (Object[])new String[]{Util.toHumanReadableString((AnnotatedConstruct)entry.getKey()), Util.toHumanReadableString((AnnotatedConstruct)entry.getValue())}, new Object[]{entry.getKey(), entry.getValue()}));
        }
        return diffs;
    }
}

