/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.java.checks.classes;

import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import javax.lang.model.element.TypeElement;
import org.revapi.Difference;
import org.revapi.java.spi.Check;
import org.revapi.java.spi.CheckBase;
import org.revapi.java.spi.Code;
import org.revapi.java.spi.JavaTypeElement;

public final class KindChanged
extends CheckBase {
    @Override
    public EnumSet<Check.Type> getInterest() {
        return EnumSet.of(Check.Type.CLASS);
    }

    @Override
    protected void doVisitClass(JavaTypeElement oldType, JavaTypeElement newType) {
        if (oldType != null && newType != null && oldType.getDeclaringElement().getKind() != newType.getDeclaringElement().getKind() && this.isBothAccessible(oldType, newType)) {
            this.pushActive(oldType, newType, new Object[0]);
        }
    }

    @Override
    protected List<Difference> doEnd() {
        CheckBase.ActiveElements types = this.popIfActive();
        if (types != null) {
            TypeElement o = ((JavaTypeElement)types.oldElement).getDeclaringElement();
            TypeElement n = ((JavaTypeElement)types.newElement).getDeclaringElement();
            if (o.getKind() != n.getKind()) {
                Difference p = this.createDifference(Code.CLASS_KIND_CHANGED, (Object[])new String[]{this.kind(o), this.kind(n)}, new Object[]{o, n});
                return Collections.singletonList(p);
            }
        }
        return null;
    }

    private String kind(TypeElement e) {
        switch (e.getKind()) {
            case CLASS: {
                return "class";
            }
            case INTERFACE: {
                return "interface";
            }
            case ANNOTATION_TYPE: {
                return "@interface";
            }
            case ENUM: {
                return "enum";
            }
        }
        return "unexpected (" + (Object)((Object)e.getKind()) + ")";
    }
}

