/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.java.checks.classes;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import javax.lang.model.type.TypeMirror;
import org.revapi.Difference;
import org.revapi.java.spi.Check;
import org.revapi.java.spi.CheckBase;
import org.revapi.java.spi.Code;
import org.revapi.java.spi.JavaTypeElement;
import org.revapi.java.spi.Util;

public final class NoLongerImplementsInterface
extends CheckBase {
    @Override
    public EnumSet<Check.Type> getInterest() {
        return EnumSet.of(Check.Type.CLASS);
    }

    @Override
    protected void doVisitClass(JavaTypeElement oldType, JavaTypeElement newType) {
        if (oldType == null || newType == null) {
            return;
        }
        List<TypeMirror> newInterfaces = Util.getAllSuperInterfaces(this.getNewTypeEnvironment().getTypeUtils(), newType.getModelRepresentation());
        List<TypeMirror> oldInterfaces = Util.getAllSuperInterfaces(this.getOldTypeEnvironment().getTypeUtils(), oldType.getModelRepresentation());
        for (TypeMirror oldIface : oldInterfaces) {
            if (Util.isSubtype(oldIface, newInterfaces, this.getOldTypeEnvironment().getTypeUtils())) continue;
            this.pushActive(oldType, newType, oldInterfaces, newInterfaces);
            break;
        }
    }

    @Override
    protected List<Difference> doEnd() {
        CheckBase.ActiveElements types = this.popIfActive();
        if (types == null) {
            return null;
        }
        ArrayList<Difference> result = new ArrayList<Difference>();
        List oldInterfaces = (List)types.context[0];
        List newInterfaces = (List)types.context[1];
        for (TypeMirror oldIface : oldInterfaces) {
            if (Util.isSubtype(oldIface, newInterfaces, this.getOldTypeEnvironment().getTypeUtils())) continue;
            result.add(this.createDifference(Code.CLASS_NO_LONGER_IMPLEMENTS_INTERFACE, (Object[])new String[]{Util.toHumanReadableString(oldIface)}, new Object[]{oldIface}));
        }
        return result;
    }
}

