/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.java.checks.methods;

import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.revapi.Difference;
import org.revapi.java.spi.Check;
import org.revapi.java.spi.CheckBase;
import org.revapi.java.spi.Code;
import org.revapi.java.spi.JavaMethodElement;
import org.revapi.java.spi.Util;

public final class ReturnTypeChanged
extends CheckBase {
    @Override
    public EnumSet<Check.Type> getInterest() {
        return EnumSet.of(Check.Type.METHOD);
    }

    @Override
    protected void doVisitMethod(@Nullable JavaMethodElement oldMethod, @Nullable JavaMethodElement newMethod) {
        String newRet;
        if (oldMethod == null || newMethod == null || this.isBothPrivate(oldMethod, newMethod)) {
            return;
        }
        String oldRet = Util.toUniqueString(oldMethod.getModelRepresentation().getReturnType());
        if (!oldRet.equals(newRet = Util.toUniqueString(newMethod.getModelRepresentation().getReturnType()))) {
            this.pushActive(oldMethod, newMethod, new Object[0]);
        }
    }

    @Override
    @Nullable
    protected List<Difference> doEnd() {
        CheckBase.ActiveElements methods = this.popIfActive();
        if (methods == null) {
            return null;
        }
        TypeMirror oldReturnType = ((JavaMethodElement)methods.oldElement).getModelRepresentation().getReturnType();
        TypeMirror newReturnType = ((JavaMethodElement)methods.newElement).getModelRepresentation().getReturnType();
        TypeMirror erasedOldType = this.getOldTypeEnvironment().getTypeUtils().erasure(oldReturnType);
        TypeMirror erasedNewType = this.getNewTypeEnvironment().getTypeUtils().erasure(newReturnType);
        String oldR = Util.toUniqueString(oldReturnType);
        String newR = Util.toUniqueString(newReturnType);
        String oldER = Util.toUniqueString(erasedOldType);
        String newER = Util.toUniqueString(erasedNewType);
        Code code = null;
        if (!oldER.equals(newER)) {
            code = ReturnTypeChanged.isPrimitiveOrVoid(erasedOldType) || ReturnTypeChanged.isPrimitiveOrVoid(erasedNewType) ? Code.METHOD_RETURN_TYPE_CHANGED : (this.isCovariant(erasedOldType, erasedNewType) ? Code.METHOD_RETURN_TYPE_CHANGED_COVARIANTLY : Code.METHOD_RETURN_TYPE_CHANGED);
        } else if (!oldR.equals(newR)) {
            code = Code.METHOD_RETURN_TYPE_TYPE_PARAMETERS_CHANGED;
        }
        String oldHR = Util.toHumanReadableString(oldReturnType);
        String newHR = Util.toHumanReadableString(newReturnType);
        return code == null ? null : Collections.singletonList(this.createDifference(code, oldHR, newHR));
    }

    private static boolean isPrimitiveOrVoid(TypeMirror type) {
        TypeKind kind = type.getKind();
        switch (kind) {
            case VOID: {
                return true;
            }
            case ARRAY: {
                return ReturnTypeChanged.isPrimitiveOrVoid(((ArrayType)type).getComponentType());
            }
        }
        return kind.isPrimitive();
    }

    private boolean isCovariant(TypeMirror superType, TypeMirror subType) {
        return Util.isSubtype(subType, Collections.singletonList(superType), this.getNewTypeEnvironment().getTypeUtils());
    }
}

