/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.java.compilation;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.URI;
import java.util.AbstractMap;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.IntersectionType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.TypeVisitor;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.SimpleTypeVisitor8;
import javax.lang.model.util.Types;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import org.revapi.Archive;
import org.revapi.java.AnalysisConfiguration;
import org.revapi.java.FlatFilter;
import org.revapi.java.compilation.ClassPathUseSite;
import org.revapi.java.compilation.InclusionFilter;
import org.revapi.java.compilation.ProbingEnvironment;
import org.revapi.java.model.AnnotationElement;
import org.revapi.java.model.JavaElementBase;
import org.revapi.java.model.JavaElementFactory;
import org.revapi.java.model.MethodElement;
import org.revapi.java.model.MissingClassElement;
import org.revapi.java.model.TypeElement;
import org.revapi.java.spi.IgnoreCompletionFailures;
import org.revapi.java.spi.JavaElement;
import org.revapi.java.spi.UseSite;
import org.revapi.java.spi.Util;
import org.revapi.query.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ClasspathScanner {
    private static final Logger LOG = LoggerFactory.getLogger(ClasspathScanner.class);
    private static final List<Modifier> ACCESSIBLE_MODIFIERS = Arrays.asList(Modifier.PUBLIC, Modifier.PROTECTED);
    private static final String SYSTEM_CLASSPATH_NAME = "<system classpath>";
    private final StandardJavaFileManager fileManager;
    private final ProbingEnvironment environment;
    private final Map<Archive, File> classPath;
    private final Map<Archive, File> additionalClassPath;
    private final AnalysisConfiguration.MissingClassReporting missingClassReporting;
    private final boolean ignoreMissingAnnotations;
    private final InclusionFilter inclusionFilter;
    private final boolean defaultInclusionCase;

    ClasspathScanner(StandardJavaFileManager fileManager, ProbingEnvironment environment, Map<Archive, File> classPath, Map<Archive, File> additionalClassPath, AnalysisConfiguration.MissingClassReporting missingClassReporting, boolean ignoreMissingAnnotations, InclusionFilter inclusionFilter) {
        this.fileManager = fileManager;
        this.environment = environment;
        this.classPath = classPath;
        this.additionalClassPath = additionalClassPath;
        this.missingClassReporting = missingClassReporting == null ? AnalysisConfiguration.MissingClassReporting.ERROR : missingClassReporting;
        this.ignoreMissingAnnotations = ignoreMissingAnnotations;
        this.inclusionFilter = inclusionFilter;
        this.defaultInclusionCase = inclusionFilter.defaultCase();
    }

    void initTree() throws IOException {
        List classPathLocations = this.classPath.keySet().stream().map(x$0 -> new ArchiveLocation((Archive)x$0)).collect(Collectors.toList());
        Scanner scanner = new Scanner();
        for (ArchiveLocation loc : classPathLocations) {
            scanner.scan(loc, this.classPath.get(loc.getArchive()), true);
        }
        Set<javax.lang.model.element.TypeElement> lastUnknowns = Collections.emptySet();
        HashMap<String, ArchiveLocation> cachedArchives = new HashMap<String, ArchiveLocation>(this.additionalClassPath.size());
        while (!scanner.requiredTypes.isEmpty() && !lastUnknowns.equals(scanner.requiredTypes.keySet())) {
            lastUnknowns = new HashSet<javax.lang.model.element.TypeElement>(scanner.requiredTypes.keySet());
            for (javax.lang.model.element.TypeElement t : lastUnknowns) {
                try {
                    String path;
                    URI uri;
                    Field f = t.getClass().getField("classfile");
                    JavaFileObject jfo = (JavaFileObject)f.get(t);
                    if (jfo == null) {
                        t = this.environment.getElementUtils().getTypeElement(t.getQualifiedName());
                        if (t == null) continue;
                        jfo = (JavaFileObject)f.get(t);
                    }
                    if ("jar".equals((uri = jfo.toUri()).getScheme())) {
                        uri = URI.create(uri.getSchemeSpecificPart());
                        path = uri.getPath().substring(0, uri.getPath().lastIndexOf(33));
                    } else {
                        path = uri.getPath();
                    }
                    ArchiveLocation loc = (ArchiveLocation)cachedArchives.get(path);
                    if (loc == null) {
                        Archive ar = null;
                        for (Map.Entry<Archive, File> e : this.additionalClassPath.entrySet()) {
                            if (!e.getValue().getAbsolutePath().equals(path)) continue;
                            ar = e.getKey();
                            break;
                        }
                        if (ar != null) {
                            loc = new ArchiveLocation(ar);
                            cachedArchives.put(path, loc);
                        }
                    }
                    if (loc == null) continue;
                    scanner.scanClass(loc, t, false);
                }
                catch (NoSuchFieldException f) {
                }
                catch (IllegalAccessException e) {
                    throw new AssertionError("Illegal access after setAccessible(true) on a field. Wha?", e);
                }
            }
        }
        HashMap<javax.lang.model.element.TypeElement, Boolean> rts = new HashMap<javax.lang.model.element.TypeElement, Boolean>(scanner.requiredTypes);
        ArchiveLocation systemClassPath = new ArchiveLocation(new Archive(){

            @Nonnull
            public String getName() {
                return ClasspathScanner.SYSTEM_CLASSPATH_NAME;
            }

            @Nonnull
            public InputStream openStream() throws IOException {
                throw new UnsupportedOperationException();
            }
        });
        for (Map.Entry e : rts.entrySet()) {
            if (((javax.lang.model.element.TypeElement)e.getKey()).asType().getKind() == TypeKind.ERROR) continue;
            scanner.scanClass(systemClassPath, (javax.lang.model.element.TypeElement)e.getKey(), false);
        }
        scanner.initEnvironment();
    }

    private static String getOverrideMapKey(ExecutableElement method) {
        return method.getSimpleName() + "#" + Util.toUniqueString(method.asType());
    }

    private static boolean movesToApi(UseSite.Type useType) {
        return useType.isMovingToApi();
    }

    static boolean shouldBeIgnored(Element element) {
        return Collections.disjoint(element.getModifiers(), ACCESSIBLE_MODIFIERS);
    }

    private static final class TypeRecord {
        Set<ClassPathUseSite> useSites = new HashSet<ClassPathUseSite>(2);
        javax.lang.model.element.TypeElement javacElement;
        TypeElement modelElement;
        Map<UseSite.Type, Set<TypeRecord>> usedTypes = new EnumMap<UseSite.Type, Set<TypeRecord>>(UseSite.Type.class);
        Set<Element> accessibleDeclaredNonClassMembers = new HashSet<Element>(4);
        Set<Element> inaccessibleDeclaredNonClassMembers = new HashSet<Element>(4);
        Set<TypeRecord> superTypes = new LinkedHashSet<TypeRecord>(2);
        boolean explicitlyExcluded;
        boolean explicitlyIncluded;
        boolean inApi;
        boolean inApiThroughUse;
        boolean primaryApi;
        int nestingDepth;

        private TypeRecord() {
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("TypeRecord[");
            sb.append("inApi=").append(this.inApi);
            sb.append(", modelElement=").append(this.modelElement);
            sb.append(']');
            return sb.toString();
        }
    }

    private static final class ArchiveLocation
    implements JavaFileManager.Location {
        private final Archive archive;

        private ArchiveLocation(Archive archive) {
            this.archive = archive;
        }

        Archive getArchive() {
            return this.archive;
        }

        @Override
        public String getName() {
            return "archiveLocation_" + this.archive.getName();
        }

        @Override
        public boolean isOutputLocation() {
            return false;
        }
    }

    private final class Scanner {
        final Set<javax.lang.model.element.TypeElement> processed = new HashSet<javax.lang.model.element.TypeElement>();
        final Map<javax.lang.model.element.TypeElement, Boolean> requiredTypes = new IdentityHashMap<javax.lang.model.element.TypeElement, Boolean>();
        final Map<javax.lang.model.element.TypeElement, TypeRecord> types = new IdentityHashMap<javax.lang.model.element.TypeElement, TypeRecord>();
        final TypeVisitor<javax.lang.model.element.TypeElement, Void> getTypeElement = new SimpleTypeVisitor8<javax.lang.model.element.TypeElement, Void>(){

            @Override
            protected javax.lang.model.element.TypeElement defaultAction(TypeMirror e, Void ignored) {
                throw new IllegalStateException("Could not determine the element of a type: " + e);
            }

            @Override
            public javax.lang.model.element.TypeElement visitDeclared(DeclaredType t, Void ignored) {
                return (javax.lang.model.element.TypeElement)t.asElement();
            }

            @Override
            public javax.lang.model.element.TypeElement visitTypeVariable(TypeVariable t, Void ignored) {
                return t.getUpperBound().accept(this, null);
            }

            @Override
            public javax.lang.model.element.TypeElement visitArray(ArrayType t, Void ignored) {
                return t.getComponentType().accept(this, null);
            }

            @Override
            public javax.lang.model.element.TypeElement visitPrimitive(PrimitiveType t, Void ignored) {
                return null;
            }

            @Override
            public javax.lang.model.element.TypeElement visitIntersection(IntersectionType t, Void aVoid) {
                return t.getBounds().get(0).accept(this, null);
            }

            @Override
            public javax.lang.model.element.TypeElement visitWildcard(WildcardType t, Void aVoid) {
                if (t.getExtendsBound() != null) {
                    return t.getExtendsBound().accept(this, null);
                }
                if (t.getSuperBound() != null) {
                    return t.getSuperBound().accept(this, null);
                }
                return ClasspathScanner.this.environment.getElementUtils().getTypeElement("java.lang.Object");
            }

            @Override
            public javax.lang.model.element.TypeElement visitNoType(NoType t, Void aVoid) {
                return null;
            }
        };

        private Scanner() {
        }

        void scan(ArchiveLocation location, File path, boolean primaryApi) throws IOException {
            ClasspathScanner.this.fileManager.setLocation(location, Collections.singleton(path));
            Iterable<JavaFileObject> jfos = ClasspathScanner.this.fileManager.list(location, "", EnumSet.of(JavaFileObject.Kind.CLASS), true);
            for (JavaFileObject jfo : jfos) {
                javax.lang.model.element.TypeElement type = Util.findTypeByBinaryName(ClasspathScanner.this.environment.getElementUtils(), ClasspathScanner.this.fileManager.inferBinaryName(location, jfo));
                if (type == null) continue;
                this.scanClass(location, type, primaryApi);
            }
        }

        void scanClass(ArchiveLocation loc, javax.lang.model.element.TypeElement type, boolean primaryApi) {
            try {
                if (this.processed.contains(type)) {
                    return;
                }
                this.processed.add(type);
                Boolean wasAnno = this.requiredTypes.remove(type);
                String bn = ClasspathScanner.this.environment.getElementUtils().getBinaryName(type).toString();
                String cn = type.getQualifiedName().toString();
                boolean includes = ClasspathScanner.this.inclusionFilter.accepts(bn, cn);
                boolean excludes = ClasspathScanner.this.inclusionFilter.rejects(bn, cn);
                javax.lang.model.element.TypeElement superType = this.getTypeElement.visit(IgnoreCompletionFailures.in(type::getSuperclass));
                TypeMirror typeType = type.asType();
                if (typeType.getKind() == TypeKind.ERROR) {
                    this.requiredTypes.put(type, wasAnno);
                    return;
                }
                TypeElement t = new TypeElement(ClasspathScanner.this.environment, loc.getArchive(), type, (DeclaredType)type.asType());
                TypeRecord tr = this.getTypeRecord(type);
                tr.modelElement = t;
                tr.inApi = !excludes && primaryApi && !ClasspathScanner.shouldBeIgnored(type) && !(type.getEnclosingElement() instanceof javax.lang.model.element.TypeElement);
                tr.primaryApi = primaryApi;
                tr.explicitlyExcluded = excludes;
                tr.explicitlyIncluded = includes;
                if (tr.explicitlyExcluded) {
                    return;
                }
                if (superType != null) {
                    this.addUse(tr, type, superType, UseSite.Type.IS_INHERITED);
                    tr.superTypes.add(this.getTypeRecord(superType));
                    if (!this.processed.contains(superType)) {
                        this.requiredTypes.put(superType, false);
                    }
                }
                IgnoreCompletionFailures.in(type::getInterfaces).stream().map(this.getTypeElement::visit).forEach(e -> {
                    if (!this.processed.contains(e)) {
                        this.requiredTypes.put((javax.lang.model.element.TypeElement)e, false);
                    }
                    this.addUse(tr, type, (javax.lang.model.element.TypeElement)e, UseSite.Type.IS_IMPLEMENTED);
                    tr.superTypes.add(this.getTypeRecord((javax.lang.model.element.TypeElement)e));
                });
                for (Element e2 : IgnoreCompletionFailures.in(type::getEnclosedElements)) {
                    switch (e2.getKind()) {
                        case ANNOTATION_TYPE: 
                        case CLASS: 
                        case ENUM: 
                        case INTERFACE: {
                            this.addUse(tr, type, (javax.lang.model.element.TypeElement)e2, UseSite.Type.CONTAINS);
                            this.scanClass(loc, (javax.lang.model.element.TypeElement)e2, tr.inApi);
                            break;
                        }
                        case CONSTRUCTOR: 
                        case METHOD: {
                            this.scanMethod(tr, (ExecutableElement)e2);
                            break;
                        }
                        case ENUM_CONSTANT: 
                        case FIELD: {
                            this.scanField(tr, (VariableElement)e2);
                        }
                    }
                }
                type.getAnnotationMirrors().forEach(a -> this.scanAnnotation(tr, type, (AnnotationMirror)a));
            }
            catch (Exception e3) {
                LOG.error("Failed to scan class " + type.getQualifiedName().toString() + ". Analysis results may be skewed.", (Throwable)e3);
            }
        }

        void placeInTree(TypeRecord typeRecord) {
            javax.lang.model.element.TypeElement type = (javax.lang.model.element.TypeElement)typeRecord.modelElement.getDeclaringElement();
            if (!(type.getEnclosingElement() instanceof javax.lang.model.element.TypeElement)) {
                ClasspathScanner.this.environment.getTree().getRootsUnsafe().add(typeRecord.modelElement);
            } else {
                TypeElement parent;
                ArrayDeque<String> nesting = new ArrayDeque<String>();
                type = (javax.lang.model.element.TypeElement)type.getEnclosingElement();
                while (type != null) {
                    nesting.push(type.getQualifiedName().toString());
                    type = type.getEnclosingElement() instanceof javax.lang.model.element.TypeElement ? (javax.lang.model.element.TypeElement)type.getEnclosingElement() : null;
                }
                Function<String, Filter> findByCN = cn -> FlatFilter.by(e -> cn.equals(e.getCanonicalName()));
                List<Object> parents = Collections.emptyList();
                while (parents.isEmpty() && !nesting.isEmpty()) {
                    parents = ClasspathScanner.this.environment.getTree().searchUnsafe(TypeElement.class, false, findByCN.apply((String)nesting.pop()), null);
                }
                TypeElement typeElement = parent = parents.isEmpty() ? null : (TypeElement)parents.get(0);
                while (!nesting.isEmpty()) {
                    String cn2 = (String)nesting.pop();
                    parents = ClasspathScanner.this.environment.getTree().searchUnsafe(TypeElement.class, false, findByCN.apply(cn2), parent);
                    if (parents.isEmpty()) {
                        while ((parents = ClasspathScanner.this.environment.getTree().searchUnsafe(TypeElement.class, false, findByCN.apply(cn2), null)).isEmpty() && !nesting.isEmpty()) {
                            cn2 = (String)nesting.pop();
                            if (!nesting.isEmpty()) continue;
                        }
                    }
                    parent = parents.isEmpty() ? null : (TypeElement)parents.get(0);
                }
                if (parent == null) {
                    ClasspathScanner.this.environment.getTree().getRootsUnsafe().add(typeRecord.modelElement);
                } else {
                    parent.getChildren().add(typeRecord.modelElement);
                }
            }
        }

        void scanField(TypeRecord owningType, VariableElement field) {
            if (ClasspathScanner.shouldBeIgnored(field)) {
                owningType.inaccessibleDeclaredNonClassMembers.add(field);
                return;
            }
            owningType.accessibleDeclaredNonClassMembers.add(field);
            javax.lang.model.element.TypeElement fieldType = field.asType().accept(this.getTypeElement, null);
            if (fieldType == null) {
                return;
            }
            this.addUse(owningType, field, fieldType, UseSite.Type.HAS_TYPE);
            this.addType(fieldType, false);
            field.getAnnotationMirrors().forEach(a -> this.scanAnnotation(owningType, field, (AnnotationMirror)a));
        }

        void scanMethod(TypeRecord owningType, ExecutableElement method) {
            if (ClasspathScanner.shouldBeIgnored(method)) {
                owningType.inaccessibleDeclaredNonClassMembers.add(method);
                return;
            }
            owningType.accessibleDeclaredNonClassMembers.add(method);
            javax.lang.model.element.TypeElement returnType = method.getReturnType().accept(this.getTypeElement, null);
            if (returnType != null) {
                this.addUse(owningType, method, returnType, UseSite.Type.RETURN_TYPE);
                this.addType(returnType, false);
            }
            int idx = 0;
            for (VariableElement variableElement : method.getParameters()) {
                javax.lang.model.element.TypeElement pt = variableElement.asType().accept(this.getTypeElement, null);
                if (pt != null) {
                    this.addUse(owningType, method, pt, UseSite.Type.PARAMETER_TYPE, idx++);
                    this.addType(pt, false);
                }
                variableElement.getAnnotationMirrors().forEach(a -> this.scanAnnotation(owningType, p, (AnnotationMirror)a));
            }
            method.getThrownTypes().forEach(t -> {
                javax.lang.model.element.TypeElement ex = t.accept(this.getTypeElement, null);
                if (ex != null) {
                    this.addUse(owningType, method, ex, UseSite.Type.IS_THROWN);
                    this.addType(ex, false);
                }
                t.getAnnotationMirrors().forEach(a -> this.scanAnnotation(owningType, method, (AnnotationMirror)a));
            });
            method.getAnnotationMirrors().forEach(a -> this.scanAnnotation(owningType, method, (AnnotationMirror)a));
        }

        void scanAnnotation(TypeRecord owningType, Element annotated, AnnotationMirror annotation) {
            javax.lang.model.element.TypeElement type = annotation.getAnnotationType().accept(this.getTypeElement, null);
            if (type != null) {
                this.addUse(owningType, annotated, type, UseSite.Type.ANNOTATES);
                this.addType(type, true);
            }
        }

        boolean addType(javax.lang.model.element.TypeElement type, boolean isAnnotation) {
            if (this.processed.contains(type)) {
                return true;
            }
            this.requiredTypes.put(type, isAnnotation);
            return false;
        }

        void addUse(TypeRecord userType, Element user, javax.lang.model.element.TypeElement used, UseSite.Type useType) {
            this.addUse(userType, user, used, useType, -1);
        }

        void addUse(TypeRecord userType, Element user, javax.lang.model.element.TypeElement used, UseSite.Type useType, int indexInParent) {
            TypeRecord usedTr = this.getTypeRecord(used);
            Set<ClassPathUseSite> sites = usedTr.useSites;
            sites.add(new ClassPathUseSite(useType, user, indexInParent));
            Set<TypeRecord> usedTypes = userType.usedTypes.get((Object)useType);
            if (usedTypes == null) {
                usedTypes = new HashSet<TypeRecord>(4);
                userType.usedTypes.put(useType, usedTypes);
            }
            usedTypes.add(usedTr);
        }

        TypeRecord getTypeRecord(javax.lang.model.element.TypeElement type) {
            TypeRecord rec = this.types.get(type);
            if (rec == null) {
                rec = new TypeRecord();
                rec.javacElement = type;
                int depth = 0;
                for (Element e = type.getEnclosingElement(); e != null && e instanceof javax.lang.model.element.TypeElement; e = e.getEnclosingElement()) {
                    ++depth;
                }
                rec.nestingDepth = depth;
                this.types.put(type, rec);
            }
            return rec;
        }

        void initEnvironment() {
            if (ClasspathScanner.this.ignoreMissingAnnotations && !this.requiredTypes.isEmpty()) {
                this.removeAnnotatesUses();
            }
            this.moveInnerClassesOfPrimariesToApi();
            this.determineApiStatus();
            this.initChildren();
            Set<TypeRecord> types = this.constructTree();
            if (!this.requiredTypes.isEmpty()) {
                this.handleMissingClasses(types);
            }
            ClasspathScanner.this.environment.setTypeMap(types.stream().collect(Collectors.toMap(tr -> tr.javacElement, tr -> tr.modelElement)));
        }

        private void handleMissingClasses(Set<TypeRecord> types) {
            Elements els = ClasspathScanner.this.environment.getElementUtils();
            switch (ClasspathScanner.this.missingClassReporting) {
                case ERROR: {
                    List reallyMissing = this.requiredTypes.keySet().stream().map(t -> els.getTypeElement(t.getQualifiedName())).filter(t -> els.getTypeElement(t.getQualifiedName()) == null).map(t -> t.getQualifiedName().toString()).sorted().collect(Collectors.toList());
                    if (reallyMissing.isEmpty()) break;
                    throw new IllegalStateException("The following classes that contribute to the public API of " + ClasspathScanner.this.environment.getApi() + " could not be located: " + reallyMissing);
                }
                case REPORT: {
                    for (javax.lang.model.element.TypeElement t2 : this.requiredTypes.keySet()) {
                        javax.lang.model.element.TypeElement type = els.getTypeElement(t2.getQualifiedName());
                        if (type != null) continue;
                        String bin = els.getBinaryName(t2).toString();
                        MissingClassElement mce = new MissingClassElement(ClasspathScanner.this.environment, bin, t2.getQualifiedName().toString());
                        TypeRecord tr = new TypeRecord();
                        tr.javacElement = mce.getDeclaringElement();
                        tr.modelElement = mce;
                        types.add(tr);
                        ClasspathScanner.this.environment.getTree().getRootsUnsafe().add(mce);
                    }
                    break;
                }
            }
        }

        private Set<TypeRecord> constructTree() {
            HashSet<TypeRecord> types = new HashSet<TypeRecord>();
            HashSet ignored = new HashSet();
            Comparator byNestingDepth = (a, b) -> {
                TypeRecord ar = (TypeRecord)a.getValue();
                TypeRecord br = (TypeRecord)b.getValue();
                int ret = ar.nestingDepth - br.nestingDepth;
                if (ret == 0) {
                    ret = ((javax.lang.model.element.TypeElement)a.getKey()).getQualifiedName().toString().compareTo(((javax.lang.model.element.TypeElement)b.getKey()).getQualifiedName().toString());
                }
                return ret;
            };
            this.types.entrySet().stream().sorted(byNestingDepth).forEach(e -> {
                javax.lang.model.element.TypeElement t = (javax.lang.model.element.TypeElement)e.getKey();
                TypeRecord r = (TypeRecord)e.getValue();
                if (r.modelElement != null && !r.modelElement.getArchive().getName().equals(ClasspathScanner.SYSTEM_CLASSPATH_NAME)) {
                    String cn = t.getQualifiedName().toString();
                    boolean includes = r.explicitlyIncluded;
                    boolean excludes = r.explicitlyExcluded;
                    if (includes) {
                        ClasspathScanner.this.environment.addExplicitInclusion(cn);
                    }
                    if (excludes) {
                        ClasspathScanner.this.environment.addExplicitExclusion(cn);
                        ignored.add(t);
                    } else {
                        boolean include = ClasspathScanner.this.defaultInclusionCase || includes;
                        Element owner = t.getEnclosingElement();
                        if (owner != null && owner instanceof javax.lang.model.element.TypeElement) {
                            ArrayDeque<javax.lang.model.element.TypeElement> owners = new ArrayDeque<javax.lang.model.element.TypeElement>();
                            while (owner != null && owner instanceof javax.lang.model.element.TypeElement) {
                                owners.push((javax.lang.model.element.TypeElement)owner);
                                owner = owner.getEnclosingElement();
                            }
                            List<Object> siblings = ClasspathScanner.this.environment.getTree().getRootsUnsafe().stream().map(JavaElementBase::getDeclaringElement).collect(Collectors.toList());
                            while (!(owners.isEmpty() || ignored.contains(owners.peek()) || siblings.contains(owners.peek()))) {
                                owners.pop();
                            }
                            if (!includes && !owners.isEmpty()) {
                                do {
                                    javax.lang.model.element.TypeElement o;
                                    include = !ignored.contains(o = (javax.lang.model.element.TypeElement)owners.pop()) && siblings.contains(o);
                                    siblings = ElementFilter.typesIn(o.getEnclosedElements());
                                } while (include && !owners.isEmpty());
                            }
                        }
                        if (include) {
                            this.placeInTree(r);
                            r.modelElement.setRawUseSites(r.useSites);
                            types.add(r);
                            r.modelElement.setInApi(r.inApi);
                            r.modelElement.setInApiThroughUse(r.inApiThroughUse);
                        }
                    }
                }
            });
            return types;
        }

        private void determineApiStatus() {
            Set<TypeRecord> undetermined = new HashSet<TypeRecord>(this.types.values());
            while (!undetermined.isEmpty()) {
                undetermined = undetermined.stream().filter(tr -> tr.modelElement != null && !tr.explicitlyExcluded).filter(tr -> tr.inApi).flatMap(tr -> tr.usedTypes.entrySet().stream().map(e -> new AbstractMap.SimpleImmutableEntry<TypeRecord, Map.Entry>((TypeRecord)tr, (Map.Entry)e))).filter(e -> ClasspathScanner.movesToApi((UseSite.Type)((Object)((Object)((Map.Entry)e.getValue()).getKey())))).flatMap(e -> ((Set)((Map.Entry)e.getValue()).getValue()).stream()).filter(usedTr -> usedTr.modelElement != null).filter(usedTr -> !usedTr.inApi).filter(usedTr -> !usedTr.explicitlyExcluded).map(usedTr -> {
                    usedTr.inApi = true;
                    usedTr.inApiThroughUse = true;
                    return usedTr;
                }).collect(Collectors.toSet());
            }
        }

        private void moveInnerClassesOfPrimariesToApi() {
            Set primaries = this.types.values().stream().filter(tr -> tr.primaryApi).filter(tr -> tr.inApi).filter(tr -> tr.nestingDepth == 0).collect(Collectors.toSet());
            while (!primaries.isEmpty()) {
                primaries = primaries.stream().flatMap(tr -> tr.usedTypes.getOrDefault((Object)UseSite.Type.CONTAINS, Collections.emptySet()).stream()).filter(containedTr -> containedTr.modelElement != null).filter(containedTr -> !ClasspathScanner.shouldBeIgnored(containedTr.modelElement.getDeclaringElement())).map(containedTr -> {
                    containedTr.inApi = true;
                    return containedTr;
                }).collect(Collectors.toSet());
            }
        }

        private void removeAnnotatesUses() {
            Map<javax.lang.model.element.TypeElement, Boolean> newTypes = this.requiredTypes.entrySet().stream().filter(e -> {
                boolean isAnno = (Boolean)e.getValue();
                if (isAnno) {
                    this.types.get(e.getKey()).useSites.clear();
                }
                return !isAnno;
            }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            this.requiredTypes.clear();
            this.requiredTypes.putAll(newTypes);
        }

        private void initChildren() {
            for (TypeRecord tr : this.types.values()) {
                if (tr.modelElement == null) continue;
                HashSet methods = new HashSet(8);
                Function<JavaElementBase, JavaElementBase> addOverride = e -> {
                    if (e instanceof MethodElement) {
                        MethodElement me = (MethodElement)e;
                        methods.add(ClasspathScanner.getOverrideMapKey((ExecutableElement)me.getDeclaringElement()));
                    }
                    return e;
                };
                Function<JavaElementBase, JavaElementBase> initChildren = e -> {
                    this.initNonClassElementChildrenAndMoveToApi(tr, (JavaElementBase<?, ?>)e, false);
                    return e;
                };
                tr.accessibleDeclaredNonClassMembers.stream().map(e -> JavaElementFactory.elementFor(e, e.asType(), ClasspathScanner.this.environment, tr.modelElement.getArchive())).map(addOverride).map(initChildren).forEach(c -> tr.modelElement.getChildren().add((JavaElement)c));
                tr.inaccessibleDeclaredNonClassMembers.stream().map(e -> JavaElementFactory.elementFor(e, e.asType(), ClasspathScanner.this.environment, tr.modelElement.getArchive())).map(addOverride).map(initChildren).forEach(c -> tr.modelElement.getChildren().add((JavaElement)c));
                tr.superTypes.forEach(str -> this.addInherited(tr, (TypeRecord)str, methods));
                for (AnnotationMirror annotationMirror : tr.javacElement.getAnnotationMirrors()) {
                    tr.modelElement.getChildren().add(new AnnotationElement(ClasspathScanner.this.environment, tr.modelElement.getArchive(), annotationMirror));
                }
            }
        }

        private void addInherited(TypeRecord target, TypeRecord superType, Set<String> methodOverrideMap) {
            Types types = ClasspathScanner.this.environment.getTypeUtils();
            superType.accessibleDeclaredNonClassMembers.stream().map(e -> {
                ExecutableElement me;
                if (e instanceof ExecutableElement && !this.shouldAddInheritedMethodChild(me = (ExecutableElement)e, methodOverrideMap)) {
                    return null;
                }
                TypeMirror elementType = types.asMemberOf((DeclaredType)target.javacElement.asType(), (Element)e);
                JavaElementBase<?, ?> element = JavaElementFactory.elementFor(e, elementType, ClasspathScanner.this.environment, superType.modelElement.getArchive());
                element.setInherited(true);
                this.initNonClassElementChildrenAndMoveToApi(target, element, true);
                return element;
            }).filter(e -> e != null).forEach(c -> target.modelElement.getChildren().add((JavaElement)c));
            for (TypeRecord st : superType.superTypes) {
                this.addInherited(target, st, methodOverrideMap);
            }
        }

        private boolean shouldAddInheritedMethodChild(ExecutableElement methodElement, Set<String> overrideMap) {
            if (methodElement.getKind() == ElementKind.CONSTRUCTOR) {
                return false;
            }
            String overrideKey = ClasspathScanner.getOverrideMapKey(methodElement);
            boolean alreadyIncludedMethod = overrideMap.contains(overrideKey);
            if (alreadyIncludedMethod) {
                return false;
            }
            overrideMap.add(overrideKey);
            return true;
        }

        private void initNonClassElementChildrenAndMoveToApi(TypeRecord targetType, JavaElementBase<?, ?> parent, boolean inherited) {
            Types types = ClasspathScanner.this.environment.getTypeUtils();
            if (targetType.inApi && !ClasspathScanner.shouldBeIgnored(parent.getDeclaringElement())) {
                TypeMirror representation = types.asMemberOf((DeclaredType)targetType.modelElement.getModelRepresentation(), (Element)parent.getDeclaringElement());
                representation.accept(new SimpleTypeVisitor8<Void, Void>(){

                    @Override
                    protected Void defaultAction(TypeMirror e, Void aVoid) {
                        TypeRecord tr;
                        if (e.getKind().isPrimitive() || e.getKind() == TypeKind.VOID) {
                            return null;
                        }
                        javax.lang.model.element.TypeElement childType = Scanner.this.getTypeElement.visit(e);
                        if (childType != null && (tr = Scanner.this.types.get(childType)) != null && tr.modelElement != null) {
                            if (!tr.inApi) {
                                tr.inApiThroughUse = true;
                            }
                            tr.inApi = true;
                        }
                        return null;
                    }

                    @Override
                    public Void visitExecutable(ExecutableType t, Void aVoid) {
                        t.getReturnType().accept(this, null);
                        t.getParameterTypes().forEach(p -> p.accept(this, null));
                        return null;
                    }
                }, null);
            }
            for (Element element : parent.getDeclaringElement().getEnclosedElements()) {
                if (element.getKind().isClass() || element.getKind().isInterface()) continue;
                TypeMirror representation = types.asMemberOf((DeclaredType)targetType.modelElement.getModelRepresentation(), element);
                JavaElementBase<?, ?> childEl = JavaElementFactory.elementFor(element, representation, ClasspathScanner.this.environment, parent.getArchive());
                childEl.setInherited(inherited);
                parent.getChildren().add(childEl);
                this.initNonClassElementChildrenAndMoveToApi(targetType, childEl, inherited);
            }
            for (AnnotationMirror annotationMirror : parent.getDeclaringElement().getAnnotationMirrors()) {
                parent.getChildren().add(new AnnotationElement(ClasspathScanner.this.environment, parent.getArchive(), annotationMirror));
            }
        }
    }
}

