/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.java.transforms.annotations;

import java.io.Reader;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.SimpleElementVisitor7;
import org.revapi.AnalysisContext;
import org.revapi.Difference;
import org.revapi.DifferenceTransform;
import org.revapi.java.model.AnnotationElement;
import org.revapi.java.spi.Code;
import org.revapi.java.spi.ElementPairVisitor;
import org.revapi.java.spi.JavaModelElement;

abstract class AbstractAnnotationPresenceCheck
implements DifferenceTransform<JavaModelElement> {
    protected AnalysisContext analysisContext;
    private final String annotationQualifiedName;
    private final Code transformedCode;
    private final Pattern[] codes;

    protected AbstractAnnotationPresenceCheck(String annotationQualifiedName, Code annotationCheckCode, Code transformedCode) {
        this.annotationQualifiedName = annotationQualifiedName;
        this.transformedCode = transformedCode;
        String regex = "^" + Pattern.quote(annotationCheckCode.code()) + "$";
        this.codes = new Pattern[]{Pattern.compile(regex)};
    }

    @Nonnull
    public Pattern[] getDifferenceCodePatterns() {
        return this.codes;
    }

    @Nullable
    public String[] getConfigurationRootPaths() {
        return null;
    }

    @Nullable
    public Reader getJSONSchema(@Nonnull String configurationRootPath) {
        return null;
    }

    public void initialize(@Nonnull AnalysisContext analysisContext) {
        this.analysisContext = analysisContext;
    }

    @Nullable
    public Difference transform(final @Nullable JavaModelElement oldElement, final @Nullable JavaModelElement newElement, final @Nonnull Difference difference) {
        if (oldElement == null || newElement == null) {
            return null;
        }
        AnnotationMirror affectedAnnotation = ((AnnotationElement)difference.attachments.get(0)).getAnnotation();
        return affectedAnnotation.getAnnotationType().asElement().accept(new SimpleElementVisitor7<Difference, Void>(){

            @Override
            protected Difference defaultAction(Element e, Void ignored) {
                return difference;
            }

            @Override
            public Difference visitType(TypeElement e, Void ignored) {
                if (!AbstractAnnotationPresenceCheck.this.annotationQualifiedName.equals(e.getQualifiedName().toString())) {
                    return difference;
                }
                return oldElement.getDeclaringElement().accept(new ElementPairVisitor<Difference>(){

                    @Override
                    protected Difference unmatchedAction(@Nonnull Element element, @Nullable Element otherElement) {
                        return difference;
                    }

                    @Override
                    protected Difference visitType(@Nonnull TypeElement oldElement, @Nonnull TypeElement newElement) {
                        return AbstractAnnotationPresenceCheck.this.transformedCode.createDifference(AbstractAnnotationPresenceCheck.this.analysisContext.getLocale());
                    }

                    @Override
                    protected Difference visitPackage(@Nonnull PackageElement element, @Nonnull PackageElement otherElement) {
                        return AbstractAnnotationPresenceCheck.this.transformedCode.createDifference(AbstractAnnotationPresenceCheck.this.analysisContext.getLocale());
                    }

                    @Override
                    protected Difference visitVariable(@Nonnull VariableElement element, @Nonnull VariableElement otherElement) {
                        return AbstractAnnotationPresenceCheck.this.transformedCode.createDifference(AbstractAnnotationPresenceCheck.this.analysisContext.getLocale());
                    }

                    @Override
                    protected Difference visitExecutable(@Nonnull ExecutableElement element, @Nonnull ExecutableElement otherElement) {
                        return AbstractAnnotationPresenceCheck.this.transformedCode.createDifference(AbstractAnnotationPresenceCheck.this.analysisContext.getLocale());
                    }
                }, newElement.getDeclaringElement());
            }
        }, null);
    }

    public void close() throws Exception {
    }
}

