/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.java.checks.generics;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.lang.model.AnnotatedConstruct;
import javax.lang.model.type.TypeMirror;
import org.revapi.Difference;
import org.revapi.java.spi.Check;
import org.revapi.java.spi.CheckBase;
import org.revapi.java.spi.Code;
import org.revapi.java.spi.JavaElement;
import org.revapi.java.spi.JavaModelElement;
import org.revapi.java.spi.JavaTypeElement;
import org.revapi.java.spi.Util;

public class SuperTypeParametersChanged
extends CheckBase {
    public EnumSet<Check.Type> getInterest() {
        return EnumSet.of(Check.Type.CLASS);
    }

    protected void doVisitClass(@Nullable JavaTypeElement oldType, @Nullable JavaTypeElement newType) {
        if (!this.isBothAccessible((JavaModelElement)oldType, (JavaModelElement)newType)) {
            return;
        }
        List<? extends TypeMirror> oldSuperTypes = this.getOldTypeEnvironment().getTypeUtils().directSupertypes(oldType.getModelRepresentation());
        List<? extends TypeMirror> newSuperTypes = this.getNewTypeEnvironment().getTypeUtils().directSupertypes(newType.getModelRepresentation());
        if (oldSuperTypes.size() != newSuperTypes.size()) {
            return;
        }
        LinkedHashMap<String, TypeMirror> erasedOld = new LinkedHashMap<String, TypeMirror>();
        LinkedHashMap<String, TypeMirror> erasedNew = new LinkedHashMap<String, TypeMirror>();
        for (TypeMirror typeMirror : oldSuperTypes) {
            erasedOld.put(Util.toUniqueString((TypeMirror)this.getOldTypeEnvironment().getTypeUtils().erasure(typeMirror)), typeMirror);
        }
        for (TypeMirror typeMirror : newSuperTypes) {
            erasedNew.put(Util.toUniqueString((TypeMirror)this.getNewTypeEnvironment().getTypeUtils().erasure(typeMirror)), typeMirror);
        }
        if (!erasedOld.keySet().equals(erasedNew.keySet())) {
            return;
        }
        LinkedHashMap<TypeMirror, TypeMirror> changed = new LinkedHashMap<TypeMirror, TypeMirror>();
        for (Map.Entry e : erasedOld.entrySet()) {
            String newS;
            TypeMirror oldT = (TypeMirror)e.getValue();
            TypeMirror newT = (TypeMirror)erasedNew.get(e.getKey());
            String oldS = Util.toUniqueString((TypeMirror)oldT);
            if (oldS.equals(newS = Util.toUniqueString((TypeMirror)newT))) continue;
            changed.put(oldT, newT);
        }
        if (!changed.isEmpty()) {
            this.pushActive((JavaElement)oldType, (JavaElement)newType, new Object[]{changed});
        }
    }

    @Nullable
    protected List<Difference> doEnd() {
        CheckBase.ActiveElements types = this.popIfActive();
        if (types == null) {
            return null;
        }
        Map changed = (Map)types.context[0];
        ArrayList<Difference> ret = new ArrayList<Difference>();
        for (Map.Entry e : changed.entrySet()) {
            ret.add(this.createDifference(Code.CLASS_SUPER_TYPE_TYPE_PARAMETERS_CHANGED, new String[]{Util.toHumanReadableString((AnnotatedConstruct)((AnnotatedConstruct)e.getKey())), Util.toHumanReadableString((AnnotatedConstruct)((AnnotatedConstruct)e.getValue()))}, new Object[]{e.getKey(), e.getValue()}));
        }
        return ret;
    }
}

