/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.java.checks.annotations;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import org.revapi.Difference;
import org.revapi.java.spi.Check;
import org.revapi.java.spi.CheckBase;
import org.revapi.java.spi.Code;
import org.revapi.java.spi.JavaAnnotationElement;
import org.revapi.java.spi.JavaElement;
import org.revapi.java.spi.Util;

public final class AttributeValueChanged
extends CheckBase {
    protected List<Difference> doVisitAnnotation(JavaAnnotationElement oldElement, JavaAnnotationElement newElement) {
        String name;
        if (oldElement == null || newElement == null) {
            return null;
        }
        AnnotationMirror oldAnnotation = oldElement.getAnnotation();
        AnnotationMirror newAnnotation = newElement.getAnnotation();
        ArrayList<Difference> result = new ArrayList<Difference>();
        Map oldAttrs = Util.keyAnnotationAttributesByName(oldAnnotation.getElementValues());
        Map newAttrs = Util.keyAnnotationAttributesByName(newAnnotation.getElementValues());
        for (Map.Entry oldE : oldAttrs.entrySet()) {
            name = (String)oldE.getKey();
            Map.Entry oldValue = (Map.Entry)oldE.getValue();
            Map.Entry newValue = (Map.Entry)newAttrs.get(name);
            if (newValue == null) {
                result.add(this.createDifference(Code.ANNOTATION_ATTRIBUTE_REMOVED, Code.attachmentsFor((JavaElement)oldElement, (JavaElement)newElement, (String[])new String[]{"attribute", name, "value", Util.toHumanReadableString((AnnotationValue)((AnnotationValue)oldValue.getValue()))})));
            } else if (!Util.isEqual((AnnotationValue)((AnnotationValue)oldValue.getValue()), (AnnotationValue)((AnnotationValue)newValue.getValue()))) {
                result.add(this.createDifference(Code.ANNOTATION_ATTRIBUTE_VALUE_CHANGED, Code.attachmentsFor((JavaElement)oldElement, (JavaElement)newElement, (String[])new String[]{"attribute", name, "oldValue", Util.toHumanReadableString((AnnotationValue)((AnnotationValue)oldValue.getValue())), "newValue", Util.toHumanReadableString((AnnotationValue)((AnnotationValue)newValue.getValue()))})));
            }
            newAttrs.remove(name);
        }
        for (Map.Entry newE : newAttrs.entrySet()) {
            name = (String)newE.getKey();
            Map.Entry newValue = (Map.Entry)newE.getValue();
            Map.Entry oldValue = (Map.Entry)oldAttrs.get(name);
            if (oldValue != null) continue;
            result.add(this.createDifference(Code.ANNOTATION_ATTRIBUTE_ADDED, Code.attachmentsFor((JavaElement)oldElement, (JavaElement)newElement, (String[])new String[]{"attribute", name, "value", Util.toHumanReadableString((AnnotationValue)((AnnotationValue)newValue.getValue()))})));
        }
        return result.isEmpty() ? null : result;
    }

    public EnumSet<Check.Type> getInterest() {
        return EnumSet.of(Check.Type.ANNOTATION);
    }
}

