/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.java.checks.classes;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import javax.lang.model.AnnotatedConstruct;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import org.revapi.Difference;
import org.revapi.java.spi.Check;
import org.revapi.java.spi.CheckBase;
import org.revapi.java.spi.Code;
import org.revapi.java.spi.JavaElement;
import org.revapi.java.spi.JavaTypeElement;
import org.revapi.java.spi.Util;

public final class NoLongerImplementsInterface
extends CheckBase {
    public EnumSet<Check.Type> getInterest() {
        return EnumSet.of(Check.Type.CLASS);
    }

    protected void doVisitClass(JavaTypeElement oldType, JavaTypeElement newType) {
        if (oldType == null || newType == null) {
            return;
        }
        List newInterfaces = Util.getAllSuperInterfaces((Types)this.getNewTypeEnvironment().getTypeUtils(), (TypeMirror)newType.getModelRepresentation());
        List oldInterfaces = Util.getAllSuperInterfaces((Types)this.getOldTypeEnvironment().getTypeUtils(), (TypeMirror)oldType.getModelRepresentation());
        for (TypeMirror oldIface : oldInterfaces) {
            if (Util.isSubtype((TypeMirror)oldIface, (List)newInterfaces, (Types)this.getOldTypeEnvironment().getTypeUtils())) continue;
            this.pushActive((JavaElement)oldType, (JavaElement)newType, new Object[]{oldInterfaces, newInterfaces});
            break;
        }
    }

    protected List<Difference> doEnd() {
        CheckBase.ActiveElements types = this.popIfActive();
        if (types == null) {
            return null;
        }
        ArrayList<Difference> result = new ArrayList<Difference>();
        List oldInterfaces = (List)types.context[0];
        List newInterfaces = (List)types.context[1];
        for (TypeMirror oldIface : oldInterfaces) {
            if (Util.isSubtype((TypeMirror)oldIface, (List)newInterfaces, (Types)this.getOldTypeEnvironment().getTypeUtils())) continue;
            result.add(this.createDifference(Code.CLASS_NO_LONGER_IMPLEMENTS_INTERFACE, Code.attachmentsFor((JavaElement)types.oldElement, (JavaElement)types.newElement, (String[])new String[]{"interface", Util.toHumanReadableString((AnnotatedConstruct)oldIface)})));
        }
        return result;
    }
}

