/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.java.checks.common;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import javax.lang.model.AnnotatedConstruct;
import javax.lang.model.type.TypeMirror;
import org.revapi.Difference;
import org.revapi.java.spi.CheckBase;
import org.revapi.java.spi.Code;
import org.revapi.java.spi.JavaElement;
import org.revapi.java.spi.JavaModelElement;
import org.revapi.java.spi.Util;

public abstract class MovedInHierarchy
extends CheckBase {
    private final Code moveUp;
    private final Code moveDown;

    protected MovedInHierarchy(Code moveUp, Code moveDown) {
        this.moveUp = moveUp;
        this.moveDown = moveDown;
    }

    protected void doVisit(@Nullable JavaModelElement oldEl, @Nullable JavaModelElement newEl) {
        String newType;
        if (oldEl == null || newEl == null) {
            return;
        }
        if (oldEl.isInherited() == newEl.isInherited()) {
            return;
        }
        if (!this.isBothAccessible(oldEl, newEl)) {
            return;
        }
        String oldType = Util.toUniqueString((TypeMirror)oldEl.getModelRepresentation());
        if (oldType.equals(newType = Util.toUniqueString((TypeMirror)newEl.getModelRepresentation()))) {
            this.pushActive((JavaElement)oldEl, (JavaElement)newEl, new Object[0]);
        }
    }

    @Nullable
    protected List<Difference> doEnd() {
        CheckBase.ActiveElements els = this.popIfActive();
        if (els == null) {
            return null;
        }
        String oldType = Util.toHumanReadableString((AnnotatedConstruct)((JavaModelElement)els.oldElement).getDeclaringElement().getEnclosingElement().asType());
        String newType = Util.toHumanReadableString((AnnotatedConstruct)((JavaModelElement)els.newElement).getDeclaringElement().getEnclosingElement().asType());
        Code code = ((JavaModelElement)els.oldElement).isInherited() ? this.moveDown : this.moveUp;
        return Collections.singletonList(this.createDifference(code, Code.attachmentsFor((JavaElement)els.oldElement, (JavaElement)els.newElement, (String[])new String[]{"oldClass", oldType, "newClass", newType})));
    }
}

