/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.java.checks.fields;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.SimpleTypeVisitor7;
import org.revapi.Difference;
import org.revapi.java.checks.fields.BothFieldsRequiringCheck;
import org.revapi.java.spi.Check;
import org.revapi.java.spi.CheckBase;
import org.revapi.java.spi.Code;
import org.revapi.java.spi.JavaElement;
import org.revapi.java.spi.JavaFieldElement;
import org.revapi.java.spi.TypeEnvironment;

public final class SerialVersionUidUnchanged
extends BothFieldsRequiringCheck {
    private static final String SERIAL_VERSION_UID_FIELD_NAME = "serialVersionUID";

    @Override
    public EnumSet<Check.Type> getInterest() {
        return EnumSet.of(Check.Type.FIELD);
    }

    protected void doVisitField(JavaFieldElement oldField, JavaFieldElement newField) {
        Long actualNewSUID;
        if (oldField == null || newField == null) {
            return;
        }
        if (!SERIAL_VERSION_UID_FIELD_NAME.equals(oldField.getDeclaringElement().getSimpleName().toString())) {
            return;
        }
        if (!SERIAL_VERSION_UID_FIELD_NAME.equals(newField.getDeclaringElement().getSimpleName().toString())) {
            return;
        }
        if (!this.isBothAccessible(oldField.getParent(), newField.getParent())) {
            return;
        }
        PrimitiveType oldLong = this.getOldTypeEnvironment().getTypeUtils().getPrimitiveType(TypeKind.LONG);
        if (!this.getOldTypeEnvironment().getTypeUtils().isSameType(oldField.getModelRepresentation(), oldLong)) {
            return;
        }
        PrimitiveType newLong = this.getNewTypeEnvironment().getTypeUtils().getPrimitiveType(TypeKind.LONG);
        if (!this.getNewTypeEnvironment().getTypeUtils().isSameType(newField.getModelRepresentation(), newLong)) {
            return;
        }
        if (!oldField.getDeclaringElement().getModifiers().contains((Object)Modifier.STATIC) || !oldField.getDeclaringElement().getModifiers().contains((Object)Modifier.FINAL)) {
            return;
        }
        if (!newField.getDeclaringElement().getModifiers().contains((Object)Modifier.STATIC) || !newField.getDeclaringElement().getModifiers().contains((Object)Modifier.FINAL)) {
            return;
        }
        TypeElement oldType = (TypeElement)oldField.getDeclaringElement().getEnclosingElement();
        TypeElement newType = (TypeElement)newField.getDeclaringElement().getEnclosingElement();
        long computedOldSUID = SerialVersionUidUnchanged.computeSerialVersionUID(oldType, this.getOldTypeEnvironment());
        long computedNewSUID = SerialVersionUidUnchanged.computeSerialVersionUID(newType, this.getNewTypeEnvironment());
        Long actualOldSUID = (Long)oldField.getDeclaringElement().getConstantValue();
        if (Objects.equals(actualOldSUID, actualNewSUID = (Long)newField.getDeclaringElement().getConstantValue()) && computedOldSUID != computedNewSUID) {
            this.pushActive((JavaElement)oldField, (JavaElement)newField, new Object[0]);
        }
    }

    protected List<Difference> doEnd() {
        CheckBase.ActiveElements fields = this.popIfActive();
        if (fields == null) {
            return null;
        }
        return Collections.singletonList(this.createDifference(Code.FIELD_SERIAL_VERSION_UID_UNCHANGED, Code.attachmentsFor((JavaElement)fields.oldElement, (JavaElement)fields.newElement, (String[])new String[0])));
    }

    public static long computeSerialVersionUID(TypeElement type, TypeEnvironment environment) {
        TypeElement javaIoSerializable = environment.getElementUtils().getTypeElement("java.io.Serializable");
        if (!environment.getTypeUtils().isAssignable(type.asType(), javaIoSerializable.asType())) {
            return 0L;
        }
        try {
            int i;
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            DataOutputStream dout = new DataOutputStream(bout);
            dout.writeUTF(type.getQualifiedName().toString());
            int classMods = SerialVersionUidUnchanged.asReflectiveModifiers(type, Modifier.PUBLIC, Modifier.FINAL, Modifier.ABSTRACT);
            if (type.getKind() == ElementKind.INTERFACE) {
                classMods |= 0x200;
            }
            if (type.getKind() == ElementKind.INTERFACE) {
                classMods = ElementFilter.methodsIn(type.getEnclosedElements()).size() > 0 ? (classMods |= 0x400) : (classMods &= 0xFFFFFBFF);
            }
            dout.writeInt(classMods);
            if (!(type.asType() instanceof ArrayType)) {
                List<? extends TypeMirror> interfaces = type.getInterfaces();
                Object[] ifaceNames = new String[interfaces.size()];
                for (i = 0; i < interfaces.size(); ++i) {
                    ifaceNames[i] = ((TypeElement)((DeclaredType)interfaces.get(i)).asElement()).getQualifiedName().toString();
                }
                Arrays.sort(ifaceNames);
                for (i = 0; i < ifaceNames.length; ++i) {
                    dout.writeUTF((String)ifaceNames[i]);
                }
            }
            List<VariableElement> fields = ElementFilter.fieldsIn(type.getEnclosedElements());
            MemberSignature[] fieldSigs = new MemberSignature[fields.size()];
            for (i = 0; i < fields.size(); ++i) {
                fieldSigs[i] = new MemberSignature(fields.get(i));
            }
            Arrays.sort(fieldSigs, new Comparator<MemberSignature>(){

                @Override
                public int compare(MemberSignature o1, MemberSignature o2) {
                    String name1 = o1.name;
                    String name2 = o2.name;
                    return name1.compareTo(name2);
                }
            });
            for (i = 0; i < fieldSigs.length; ++i) {
                MemberSignature sig = fieldSigs[i];
                int n = SerialVersionUidUnchanged.asReflectiveModifiers(sig.member, Modifier.PUBLIC, Modifier.PRIVATE, Modifier.PROTECTED, Modifier.STATIC, Modifier.FINAL, Modifier.VOLATILE, Modifier.TRANSIENT);
                if ((n & 2) != 0 && (n & 0x88) != 0) continue;
                dout.writeUTF(sig.name);
                dout.writeInt(n);
                dout.writeUTF(sig.signature);
            }
            boolean hasStaticInitializer = false;
            for (Element element : type.getEnclosedElements()) {
                if (element.getKind() != ElementKind.STATIC_INIT) continue;
                hasStaticInitializer = true;
                break;
            }
            if (hasStaticInitializer) {
                dout.writeUTF("<clinit>");
                dout.writeInt(8);
                dout.writeUTF("()V");
            }
            List<ExecutableElement> ctors = ElementFilter.constructorsIn(type.getEnclosedElements());
            MemberSignature[] memberSignatureArray = new MemberSignature[ctors.size()];
            int i2 = 0;
            for (ExecutableElement ctor : ctors) {
                memberSignatureArray[i2++] = new MemberSignature(ctor);
            }
            Arrays.sort(memberSignatureArray, new Comparator<MemberSignature>(){

                @Override
                public int compare(MemberSignature o1, MemberSignature o2) {
                    String sig1 = o1.signature;
                    String sig2 = o2.signature;
                    return sig1.compareTo(sig2);
                }
            });
            for (MemberSignature sig : memberSignatureArray) {
                int mods = SerialVersionUidUnchanged.asReflectiveModifiers(sig.member, Modifier.PUBLIC, Modifier.PRIVATE, Modifier.PROTECTED, Modifier.STATIC, Modifier.FINAL, Modifier.SYNCHRONIZED, Modifier.NATIVE, Modifier.ABSTRACT, Modifier.STRICTFP);
                if ((mods & 2) != 0) continue;
                dout.writeUTF("<init>");
                dout.writeInt(mods);
                dout.writeUTF(sig.signature.replace('/', '.'));
            }
            List<ExecutableElement> methods = ElementFilter.methodsIn(type.getEnclosedElements());
            MemberSignature[] methSigs = new MemberSignature[methods.size()];
            i2 = 0;
            for (ExecutableElement m : methods) {
                methSigs[i2++] = new MemberSignature(m);
            }
            Arrays.sort(methSigs, new Comparator<MemberSignature>(){

                @Override
                public int compare(MemberSignature ms1, MemberSignature ms2) {
                    int comp = ms1.name.compareTo(ms2.name);
                    if (comp == 0) {
                        comp = ms1.signature.compareTo(ms2.signature);
                    }
                    return comp;
                }
            });
            for (MemberSignature sig : methSigs) {
                int mods = SerialVersionUidUnchanged.asReflectiveModifiers(sig.member, Modifier.PUBLIC, Modifier.PRIVATE, Modifier.PROTECTED, Modifier.STATIC, Modifier.FINAL, Modifier.SYNCHRONIZED, Modifier.NATIVE, Modifier.ABSTRACT, Modifier.STRICTFP);
                if ((mods & 2) != 0) continue;
                dout.writeUTF(sig.name);
                dout.writeInt(mods);
                dout.writeUTF(sig.signature.replace('/', '.'));
            }
            dout.flush();
            MessageDigest md = MessageDigest.getInstance("SHA");
            byte[] hashBytes = md.digest(bout.toByteArray());
            long hash = 0L;
            for (i2 = Math.min(hashBytes.length, 8) - 1; i2 >= 0; --i2) {
                hash = hash << 8 | (long)(hashBytes[i2] & 0xFF);
            }
            return hash;
        }
        catch (IOException | NoSuchAlgorithmException ex) {
            throw new IllegalStateException("Could not compute default serialization UID for class: " + type.getQualifiedName().toString(), ex);
        }
    }

    private static int asReflectiveModifiers(Element el, Modifier ... applicableModifiers) {
        int mods = 0;
        block13: for (Modifier m : applicableModifiers) {
            if (!el.getModifiers().contains((Object)m)) continue;
            switch (m) {
                case ABSTRACT: {
                    mods |= 0x400;
                    continue block13;
                }
                case FINAL: {
                    mods |= 0x10;
                    continue block13;
                }
                case NATIVE: {
                    mods |= 0x100;
                    continue block13;
                }
                case PRIVATE: {
                    mods |= 2;
                    continue block13;
                }
                case PROTECTED: {
                    mods |= 4;
                    continue block13;
                }
                case PUBLIC: {
                    mods |= 1;
                    continue block13;
                }
                case STATIC: {
                    mods |= 8;
                    continue block13;
                }
                case STRICTFP: {
                    mods |= 0x800;
                    continue block13;
                }
                case SYNCHRONIZED: {
                    mods |= 0x20;
                    continue block13;
                }
                case TRANSIENT: {
                    mods |= 0x80;
                    continue block13;
                }
                case VOLATILE: {
                    mods |= 0x40;
                    continue block13;
                }
            }
        }
        return mods;
    }

    private static String getSignature(TypeMirror type) {
        StringBuilder sbuf = new StringBuilder();
        type.accept(new SimpleTypeVisitor7<Void, StringBuilder>(){

            @Override
            protected Void defaultAction(TypeMirror e, StringBuilder stringBuilder) {
                return null;
            }

            @Override
            public Void visitPrimitive(PrimitiveType t, StringBuilder stringBuilder) {
                switch (t.getKind()) {
                    case BOOLEAN: {
                        stringBuilder.append("Z");
                        break;
                    }
                    case BYTE: {
                        stringBuilder.append("B");
                        break;
                    }
                    case CHAR: {
                        stringBuilder.append("C");
                        break;
                    }
                    case DOUBLE: {
                        stringBuilder.append("D");
                        break;
                    }
                    case FLOAT: {
                        stringBuilder.append("F");
                        break;
                    }
                    case INT: {
                        stringBuilder.append("I");
                        break;
                    }
                    case LONG: {
                        stringBuilder.append("J");
                        break;
                    }
                    case SHORT: {
                        stringBuilder.append("S");
                        break;
                    }
                }
                return null;
            }

            @Override
            public Void visitArray(ArrayType t, StringBuilder stringBuilder) {
                stringBuilder.append("[");
                t.getComponentType().accept(this, stringBuilder);
                return null;
            }

            @Override
            public Void visitDeclared(DeclaredType t, StringBuilder stringBuilder) {
                stringBuilder.append("L");
                stringBuilder.append(((TypeElement)t.asElement()).getQualifiedName().toString().replace('.', '/'));
                stringBuilder.append(";");
                return null;
            }

            @Override
            public Void visitExecutable(ExecutableType t, StringBuilder stringBuilder) {
                stringBuilder.append("(");
                for (TypeMirror typeMirror : t.getParameterTypes()) {
                    typeMirror.accept(this, stringBuilder);
                }
                stringBuilder.append(")");
                t.getReturnType().accept(this, stringBuilder);
                return null;
            }

            @Override
            public Void visitNoType(NoType t, StringBuilder stringBuilder) {
                if (t.getKind() == TypeKind.VOID) {
                    stringBuilder.append("V");
                }
                return null;
            }
        }, sbuf);
        return sbuf.toString();
    }

    private static class MemberSignature {
        public final Element member;
        public final String name;
        public final String signature;

        public MemberSignature(VariableElement field) {
            this.member = field;
            this.name = field.getSimpleName().toString();
            this.signature = SerialVersionUidUnchanged.getSignature(field.asType());
        }

        public MemberSignature(ExecutableElement meth) {
            this.member = meth;
            this.name = meth.getSimpleName().toString();
            this.signature = SerialVersionUidUnchanged.getSignature(meth.asType());
        }
    }
}

