/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.java.checks.methods;

import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import org.revapi.Difference;
import org.revapi.java.spi.Check;
import org.revapi.java.spi.CheckBase;
import org.revapi.java.spi.Code;
import org.revapi.java.spi.JavaElement;
import org.revapi.java.spi.JavaMethodElement;
import org.revapi.java.spi.JavaModelElement;

public final class NumberOfParametersChanged
extends CheckBase {
    public EnumSet<Check.Type> getInterest() {
        return EnumSet.of(Check.Type.METHOD);
    }

    protected void doVisitMethod(@Nullable JavaMethodElement oldMethod, @Nullable JavaMethodElement newMethod) {
        if (oldMethod == null || newMethod == null || this.isBothPrivate((JavaModelElement)oldMethod, (JavaModelElement)newMethod)) {
            return;
        }
        if (oldMethod.getModelRepresentation().getParameterTypes().size() != newMethod.getModelRepresentation().getParameterTypes().size()) {
            this.pushActive((JavaElement)oldMethod, (JavaElement)newMethod, new Object[0]);
        }
    }

    @Nullable
    protected List<Difference> doEnd() {
        CheckBase.ActiveElements methods = this.popIfActive();
        if (methods == null) {
            return null;
        }
        return Collections.singletonList(this.createDifference(Code.METHOD_NUMBER_OF_PARAMETERS_CHANGED, Code.attachmentsFor((JavaElement)methods.oldElement, (JavaElement)methods.newElement, (String[])new String[0])));
    }
}

