/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.java.checks.methods;

import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import javax.lang.model.element.ElementKind;
import org.revapi.Difference;
import org.revapi.java.checks.common.ModifierChanged;
import org.revapi.java.spi.Check;
import org.revapi.java.spi.CheckBase;
import org.revapi.java.spi.Code;
import org.revapi.java.spi.JavaMethodElement;

public class NoLongerDefault
extends CheckBase {
    @Override
    public EnumSet<Check.Type> getInterest() {
        return EnumSet.of(Check.Type.METHOD);
    }

    @Override
    protected void doVisitMethod(@Nullable JavaMethodElement oldMethod, @Nullable JavaMethodElement newMethod) {
        boolean onInterfaces;
        if (!this.isBothAccessible(oldMethod, newMethod)) {
            return;
        }
        assert (oldMethod != null);
        assert (newMethod != null);
        boolean bl = onInterfaces = oldMethod.getParent().getDeclaringElement().getKind() == ElementKind.INTERFACE && newMethod.getParent().getDeclaringElement().getKind() == ElementKind.INTERFACE;
        if (onInterfaces && oldMethod.getDeclaringElement().isDefault() && !newMethod.getDeclaringElement().isDefault()) {
            this.pushActive(oldMethod, newMethod, new Object[0]);
        }
    }

    @Override
    @Nullable
    protected List<Difference> doEnd() {
        CheckBase.ActiveElements methods = this.popIfActive();
        if (methods == null) {
            return null;
        }
        return Collections.singletonList(this.createDifference(Code.METHOD_NO_LONGER_DEFAULT, Code.attachmentsFor(methods.oldElement, methods.newElement, new String[]{"oldModifiers", ModifierChanged.stringify(((JavaMethodElement)methods.oldElement).getDeclaringElement().getModifiers()), "newModifiers", ModifierChanged.stringify(((JavaMethodElement)methods.newElement).getDeclaringElement().getModifiers())})));
    }
}

