/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.java.checks.methods;

import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import org.revapi.Difference;
import org.revapi.java.spi.Check;
import org.revapi.java.spi.CheckBase;
import org.revapi.java.spi.Code;
import org.revapi.java.spi.JavaMethodElement;
import org.revapi.java.spi.JavaMethodParameterElement;
import org.revapi.java.spi.Util;

public final class ParameterTypeChanged
extends CheckBase {
    private boolean skip;

    @Override
    public EnumSet<Check.Type> getInterest() {
        return EnumSet.of(Check.Type.METHOD, Check.Type.METHOD_PARAMETER);
    }

    @Override
    protected void doVisitMethod(@Nullable JavaMethodElement oldMethod, @Nullable JavaMethodElement newMethod) {
        this.skip = oldMethod == null || newMethod == null || oldMethod.getModelRepresentation().getParameterTypes().size() != newMethod.getModelRepresentation().getParameterTypes().size();
    }

    @Override
    protected void doVisitMethodParameter(@Nullable JavaMethodParameterElement oldParameter, @Nullable JavaMethodParameterElement newParameter) {
        String newType;
        if (this.skip || oldParameter == null || newParameter == null) {
            return;
        }
        if (!this.isBothAccessible(oldParameter.getParent(), newParameter.getParent())) {
            return;
        }
        String oldType = Util.toUniqueString(oldParameter.getModelRepresentation());
        if (!oldType.equals(newType = Util.toUniqueString(newParameter.getModelRepresentation()))) {
            this.pushActive(oldParameter, newParameter, new Object[0]);
        }
    }

    @Override
    @Nullable
    protected List<Difference> doEnd() {
        String newErasedType;
        CheckBase.ActiveElements params = this.popIfActive();
        if (params == null) {
            return null;
        }
        String oldType = Util.toHumanReadableString(((JavaMethodParameterElement)params.oldElement).getModelRepresentation());
        String newType = Util.toHumanReadableString(((JavaMethodParameterElement)params.newElement).getModelRepresentation());
        String oldErasedType = Util.toUniqueString(((JavaMethodParameterElement)params.oldElement).getTypeEnvironment().getTypeUtils().erasure(((JavaMethodParameterElement)params.oldElement).getModelRepresentation()));
        if (!oldErasedType.equals(newErasedType = Util.toUniqueString(((JavaMethodParameterElement)params.newElement).getTypeEnvironment().getTypeUtils().erasure(((JavaMethodParameterElement)params.newElement).getModelRepresentation())))) {
            return Collections.singletonList(this.createDifference(Code.METHOD_PARAMETER_TYPE_CHANGED, Code.attachmentsFor(params.oldElement, params.newElement, new String[]{"oldType", oldType, "newType", newType})));
        }
        return Collections.singletonList(this.createDifference(Code.METHOD_PARAMETER_TYPE_PARAMETER_CHANGED, Code.attachmentsFor(params.oldElement, params.newElement, new String[]{"oldType", oldType, "newType", newType})));
    }
}

