/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.java.checks.fields;

import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.revapi.Difference;
import org.revapi.java.spi.Check;
import org.revapi.java.spi.CheckBase;
import org.revapi.java.spi.Code;
import org.revapi.java.spi.JavaFieldElement;
import org.revapi.java.spi.Util;

public final class TypeChanged
extends CheckBase {
    @Override
    public EnumSet<Check.Type> getInterest() {
        return EnumSet.of(Check.Type.FIELD);
    }

    @Override
    protected void doVisitField(JavaFieldElement oldField, JavaFieldElement newField) {
        String newType;
        if (!this.isBothAccessible(oldField, newField)) {
            return;
        }
        String oldType = Util.toUniqueString(oldField.getTypeEnvironment().getTypeUtils().erasure(oldField.getModelRepresentation()));
        if (!oldType.equals(newType = Util.toUniqueString(newField.getTypeEnvironment().getTypeUtils().erasure(newField.getModelRepresentation())))) {
            this.pushActive(oldField, newField, new Object[0]);
        }
    }

    @Override
    protected List<Difference> doEnd() {
        CheckBase.ActiveElements fields = this.popIfActive();
        if (fields == null) {
            return null;
        }
        String oldType = Util.toHumanReadableString(((JavaFieldElement)fields.oldElement).getModelRepresentation());
        String newType = Util.toHumanReadableString(((JavaFieldElement)fields.newElement).getModelRepresentation());
        return Collections.singletonList(this.createDifference(Code.FIELD_TYPE_CHANGED, Code.attachmentsFor((JavaFieldElement)fields.oldElement, (JavaFieldElement)fields.newElement, "oldType", oldType, "newType", newType)));
    }
}

