/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.java;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jboss.dmr.ModelNode;

public final class AnalysisConfiguration {
    private final MissingClassReporting missingClassReporting;
    private final Set<String> useReportingCodes;
    private final boolean ignoreMissingAnnotations;
    private final Set<Pattern> classInclusionFilters;
    private final Set<Pattern> classExclusionFilters;
    private final Set<Pattern> packageInclusionFilters;
    private final Set<Pattern> packageExclusionFilters;

    public AnalysisConfiguration(MissingClassReporting missingClassReporting, Set<String> useReportingCodes, boolean ignoreMissingAnnotations, Set<Pattern> classInclusionFilters, Set<Pattern> classExclusionFilters, Set<Pattern> packageInclusionFilters, Set<Pattern> packageExclusionFilters) {
        this.missingClassReporting = missingClassReporting;
        this.useReportingCodes = useReportingCodes;
        this.ignoreMissingAnnotations = ignoreMissingAnnotations;
        this.classInclusionFilters = classInclusionFilters;
        this.classExclusionFilters = classExclusionFilters;
        this.packageInclusionFilters = packageInclusionFilters;
        this.packageExclusionFilters = packageExclusionFilters;
    }

    public static AnalysisConfiguration fromModel(ModelNode node) {
        MissingClassReporting reporting = AnalysisConfiguration.readMissingClassReporting(node);
        Set<String> useReportingCodes = AnalysisConfiguration.readUseReportingCodes(node);
        boolean ignoreMissingAnnotations = AnalysisConfiguration.readIgnoreMissingAnnotations(node);
        ModelNode classesRegex = node.get("filter", "classes", "regex");
        ModelNode packagesRegex = node.get("filter", "packages", "regex");
        Set<Pattern> classInclusionFilters = AnalysisConfiguration.readFilter(node.get("filter", "classes", "include"), classesRegex);
        Set<Pattern> classExclusionFilters = AnalysisConfiguration.readFilter(node.get("filter", "classes", "exclude"), classesRegex);
        Set<Pattern> packageInclusionFilters = AnalysisConfiguration.readFilter(node.get("filter", "packages", "include"), packagesRegex);
        Set<Pattern> packageExclusionFilters = AnalysisConfiguration.readFilter(node.get("filter", "packages", "exclude"), packagesRegex);
        return new AnalysisConfiguration(reporting, useReportingCodes, ignoreMissingAnnotations, classInclusionFilters, classExclusionFilters, packageInclusionFilters, packageExclusionFilters);
    }

    public MissingClassReporting getMissingClassReporting() {
        return this.missingClassReporting;
    }

    public boolean reportUseForAllDifferences() {
        return this.useReportingCodes == null;
    }

    public Set<String> getUseReportingCodes() {
        return this.useReportingCodes == null ? Collections.emptySet() : this.useReportingCodes;
    }

    public boolean isIgnoreMissingAnnotations() {
        return this.ignoreMissingAnnotations;
    }

    public Set<Pattern> getClassExclusionFilters() {
        return this.classExclusionFilters;
    }

    public Set<Pattern> getClassInclusionFilters() {
        return this.classInclusionFilters;
    }

    public Set<Pattern> getPackageExclusionFilters() {
        return this.packageExclusionFilters;
    }

    public Set<Pattern> getPackageInclusionFilters() {
        return this.packageInclusionFilters;
    }

    private static MissingClassReporting readMissingClassReporting(ModelNode analysisConfig) {
        ModelNode config = analysisConfig.get("missing-classes", "behavior");
        if (config.isDefined()) {
            switch (config.asString()) {
                case "report": {
                    return MissingClassReporting.REPORT;
                }
                case "ignore": {
                    return MissingClassReporting.IGNORE;
                }
                case "error": {
                    return MissingClassReporting.ERROR;
                }
            }
            throw new IllegalArgumentException("Unsupported value of revapi.java.missing-classes.behavior: '" + config.asString() + "'. Only 'report', 'ignore' and 'error' are recognized.");
        }
        return MissingClassReporting.REPORT;
    }

    private static boolean readIgnoreMissingAnnotations(ModelNode analysisConfig) {
        ModelNode config = analysisConfig.get("missing-classes", "ignoreMissingAnnotations");
        if (config.isDefined()) {
            return config.asBoolean();
        }
        return false;
    }

    private static Set<String> readUseReportingCodes(ModelNode analysisConfig) {
        HashSet<String> ret;
        block6: {
            block5: {
                ret = new HashSet<String>(5);
                ModelNode config = analysisConfig.get("reportUsesFor");
                if (!config.isDefined()) break block5;
                switch (config.getType()) {
                    case LIST: {
                        for (ModelNode code : config.asList()) {
                            ret.add(code.asString());
                        }
                        break block6;
                    }
                    case STRING: {
                        if (!"all-differences".equals(config.asString())) break;
                        ret = null;
                    }
                }
                break block6;
            }
            ret.add("java.missing.oldClass");
            ret.add("java.missing.newClass");
            ret.add("java.class.nonPublicPartOfAPI");
            ret.add("java.class.externalClassExposedInAPI");
            ret.add("java.class.externalClassNoLongerExposedInAPI");
        }
        return ret;
    }

    private static Set<Pattern> readFilter(ModelNode filterNode, ModelNode regexNode) {
        if (!filterNode.isDefined()) {
            return Collections.emptySet();
        }
        boolean isRegex = regexNode.isDefined() && regexNode.asBoolean();
        return filterNode.asList().stream().map(filter -> {
            if (isRegex) {
                return Pattern.compile(filter.asString());
            }
            return Pattern.compile(Pattern.quote(filter.asString()));
        }).collect(Collectors.toSet());
    }

    public static enum MissingClassReporting {
        IGNORE,
        ERROR,
        REPORT;

    }
}

