/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.java.checks.fields;

import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import org.revapi.Difference;
import org.revapi.java.spi.Check;
import org.revapi.java.spi.CheckBase;
import org.revapi.java.spi.Code;
import org.revapi.java.spi.JavaFieldElement;

public final class NowConstant
extends CheckBase {
    @Override
    public EnumSet<Check.Type> getInterest() {
        return EnumSet.of(Check.Type.FIELD);
    }

    @Override
    protected void doVisitField(JavaFieldElement oldField, JavaFieldElement newField) {
        if (!this.isBothAccessible(oldField, newField)) {
            return;
        }
        if (oldField.getDeclaringElement().getConstantValue() == null && newField.getDeclaringElement().getConstantValue() != null) {
            this.pushActive(oldField, newField, new Object[0]);
        }
    }

    @Override
    protected List<Difference> doEnd() {
        CheckBase.ActiveElements fields = this.popIfActive();
        if (fields == null) {
            return null;
        }
        return Collections.singletonList(this.createDifference(Code.FIELD_NOW_CONSTANT, Code.attachmentsFor(fields.oldElement, fields.newElement, new String[]{"value", Objects.toString(((JavaFieldElement)fields.newElement).getDeclaringElement().getConstantValue())})));
    }
}

