/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.java.checks.classes;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import javax.lang.model.type.TypeMirror;
import org.revapi.Difference;
import org.revapi.java.spi.Check;
import org.revapi.java.spi.CheckBase;
import org.revapi.java.spi.Code;
import org.revapi.java.spi.JavaTypeElement;
import org.revapi.java.spi.Util;

public final class NowImplementsInterface
extends CheckBase {
    @Override
    public EnumSet<Check.Type> getInterest() {
        return EnumSet.of(Check.Type.CLASS);
    }

    @Override
    protected void doVisitClass(JavaTypeElement oldType, JavaTypeElement newType) {
        if (!this.isBothAccessible(oldType, newType)) {
            return;
        }
        List<? extends TypeMirror> newInterfaces = newType.getDeclaringElement().getInterfaces();
        List<? extends TypeMirror> oldInterfaces = oldType.getDeclaringElement().getInterfaces();
        for (TypeMirror typeMirror : newInterfaces) {
            if (Util.isSubtype(typeMirror, oldInterfaces, this.getNewTypeEnvironment().getTypeUtils())) continue;
            this.pushActive(oldType, newType, new Object[0]);
            break;
        }
    }

    @Override
    protected List<Difference> doEnd() {
        CheckBase.ActiveElements types = this.popIfActive();
        if (types == null) {
            return null;
        }
        ArrayList<Difference> result = new ArrayList<Difference>();
        List<? extends TypeMirror> newInterfaces = ((JavaTypeElement)types.newElement).getDeclaringElement().getInterfaces();
        List<? extends TypeMirror> oldInterfaces = ((JavaTypeElement)types.oldElement).getDeclaringElement().getInterfaces();
        for (TypeMirror typeMirror : newInterfaces) {
            if (Util.isSubtype(typeMirror, oldInterfaces, this.getNewTypeEnvironment().getTypeUtils())) continue;
            result.add(this.createDifference(Code.CLASS_NOW_IMPLEMENTS_INTERFACE, Code.attachmentsFor(types.oldElement, types.newElement, new String[]{"interface", Util.toHumanReadableString(typeMirror)})));
        }
        return result;
    }
}

