/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.java.matcher;

import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.revapi.AnalysisContext;
import org.revapi.ArchiveAnalyzer;
import org.revapi.Element;
import org.revapi.ElementMatcher;
import org.revapi.FilterFinishResult;
import org.revapi.FilterMatch;
import org.revapi.FilterStartResult;
import org.revapi.TreeFilter;
import org.revapi.classif.ModelInspector;
import org.revapi.classif.StructuralMatcher;
import org.revapi.classif.TestResult;
import org.revapi.classif.dsl.ClassifDSL;
import org.revapi.classif.progress.MatchingProgress;
import org.revapi.classif.progress.WalkInstruction;
import org.revapi.java.JavaArchiveAnalyzer;
import org.revapi.java.compilation.ProbingEnvironment;
import org.revapi.java.model.JavaElementFactory;
import org.revapi.java.spi.JavaElement;
import org.revapi.java.spi.JavaModelElement;
import org.revapi.java.spi.JavaTypeElement;
import org.revapi.java.spi.UseSite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JavaElementMatcher
implements ElementMatcher {
    private static final Logger LOG = LoggerFactory.getLogger(JavaElementMatcher.class);

    public Optional<ElementMatcher.CompiledRecipe> compile(String recipe) {
        try {
            final StructuralMatcher matcher = ClassifDSL.compile((String)recipe);
            ElementMatcher.CompiledRecipe ret = new ElementMatcher.CompiledRecipe(){

                @Nullable
                public <E extends Element<E>> TreeFilter<E> filterFor(ArchiveAnalyzer<E> archiveAnalyzer) {
                    if (!(archiveAnalyzer instanceof JavaArchiveAnalyzer)) {
                        return null;
                    }
                    final MatchingProgress progress = matcher.with((ModelInspector)new ElementInspector((JavaArchiveAnalyzer)archiveAnalyzer));
                    TreeFilter<JavaElement> ret = new TreeFilter<JavaElement>(){

                        public FilterStartResult start(JavaElement element) {
                            if (!(element instanceof JavaModelElement)) {
                                return FilterStartResult.doesntMatch();
                            }
                            return JavaElementMatcher.convert(progress.start((Object)element));
                        }

                        public FilterFinishResult finish(JavaElement element) {
                            if (!(element instanceof JavaModelElement)) {
                                return FilterFinishResult.doesntMatch();
                            }
                            return FilterFinishResult.direct((FilterMatch)JavaElementMatcher.convert(progress.finish((Object)element)));
                        }

                        public Map<JavaElement, FilterFinishResult> finish() {
                            return progress.finish().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> FilterFinishResult.direct((FilterMatch)JavaElementMatcher.convert((TestResult)e.getValue()))));
                        }
                    };
                    return ret;
                }
            };
            return Optional.of(ret);
        }
        catch (IllegalArgumentException e) {
            return Optional.empty();
        }
    }

    public void close() throws Exception {
    }

    public String getExtensionId() {
        return "java";
    }

    @Nullable
    public Reader getJSONSchema() {
        return null;
    }

    public void initialize(@Nonnull AnalysisContext analysisContext) {
    }

    private static FilterStartResult convert(WalkInstruction instruction) {
        return FilterStartResult.direct((FilterMatch)JavaElementMatcher.convert(instruction.getTestResult()), (boolean)instruction.isDescend());
    }

    private static FilterMatch convert(TestResult result) {
        switch (result) {
            case DEFERRED: {
                return FilterMatch.UNDECIDED;
            }
            case PASSED: {
                return FilterMatch.MATCHES;
            }
            case NOT_PASSED: {
                return FilterMatch.DOESNT_MATCH;
            }
        }
        throw new IllegalArgumentException(result + " not handled.");
    }

    private static JavaModelElement toJava(JavaElement element) {
        if (!(element instanceof JavaModelElement)) {
            throw new IllegalArgumentException("Only instances of JavaModelElement can be processed by matcher.java");
        }
        return (JavaModelElement)element;
    }

    private static final class ElementInspector
    implements ModelInspector<JavaElement> {
        private Elements elements;
        private Types types;
        private TypeElement javaLangObject;
        final ProbingEnvironment env;

        ElementInspector(JavaArchiveAnalyzer analyzer) {
            this.env = analyzer.getProbingEnvironment();
        }

        public TypeElement getJavaLangObjectElement() {
            return this.getJavaLangObject();
        }

        public javax.lang.model.element.Element toElement(JavaElement element) {
            return JavaElementMatcher.toJava(element).getDeclaringElement();
        }

        public TypeMirror toMirror(JavaElement element) {
            return JavaElementMatcher.toJava(element).getModelRepresentation();
        }

        public Set<JavaElement> getUses(JavaElement element) {
            if (!this.env.isScanningComplete()) {
                return null;
            }
            if (element instanceof JavaModelElement) {
                JavaModelElement user = (JavaModelElement)element;
                while (element != null && !(element instanceof JavaTypeElement)) {
                    element = (JavaElement)element.getParent();
                }
                if (element == null) {
                    return Collections.emptySet();
                }
                JavaTypeElement type = (JavaTypeElement)element;
                Map usedTypes = type.getUsedTypes();
                return usedTypes.values().stream().flatMap(m -> m.entrySet().stream()).filter(e -> ((Set)e.getValue()).contains(user)).map(Map.Entry::getKey).collect(Collectors.toSet());
            }
            return Collections.emptySet();
        }

        public Set<JavaElement> getUseSites(JavaElement element) {
            if (!this.env.isScanningComplete()) {
                return null;
            }
            if (element instanceof JavaTypeElement) {
                return ((JavaTypeElement)element).getUseSites().stream().map(UseSite::getSite).collect(Collectors.toSet());
            }
            return Collections.emptySet();
        }

        public JavaElement fromElement(javax.lang.model.element.Element element) {
            javax.lang.model.element.Element current;
            if (!this.env.isScanningComplete()) {
                return JavaElementFactory.elementFor(element, element.asType(), this.env, null);
            }
            ArrayList<javax.lang.model.element.Element> path = new ArrayList<javax.lang.model.element.Element>(3);
            for (current = element; current != null && !(current instanceof TypeElement); current = current.getEnclosingElement()) {
                path.add(current);
            }
            TypeElement type = (TypeElement)current;
            JavaModelElement model = this.env.getTypeMap().get(type);
            ListIterator it = path.listIterator(path.size());
            while (it.hasPrevious()) {
                javax.lang.model.element.Element child = (javax.lang.model.element.Element)it.previous();
                boolean found = false;
                for (Element e : model.getChildren()) {
                    JavaModelElement m;
                    if (!(e instanceof JavaModelElement) || (m = (JavaModelElement)e).getDeclaringElement() != child) continue;
                    model = m;
                    found = true;
                    break;
                }
                if (found) continue;
                return null;
            }
            return model;
        }

        public List<? extends TypeMirror> directSupertypes(TypeMirror typeMirror) {
            return this.getTypes().directSupertypes(typeMirror);
        }

        public boolean overrides(ExecutableElement overrider, ExecutableElement overriden, TypeElement type) {
            return this.getElements().overrides(overrider, overriden, type);
        }

        public Elements getElements() {
            if (this.elements == null) {
                this.elements = this.env.getElementUtils();
            }
            return this.elements;
        }

        public Types getTypes() {
            if (this.types == null) {
                this.types = this.env.getTypeUtils();
            }
            return this.types;
        }

        public TypeElement getJavaLangObject() {
            if (this.javaLangObject == null) {
                this.javaLangObject = this.getElements().getTypeElement("java.lang.Object");
            }
            return this.javaLangObject;
        }
    }
}

